/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IFoodBlock;
import frostnox.nightfall.block.INaturalVegetation;
import frostnox.nightfall.block.ISoil;
import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.block.TimeDataBlockEntity;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.Season;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.Nullable;

public class FruitBushBlock
extends BushBlock
implements EntityBlock,
ITimeSimulatedBlock,
IFoodBlock,
INaturalVegetation {
    public static final IntegerProperty STAGE = BlockStatePropertiesNF.STAGE_4;
    private static final VoxelShape SAPLING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private static final VoxelShape FULL_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public final Supplier<? extends Item> fruitItem;
    public final float minHumidity;
    public final float maxHumidity;
    public final float minTemp;
    public final float maxTemp;
    public final int minSunlight;
    public final int ticksToGrow;

    public FruitBushBlock(float minHumidity, float maxHumidity, float minTemp, float maxTemp, int minSunlight, int ticksToGrow, Supplier<? extends Item> fruitItem, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.fruitItem = fruitItem;
        this.minHumidity = minHumidity;
        this.maxHumidity = maxHumidity;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.minSunlight = minSunlight;
        this.ticksToGrow = ticksToGrow;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2)));
    }

    protected boolean checkSoilAndSky(Level level, BlockPos pos, BlockState belowState) {
        if (level.m_45517_(LightLayer.SKY, pos) >= this.minSunlight) {
            return belowState.m_204336_(TagsNF.TILLABLE_SOIL);
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int stage = (Integer)state.m_61143_((Property)STAGE);
        if (stage < 3 || pPlayer.m_21120_(pHand).m_150930_(Items.f_42751_)) {
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            FruitBushBlock.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)pPlayer, (ItemStack)ItemStack.f_41583_).forEach(drop -> {
                if (drop.m_150930_(this.fruitItem.get())) {
                    LevelUtil.giveItemToPlayer(drop, pPlayer, true);
                }
            });
        }
        level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.9f + level.f_46441_.nextFloat() * 0.2f);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2)), 2);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_204336_(TagsNF.TILLABLE_SOIL);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return (Integer)state.m_61143_((Property)STAGE) == 1 ? SAPLING_SHAPE : FULL_SHAPE;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity;
        int stage = (Integer)state.m_61143_((Property)STAGE);
        if (this.checkSoilAndSky((Level)level, pos, level.m_8055_(pos.m_7495_())) && (blockEntity = level.m_7702_(pos)) instanceof TimeDataBlockEntity) {
            TimeDataBlockEntity crop = (TimeDataBlockEntity)blockEntity;
            if (LevelData.isPresent((Level)level)) {
                float humidity;
                IChunkData chunkData;
                ILevelData levelData = LevelData.get((Level)level);
                float temp = levelData.getSeasonalTemperature(chunkData = ChunkData.get(level.m_46745_(pos)), pos);
                if (temp >= this.minTemp && temp <= this.maxTemp && (humidity = chunkData.getHumidity(pos)) >= this.minHumidity && humidity <= this.maxHumidity) {
                    if (level.m_46467_() - crop.lastProcessedTick >= (long)this.ticksToGrow && stage < 4) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
                        crop.lastProcessedTick = level.m_46467_();
                    }
                    return;
                }
            } else {
                if (level.m_46467_() - crop.lastProcessedTick >= (long)this.ticksToGrow && stage < 4) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
                    crop.lastProcessedTick = level.m_46467_();
                }
                return;
            }
        }
        level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)), 3);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{STAGE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.TIME_DATA.get()).m_155264_(pos, state);
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.LOW, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.LOW, pos);
        }
    }

    protected int simulateGrowth(int stage, long elapsedTime, double randomTickChance, Random random) {
        int stages;
        if (stage < 4 && elapsedTime > 0L && (stages = MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 4 - stage, this.ticksToGrow, random)) > 0) {
            return stage + stages;
        }
        return stage;
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        BlockEntity blockEntity = chunk.m_7702_(pos);
        if (blockEntity instanceof TimeDataBlockEntity) {
            TimeDataBlockEntity crop = (TimeDataBlockEntity)blockEntity;
            int stage = (Integer)state.m_61143_((Property)STAGE);
            BlockState belowBlock = chunk.m_8055_(pos.m_7495_());
            if (this.checkSoilAndSky((Level)level, pos, belowBlock)) {
                boolean hasHot;
                int tickAdjustedSpacing = this.ticksToGrow + (int)(1.0 / randomTickChance);
                float temp = chunkData.getTemperature(pos);
                float coldSeasonTemp = this.minTemp - temp;
                if (coldSeasonTemp >= 0.25f) {
                    if (MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 1, random) >= 1) {
                        crop.lastProcessedTick = gameTime / (long)tickAdjustedSpacing * (long)tickAdjustedSpacing;
                        level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)), 3);
                    }
                    return;
                }
                float hotSeasonTemp = this.maxTemp - temp;
                if (hotSeasonTemp <= -0.25f) {
                    if (MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 1, random) >= 1) {
                        crop.lastProcessedTick = gameTime / (long)tickAdjustedSpacing * (long)tickAdjustedSpacing;
                        level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)), 3);
                    }
                    return;
                }
                boolean hasCold = Math.abs(coldSeasonTemp) < 0.25f;
                boolean bl = hasHot = Math.abs(hotSeasonTemp) < 0.25f;
                if (elapsedTime > 1344000L) {
                    elapsedTime = 1344000L;
                }
                long adjustedElapsedTime = elapsedTime - Math.max(0L, (long)this.ticksToGrow - Math.max(0L, gameTime - elapsedTime - crop.lastProcessedTick));
                if (hasCold && hasHot) {
                    LongLongPair coldWindow = Season.getTimesAtTemperatureInfluence(coldSeasonTemp);
                    LongLongPair hotWindow = Season.getTimesAtTemperatureInfluence(hotSeasonTemp);
                    long coldTime = Season.getTimePassedWithin(seasonTime, elapsedTime, coldWindow.firstLong(), coldWindow.secondLong());
                    long hotTime = Season.getTimePassedWithin(seasonTime, elapsedTime, hotWindow.firstLong(), hotWindow.secondLong());
                    long warmTime = Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, coldWindow.secondLong(), hotWindow.firstLong());
                    long coolTime = Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, hotWindow.secondLong(), coldWindow.firstLong());
                    long modSeasonTime = seasonTime % 1344000L;
                    long lastSeasonTime = Math.floorMod(modSeasonTime - elapsedTime, 1344000L);
                    float lastSeasonalTemp = Season.getTemperatureInfluence(lastSeasonTime);
                    int newStage = stage;
                    if (lastSeasonalTemp < coldSeasonTemp) {
                        if (MathUtil.getRandomSuccesses(randomTickChance, coldTime, 1, random) >= 1) {
                            newStage = 1;
                        }
                        newStage = this.simulateGrowth(newStage, warmTime, randomTickChance, random);
                        if (MathUtil.getRandomSuccesses(randomTickChance, hotTime, 1, random) >= 1) {
                            newStage = 1;
                        }
                        newStage = this.simulateGrowth(newStage, coolTime, randomTickChance, random);
                    } else if (lastSeasonalTemp > hotSeasonTemp) {
                        if (MathUtil.getRandomSuccesses(randomTickChance, hotTime, 1, random) >= 1) {
                            newStage = 1;
                        }
                        newStage = this.simulateGrowth(newStage, coolTime, randomTickChance, random);
                        if (MathUtil.getRandomSuccesses(randomTickChance, coldTime, 1, random) >= 1) {
                            newStage = 1;
                        }
                        newStage = this.simulateGrowth(newStage, warmTime, randomTickChance, random);
                    } else if (lastSeasonTime > Math.floorMod(coldWindow.secondLong(), 1344000L) && lastSeasonTime < Math.floorMod(hotWindow.firstLong(), 1344000L)) {
                        newStage = this.simulateGrowth(newStage, warmTime, randomTickChance, random);
                        if (MathUtil.getRandomSuccesses(randomTickChance, hotTime, 1, random) >= 1) {
                            newStage = 1;
                        }
                        newStage = this.simulateGrowth(newStage, coolTime, randomTickChance, random);
                        if (MathUtil.getRandomSuccesses(randomTickChance, coldTime, 1, random) >= 1) {
                            newStage = 1;
                        }
                    } else {
                        newStage = this.simulateGrowth(newStage, coolTime, randomTickChance, random);
                        if (MathUtil.getRandomSuccesses(randomTickChance, coldTime, 1, random) >= 1) {
                            newStage = 1;
                        }
                        newStage = this.simulateGrowth(newStage, warmTime, randomTickChance, random);
                        if (MathUtil.getRandomSuccesses(randomTickChance, hotTime, 1, random) >= 1) {
                            newStage = 1;
                        }
                    }
                    if (newStage != stage) {
                        crop.lastProcessedTick = gameTime / (long)tickAdjustedSpacing * (long)tickAdjustedSpacing;
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(newStage)), 2);
                    }
                } else if (hasCold || hasHot) {
                    long modSeasonTime = seasonTime % 1344000L;
                    long lastSeasonTime = Math.floorMod(modSeasonTime - elapsedTime, 1344000L);
                    float lastSeasonalTemp = Season.getTemperatureInfluence(lastSeasonTime);
                    int newStage = stage;
                    if (hasCold) {
                        LongLongPair coldWindow = Season.getTimesAtTemperatureInfluence(coldSeasonTemp);
                        long coldTime = Season.getTimePassedWithin(seasonTime, elapsedTime, coldWindow.firstLong(), coldWindow.secondLong());
                        if (lastSeasonalTemp < coldSeasonTemp) {
                            if (MathUtil.getRandomSuccesses(randomTickChance, coldTime, 1, random) >= 1) {
                                newStage = 1;
                            }
                            newStage = this.simulateGrowth(newStage, Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, coldWindow.secondLong(), modSeasonTime), randomTickChance, random);
                        } else if (lastSeasonTime < Math.floorMod(coldWindow.firstLong(), 1344000L)) {
                            newStage = this.simulateGrowth(newStage, Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, lastSeasonTime, coldWindow.firstLong()), randomTickChance, random);
                            if (MathUtil.getRandomSuccesses(randomTickChance, coldTime, 1, random) >= 1) {
                                newStage = 1;
                            }
                            newStage = this.simulateGrowth(newStage, Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, coldWindow.secondLong(), modSeasonTime), randomTickChance, random);
                        } else {
                            newStage = this.simulateGrowth(newStage, Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, lastSeasonTime, coldWindow.firstLong()), randomTickChance, random);
                            if (MathUtil.getRandomSuccesses(randomTickChance, coldTime, 1, random) >= 1) {
                                newStage = 1;
                            }
                        }
                    } else {
                        LongLongPair hotWindow = Season.getTimesAtTemperatureInfluence(hotSeasonTemp);
                        long hotTime = Season.getTimePassedWithin(seasonTime, elapsedTime, hotWindow.firstLong(), hotWindow.secondLong());
                        if (lastSeasonalTemp > hotSeasonTemp) {
                            if (MathUtil.getRandomSuccesses(randomTickChance, hotTime, 1, random) >= 1) {
                                newStage = 1;
                            }
                            newStage = this.simulateGrowth(newStage, Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, hotWindow.secondLong(), modSeasonTime), randomTickChance, random);
                        } else if (lastSeasonTime < Math.floorMod(hotWindow.firstLong(), 1344000L)) {
                            newStage = this.simulateGrowth(newStage, Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, lastSeasonTime, hotWindow.firstLong()), randomTickChance, random);
                            if (MathUtil.getRandomSuccesses(randomTickChance, hotTime, 1, random) >= 1) {
                                newStage = 1;
                            }
                            newStage = this.simulateGrowth(newStage, Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, hotWindow.secondLong(), modSeasonTime), randomTickChance, random);
                        } else {
                            newStage = this.simulateGrowth(newStage, Season.getTimePassedWithin(seasonTime, adjustedElapsedTime, lastSeasonTime, hotWindow.firstLong()), randomTickChance, random);
                            if (MathUtil.getRandomSuccesses(randomTickChance, hotTime, 1, random) >= 1) {
                                newStage = 1;
                            }
                        }
                    }
                    if (newStage != stage) {
                        crop.lastProcessedTick = gameTime / (long)tickAdjustedSpacing * (long)tickAdjustedSpacing;
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(newStage)), 2);
                    }
                } else {
                    int newStage = this.simulateGrowth(stage, adjustedElapsedTime, randomTickChance, random);
                    if (newStage != stage) {
                        crop.lastProcessedTick = gameTime / (long)tickAdjustedSpacing * (long)tickAdjustedSpacing;
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(newStage)), 2);
                    }
                }
            } else if (MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 1, random) >= 1) {
                level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)), 3);
            }
        }
    }

    @Override
    public TickPriority getTickPriority() {
        return TickPriority.LOW;
    }

    @Override
    public boolean isEatable(BlockState state, Diet diet) {
        return (Integer)state.m_61143_((Property)STAGE) >= 3 && diet != Diet.CARNIVORE;
    }

    @Override
    public void eat(Entity eater, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2)), 2);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return null;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 100;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public BlockState getGrowthBlock() {
        return (BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1));
    }

    @Override
    public boolean canGrowAt(ServerLevel level, BlockPos pos, ISoil soil, SoilCover cover, int skyLight, float temperature, float humidity) {
        return skyLight >= this.minSunlight && temperature >= this.minTemp && temperature <= this.maxTemp && humidity >= this.minHumidity && humidity <= this.maxHumidity;
    }
}

