/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.block.BlockNF;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.math.OctalDirection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HatchBlock
extends BlockNF
implements IWaterloggedBlock,
ICustomPathfindable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    protected static final float HALF_THICKNESS = 0.09375f;
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final List<AABB> NORTH_FACE_Y = NORTH_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_FACE_Y = SOUTH_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> WEST_FACE_Y = WEST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> EAST_FACE_Y = EAST_SHAPE.m_83263_(Direction.UP).m_83299_();
    public final Supplier<SoundEvent> openSound;
    public final Supplier<SoundEvent> closeSound;

    public HatchBlock(BlockBehaviour.Properties properties, Supplier<SoundEvent> openSound, Supplier<SoundEvent> closeSound) {
        super(properties);
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    public Direction getHingeDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        direction = state.m_61143_(HINGE) == DoorHingeSide.RIGHT ? direction.m_122427_() : direction.m_122428_();
        return direction;
    }

    public Direction getFacingDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return direction;
        }
        return state.m_61143_(HINGE) == DoorHingeSide.RIGHT ? direction.m_122428_() : direction.m_122427_();
    }

    protected void playSound(@Nullable Player player, Level level, BlockPos pos, boolean open) {
        level.m_5594_(player, pos, open ? this.openSound.get() : this.closeSound.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.nextFloat());
        level.m_142346_((Entity)player, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, OPEN, HINGE, WATER_LEVEL, WATERLOG_TYPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (this.getFacingDirection(state)) {
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (this.getHingeDirection(state) == facing && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        this.tickLiquid(state, currentPos, level);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        DoorHingeSide hinge;
        double off;
        Direction dir = context.m_43719_();
        boolean vertical = dir.m_122434_().m_122478_();
        if (vertical) {
            dir = context.m_8125_();
        }
        Vec3 clickLoc = context.m_43720_();
        double d = off = dir.m_122434_() == Direction.Axis.Z ? clickLoc.f_82479_ % 1.0 : clickLoc.f_82481_ % 1.0;
        if (off < 0.0) {
            off += 1.0;
        }
        if (vertical) {
            double off2 = dir.m_122434_() != Direction.Axis.Z ? clickLoc.f_82479_ % 1.0 : clickLoc.f_82481_ % 1.0;
            Direction.AxisDirection axisDir = dir.m_122421_();
            if (off2 < 0.0) {
                axisDir = axisDir.m_122541_();
            }
            off2 = Math.abs(off2);
            if (axisDir == Direction.AxisDirection.POSITIVE) {
                if (off2 > 0.5) {
                    dir = dir.m_122424_();
                }
            } else if (off2 < 0.5) {
                dir = dir.m_122424_();
            }
            DoorHingeSide doorHingeSide = (off2 > 0.5 ? off <= 0.5 : off > 0.5) ? DoorHingeSide.LEFT : (hinge = DoorHingeSide.RIGHT);
            if (!this.m_7898_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir)).m_61124_(HINGE, (Comparable)hinge), (LevelReader)context.m_43725_(), context.m_8083_())) {
                hinge = hinge == DoorHingeSide.RIGHT ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
        } else if (dir == Direction.NORTH || dir == Direction.EAST) {
            hinge = off > 0.5 ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            dir = off > 0.5 ? dir.m_122428_() : dir.m_122427_();
        } else {
            hinge = off > 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
            dir = off > 0.5 ? dir.m_122427_() : dir.m_122428_();
        }
        return this.addLiquidToPlacement((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir)).m_61124_(HINGE, (Comparable)hinge)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)), context);
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 3);
        this.tickLiquid(state, pos, (LevelAccessor)level);
        this.playSound(pPlayer, level, pos, (Boolean)state.m_61143_((Property)OPEN));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = this.getHingeDirection(state);
        return LevelUtil.isBlockFullySupportedHorizontally(((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_60808_((BlockGetter)level, pos).m_83215_(), level, pos.m_142300_(direction), direction.m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation pRotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        return pMirror == Mirror.NONE ? state : (BlockState)state.m_60717_(pMirror.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        OctalDirection gapDirection = OctalDirection.fromDirection(this.getFacingDirection(state));
        return this.getTypeForThinSideClosedShape(nodeManager, state, level, pos, gapDirection, 0.09375f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return switch (this.getFacingDirection(state)) {
            case Direction.SOUTH -> SOUTH_FACE_Y;
            case Direction.WEST -> WEST_FACE_Y;
            case Direction.NORTH -> NORTH_FACE_Y;
            default -> EAST_FACE_Y;
        };
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return this.getTopFaceShape(state);
    }

    @Override
    public OctalDirection getDirection(BlockState state) {
        return OctalDirection.fromDirection(this.getFacingDirection(state)).getOpposite();
    }
}

