/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IHeatSource;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.registry.forge.FluidsNF;
import java.util.Comparator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class HeatablePileBlock
extends Block
implements IWaterloggedBlock {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    public static final IntegerProperty HEAT = BlockStatePropertiesNF.HEAT;
    public static final BooleanProperty CHANGED = BlockStatePropertiesNF.CHANGED;
    public final IntegerProperty count;
    private final VoxelShape[] shapes;

    public HeatablePileBlock(IntegerProperty count, BlockBehaviour.Properties properties, VoxelShape ... shapes) {
        super(properties);
        this.count = count;
        this.shapes = shapes;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)count, (Comparable)Integer.valueOf(1))).m_61124_((Property)HEAT, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH))).m_61124_((Property)CHANGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isHeated(BlockState state, Level level, BlockPos pos) {
        Block block;
        if ((Integer)state.m_61143_((Property)WATER_LEVEL) <= 0 && (block = level.m_8055_(pos.m_7495_()).m_60734_()) instanceof IHeatSource) {
            IHeatSource heatSource = (IHeatSource)block;
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_21120_(hand).m_41619_()) {
            if (!level.m_5776_() && player.m_150109_().m_36054_(new ItemStack((ItemLike)this.m_5456_(), 1))) {
                if ((Integer)(state = (BlockState)state.m_61124_((Property)CHANGED, (Comparable)Boolean.valueOf(true))).m_61143_((Property)this.count) > 1) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.count, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)this.count) - 1)), 3);
                } else {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
                level.m_5594_(null, pos, state.m_60827_().m_56777_(), SoundSource.BLOCKS, state.m_60827_().m_56773_(), state.m_60827_().m_56774_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        level.m_186460_(pos, (Block)this, 60);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        if ((Integer)state.m_61143_((Property)HEAT) > 0 && level.m_46758_(pos.m_7494_()) && level.m_5822_().nextFloat() < 0.025f * (float)((Integer)state.m_61143_((Property)this.count)).intValue()) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.15f, 2.0f + level.m_5822_().nextFloat() * 0.5f, false);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_() + rand.nextDouble() * 0.25, (double)pos.m_123343_() + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity pEntity) {
        int heat = (Integer)state.m_61143_((Property)HEAT);
        if (!pEntity.m_5825_() && pEntity.f_19802_ <= 10 && heat > 0 && pEntity instanceof LivingEntity) {
            pEntity.m_6469_((DamageSource)DamageTypeSource.HOT_FLOOR, 0.75f + 0.25f * (float)heat);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        level.m_186460_(pos, (Block)this, 60);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext pUseContext) {
        return !pUseContext.m_7078_() && pUseContext.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)this.count) < (Integer)this.count.m_6908_().stream().max(Comparator.naturalOrder()).get() || super.m_6864_(state, pUseContext);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            blockstate = (BlockState)blockstate.m_61124_((Property)HEAT, (Comparable)Integer.valueOf(1));
            return (BlockState)blockstate.m_61122_((Property)this.count);
        }
        blockstate = super.m_5573_(context);
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (fluidstate.m_76152_() == FluidsNF.WATER.get()) {
            return (BlockState)blockstate.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(7));
        }
        if (fluidstate.m_76152_() == FluidsNF.WATER_FLOWING.get() && fluidstate.m_76186_() > this.getExcludedWaterLevel(blockstate)) {
            return (BlockState)blockstate.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(fluidstate.m_76186_()));
        }
        return blockstate;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Block block;
        if (!state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        this.tickLiquid(state, pos, level);
        if (!level.m_5776_() && facing == Direction.DOWN && (block = facingState.m_60734_()) instanceof IHeatSource) {
            IHeatSource heatSource = (IHeatSource)block;
            level.m_186460_(pos, (Block)this, 60);
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes[(Integer)state.m_61143_((Property)this.count) - 1];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HEAT, WATER_LEVEL, CHANGED, WATERLOG_TYPE});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluid) {
        boolean result = IWaterloggedBlock.super.m_7361_(level, pos, state, fluid);
        if (result && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((Integer)state.m_61143_((Property)HEAT) > 0) {
                level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)HEAT, (Comparable)Integer.valueOf(1)), 3);
                serverLevel.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.8f, 1.0f);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 10 + level.m_5822_().nextInt() % 4, 0.3, 0.1, 0.3, 0.0);
            }
        }
        return result;
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }
}

