/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.math.OctalDirection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LadderBlockNF
extends HorizontalDirectionalBlock
implements IWaterloggedBlock,
ICustomPathfindable {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    protected static final float HALF_THICKNESS = 0.09375f;
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final List<AABB> NORTH_FACE_Y = NORTH_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_FACE_Y = SOUTH_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> WEST_FACE_Y = WEST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> EAST_FACE_Y = EAST_SHAPE.m_83263_(Direction.UP).m_83299_();

    public LadderBlockNF(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, WATER_LEVEL, WATERLOG_TYPE});
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos oppPos = pos.m_142300_(direction.m_122424_());
        return level.m_8055_(oppPos).m_60783_((BlockGetter)level, oppPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122424_() == state.m_61143_((Property)f_54117_) && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        this.tickLiquid(state, currentPos, level);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate;
        if (!context.m_7058_() && (blockstate = context.m_43725_().m_8055_(context.m_8083_().m_142300_(context.m_43719_().m_122424_()))).m_60713_((Block)this) && blockstate.m_61143_((Property)f_54117_) == context.m_43719_()) {
            return null;
        }
        Level levelreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate1;
            if (!direction.m_122434_().m_122479_() || !(blockstate1 = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction.m_122424_())).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return this.addLiquidToPlacement(blockstate1, context);
        }
        return null;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return !entity.m_20096_();
    }

    public boolean makesOpenTrapdoorAboveClimbable(BlockState state, LevelReader level, BlockPos pos, BlockState trapdoorState) {
        return state.m_61143_((Property)f_54117_) == trapdoorState.m_61143_((Property)TrapDoorBlock.f_54117_);
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        OctalDirection gapDirection = OctalDirection.fromDirection((Direction)state.m_61143_((Property)f_54117_));
        return this.getTypeForThinSideClosedShape(nodeManager, state, level, pos, gapDirection, 0.09375f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> NORTH_FACE_Y;
            case Direction.SOUTH -> SOUTH_FACE_Y;
            case Direction.WEST -> WEST_FACE_Y;
            default -> EAST_FACE_Y;
        };
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return this.getTopFaceShape(state);
    }

    @Override
    public OctalDirection getDirection(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> OctalDirection.SOUTH;
            case Direction.SOUTH -> OctalDirection.NORTH;
            case Direction.WEST -> OctalDirection.EAST;
            default -> OctalDirection.WEST;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LevelUtil.pickCloneItem(state.m_60734_(), player);
    }
}

