/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IIgnitable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LanternBlockNF
extends LanternBlock
implements IWaterloggedBlock,
IIgnitable,
ICustomPathfindable {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    protected static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    protected static final VoxelShape HANGING_COLLISION_SHAPE = Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    protected static final List<AABB> TOP_FACE = List.of((AABB)COLLISION_SHAPE.m_83299_().get(0));
    public final boolean lit;
    public final Supplier<? extends Block> oppositeBlock;

    public LanternBlockNF(boolean lit, Supplier<? extends Block> oppositeBlock, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.lit = lit;
        this.oppositeBlock = oppositeBlock;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)f_153459_) != false ? HANGING_COLLISION_SHAPE : COLLISION_SHAPE;
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.tickLiquid(state, currentPos, level);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.addLiquidToPlacement(super.m_5573_(context), context);
        if (this.lit && state != null && (Integer)state.m_61143_((Property)WATER_LEVEL) > ((Boolean)state.m_61143_((Property)f_153459_) != false ? 1 : 0)) {
            state = this.copyLiquid(state, this.oppositeBlock.get().m_49966_());
            context.m_43725_().m_5594_(context.m_43723_(), context.m_8083_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.2f + context.m_43725_().f_46441_.nextFloat());
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATER_LEVEL, WATERLOG_TYPE});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)f_153459_)).booleanValue()) {
            nodeManager.getNode((BlockPos)pos).partial = true;
            return NodeType.CLOSED;
        }
        return this.getTypeForCenteredBottomShape(nodeManager, pos, 0.4375f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)f_153459_) != false ? NodeType.CLOSED : NodeType.OPEN;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_153459_) != false ? NO_BOXES : TOP_FACE;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return NO_BOXES;
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public BlockState copyLiquid(BlockState oldState, BlockState newState) {
        return (BlockState)IWaterloggedBlock.super.copyLiquid(oldState, newState).m_61124_((Property)f_153459_, (Comparable)((Boolean)oldState.m_61143_((Property)f_153459_)));
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluid) {
        boolean result = IWaterloggedBlock.super.m_7361_(level, pos, state, fluid);
        if (result && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.lit) {
                level.m_7731_(pos, this.copyLiquid(level.m_8055_(pos), this.oppositeBlock.get().m_49966_()), 3);
                serverLevel.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.2f + serverLevel.f_46441_.nextFloat());
            }
        }
        return result;
    }

    @Override
    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid pFluid) {
        return IWaterloggedBlock.super.m_6044_(level, pos, state, pFluid);
    }

    @Override
    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        return IWaterloggedBlock.super.m_142598_(level, pos, state);
    }

    @Override
    public Optional<SoundEvent> m_142298_() {
        return IWaterloggedBlock.super.m_142298_();
    }

    @Override
    public boolean tryToIgnite(Level level, BlockPos pos, BlockState state, ItemStack stack, TieredHeat heat) {
        if (level.m_5776_()) {
            return false;
        }
        if (!this.lit) {
            level.m_46597_(pos, this.oppositeBlock.get().m_49966_());
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnited(BlockState state) {
        return this.lit;
    }
}

