/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.IHeatable;
import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.BlockNF;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.Season;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.ticks.TickPriority;

public class MeltableBlock
extends BlockNF
implements IHeatable,
ITimeSimulatedBlock {
    public final Supplier<? extends Block> meltBlock;
    public final float meltTemp;

    public MeltableBlock(Supplier<? extends Block> meltBlock, float meltTemp, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.meltBlock = meltBlock;
        this.meltTemp = meltTemp;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (LevelData.isPresent((Level)level) && LevelData.get((Level)level).getSeasonalTemperature(ChunkData.get(level.m_46745_(pos)), pos) > this.meltTemp) {
            level.m_46597_(pos, this.meltBlock.get().m_49966_());
        }
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        IChunkData chunkData;
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level) && (chunkData = ChunkData.get(level.m_46745_(pos))).getTemperature(pos) >= this.meltTemp - 0.25f) {
            chunkData.addSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        IChunkData chunkData;
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level) && (chunkData = ChunkData.get(level.m_46745_(pos))).getTemperature(pos) >= this.meltTemp - 0.25f) {
            chunkData.removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    @Override
    public void applyHeat(Level level, BlockPos pos, BlockState state, TieredHeat heat, Direction fromDir) {
        if (heat != TieredHeat.NONE) {
            level.m_46597_(pos, this.meltBlock.get().m_49966_());
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        float temperature = chunkData.getTemperature(pos);
        float seasonalFreezeTemp = this.meltTemp - temperature;
        LongLongPair freezeWindow = Season.getTimesAtTemperatureInfluence(seasonalFreezeTemp);
        if (seasonalTemp > seasonalFreezeTemp && MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(seasonTime, elapsedTime % 1344001L, freezeWindow.secondLong(), seasonTime % 1344000L), 1, random) >= 1) {
            level.m_46597_(pos, this.meltBlock.get().m_49966_());
        }
    }
}

