/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.IDropsItems;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public abstract class MenuContainerBlockEntity
extends RandomizableContainerBlockEntity
implements Container,
IDropsItems {
    public boolean orderedLoot;

    public MenuContainerBlockEntity(BlockEntityType<?> pType, BlockPos pos, BlockState pBlockState) {
        super(pType, pos, pBlockState);
    }

    @Nullable
    public ContainerData getData() {
        return null;
    }

    public abstract ItemStackHandlerNF getInventory();

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (!this.m_59631_(tag)) {
            this.getInventory().deserializeNBT(tag.m_128469_("inventory"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            tag.m_128365_("inventory", (Tag)this.getInventory().serializeNBT());
        }
    }

    protected boolean m_59631_(CompoundTag pTag) {
        if (super.m_59631_(pTag)) {
            this.orderedLoot = pTag.m_128471_("orderedLoot");
            return true;
        }
        return false;
    }

    protected boolean m_59634_(CompoundTag pTag) {
        if (super.m_59634_(pTag)) {
            pTag.m_128379_("orderedLoot", this.orderedLoot);
            return true;
        }
        return false;
    }

    public void m_59640_(@Nullable Player player) {
        if (this.f_59605_ != null && this.f_58857_.m_142572_() != null) {
            LootTable table = this.f_58857_.m_142572_().m_129898_().m_79217_(this.f_59605_);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, this.f_59605_);
            }
            this.f_59605_ = null;
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78965_(this.f_59606_);
            if (player != null) {
                builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            LootContext context = builder.m_78975_(LootContextParamSets.f_81411_);
            if (this.orderedLoot) {
                List randomItems = table.m_79129_(context);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (ItemStack randomItem : randomItems) {
                    boolean combined = false;
                    for (ItemStack item : items) {
                        if (item.m_41613_() >= item.m_41741_() || !ItemStack.m_150942_((ItemStack)randomItem, (ItemStack)item)) continue;
                        item.m_41769_(randomItem.m_41620_(Math.min(randomItem.m_41613_(), item.m_41741_() - item.m_41613_())).m_41613_());
                        combined = randomItem.m_41619_();
                        break;
                    }
                    if (combined) continue;
                    items.add(randomItem);
                }
                int i = 0;
                int size = this.m_6643_();
                for (ItemStack item : items) {
                    if (item.m_41619_()) continue;
                    if (i >= size) {
                        Nightfall.LOGGER.warn("Tried to over-fill a container");
                        return;
                    }
                    while (!this.m_8020_(i).m_41619_()) {
                        ++i;
                    }
                    this.m_6836_(i, item);
                    ++i;
                }
            } else {
                table.m_79123_((Container)this, context);
            }
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.getInventory().copyItems();
    }

    protected void m_6520_(NonNullList<ItemStack> pItemStacks) {
        for (int i = 0; i < pItemStacks.size(); ++i) {
            this.getInventory().setStackInSlot(i, (ItemStack)pItemStacks.get(i));
        }
    }

    public int m_6643_() {
        return this.getInventory().getSlots();
    }

    public boolean m_7983_() {
        this.m_59640_(null);
        return this.getInventory().isEmpty();
    }

    public ItemStack m_8020_(int pSlot) {
        this.m_59640_(null);
        return this.getInventory().getStackInSlot(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        this.m_59640_(null);
        return this.getInventory().extractItem(pSlot, pAmount, false);
    }

    public ItemStack m_8016_(int pSlot) {
        this.m_59640_(null);
        return this.getInventory().extractItemNoUpdate(pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.m_59640_(null);
        this.getInventory().setStackInSlot(pSlot, pStack);
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.m_58899_()) == this && this.m_58899_().m_203193_((Position)player.m_146892_()) <= 36.0;
    }

    @Override
    public NonNullList<ItemStack> getContainerDrops() {
        return this.m_7086_();
    }

    public void m_6211_() {
        this.getInventory().clear();
    }
}

