/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.block.BlockNF;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.math.OctalDirection;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SidingBlock
extends BlockNF
implements IWaterloggedBlock,
ICustomPathfindable {
    public static final EnumProperty<Type> TYPE = BlockStatePropertiesNF.SIDING_TYPE;
    public static final EnumProperty<Shape> SHAPE = BlockStatePropertiesNF.SIDING_SHAPE;
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape NORTH_EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_WEST_INNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0));
    protected static final VoxelShape NORTH_EAST_INNER_SHAPE = MathUtil.rotate(NORTH_WEST_INNER_SHAPE, Rotation.CLOCKWISE_90);
    protected static final VoxelShape SOUTH_WEST_INNER_SHAPE = MathUtil.rotate(NORTH_WEST_INNER_SHAPE, Rotation.COUNTERCLOCKWISE_90);
    protected static final VoxelShape SOUTH_EAST_INNER_SHAPE = MathUtil.rotate(NORTH_WEST_INNER_SHAPE, Rotation.CLOCKWISE_180);
    protected static final List<AABB> NORTH_FACE_Y = NORTH_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_FACE_Y = SOUTH_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> WEST_FACE_Y = WEST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> EAST_FACE_Y = EAST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> NORTH_WEST_FACE_Y = NORTH_WEST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> NORTH_EAST_FACE_Y = NORTH_EAST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_WEST_FACE_Y = SOUTH_WEST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_EAST_FACE_Y = SOUTH_EAST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> NORTH_WEST_INNER_FACE_Y = NORTH_WEST_INNER_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> NORTH_EAST_INNER_FACE_Y = NORTH_EAST_INNER_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_WEST_INNER_FACE_Y = SOUTH_WEST_INNER_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_EAST_INNER_FACE_Y = SOUTH_EAST_INNER_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final EnumMap<Direction, Direction[]> UPDATE_SHAPE_DIRECTIONS = new EnumMap(Direction.class);
    public final BlockState baseState;
    public final Block base;

    public SidingBlock(Supplier<? extends Block> baseBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.baseState = baseBlock.get().m_49966_();
        this.base = baseBlock.get();
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)Type.EAST))).m_61124_(SHAPE, (Comparable)((Object)Shape.FULL))).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    protected Shape getSidingShape(LevelAccessor level, BlockPos pos, Direction curDir) {
        Direction dir2;
        BlockState state2;
        Direction dir1;
        BlockState state1 = level.m_8055_(pos.m_142300_(curDir));
        if (state1.m_60734_() instanceof SidingBlock && ((Shape)((Object)state1.m_61143_(SidingBlock.SHAPE))).inner && state1.m_61143_(TYPE) != Type.DOUBLE && (dir1 = ((Type)((Object)state1.m_61143_(SidingBlock.TYPE))).direction).m_122434_() != curDir.m_122434_() && (state2 = level.m_8055_(pos.m_142300_(dir1))).m_60734_() instanceof SidingBlock && ((Shape)((Object)state2.m_61143_(SidingBlock.SHAPE))).inner && state2.m_61143_(TYPE) != Type.DOUBLE && curDir == (dir2 = ((Type)((Object)state2.m_61143_(SidingBlock.TYPE))).direction)) {
            if (curDir == Direction.SOUTH || curDir == Direction.WEST) {
                return dir1.m_122421_() == Direction.AxisDirection.NEGATIVE ? Shape.POSITIVE_QUARTET : Shape.NEGATIVE_QUARTET;
            }
            return dir1.m_122421_() == Direction.AxisDirection.NEGATIVE ? Shape.NEGATIVE_QUARTET : Shape.POSITIVE_QUARTET;
        }
        state1 = level.m_8055_(pos.m_142300_(curDir = curDir.m_122424_()));
        if (state1.m_60734_() instanceof SidingBlock && ((Shape)((Object)state1.m_61143_(SidingBlock.SHAPE))).inner && state1.m_61143_(TYPE) != Type.DOUBLE && (dir1 = ((Type)((Object)state1.m_61143_(SidingBlock.TYPE))).direction.m_122424_()).m_122434_() != curDir.m_122434_()) {
            if (curDir == Direction.SOUTH || curDir == Direction.WEST) {
                return dir1.m_122421_() == Direction.AxisDirection.NEGATIVE ? Shape.POSITIVE_INNER : Shape.NEGATIVE_INNER;
            }
            return dir1.m_122421_() == Direction.AxisDirection.NEGATIVE ? Shape.NEGATIVE_INNER : Shape.POSITIVE_INNER;
        }
        return Shape.FULL;
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != Type.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{TYPE, SHAPE, WATER_LEVEL, WATERLOG_TYPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Type type = (Type)((Object)state.m_61143_(TYPE));
        if (type == Type.DOUBLE) {
            return Shapes.m_83144_();
        }
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        if (shape == Shape.FULL) {
            return switch (type) {
                case Type.NORTH -> NORTH_SHAPE;
                case Type.SOUTH -> SOUTH_SHAPE;
                case Type.WEST -> WEST_SHAPE;
                default -> EAST_SHAPE;
            };
        }
        return switch (type) {
            case Type.NORTH -> {
                if (shape.positive) {
                    if (shape.inner) {
                        yield NORTH_EAST_INNER_SHAPE;
                    }
                    yield NORTH_EAST_SHAPE;
                }
                if (shape.inner) {
                    yield NORTH_WEST_INNER_SHAPE;
                }
                yield NORTH_WEST_SHAPE;
            }
            case Type.SOUTH -> {
                if (shape.positive) {
                    if (shape.inner) {
                        yield SOUTH_WEST_INNER_SHAPE;
                    }
                    yield SOUTH_WEST_SHAPE;
                }
                if (shape.inner) {
                    yield SOUTH_EAST_INNER_SHAPE;
                }
                yield SOUTH_EAST_SHAPE;
            }
            case Type.WEST -> {
                if (shape.positive) {
                    if (shape.inner) {
                        yield NORTH_WEST_INNER_SHAPE;
                    }
                    yield NORTH_WEST_SHAPE;
                }
                if (shape.inner) {
                    yield SOUTH_WEST_INNER_SHAPE;
                }
                yield SOUTH_WEST_SHAPE;
            }
            default -> {
                if (shape.positive) {
                    if (shape.inner) {
                        yield SOUTH_EAST_INNER_SHAPE;
                    }
                    yield SOUTH_EAST_SHAPE;
                }
                yield shape.inner ? NORTH_EAST_INNER_SHAPE : NORTH_EAST_SHAPE;
            }
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        double off;
        BlockPos clickPos = context.m_8083_();
        BlockState clickState = context.m_43725_().m_8055_(clickPos);
        if (clickState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)clickState.m_61124_(TYPE, (Comparable)((Object)Type.DOUBLE))).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0));
        }
        Direction dir = context.m_43719_();
        boolean vertical = dir.m_122434_().m_122478_();
        if (vertical) {
            dir = context.m_8125_();
        }
        Vec3 clickLoc = context.m_43720_();
        double d = off = dir.m_122434_() == Direction.Axis.Z ? clickLoc.f_82479_ % 1.0 : clickLoc.f_82481_ % 1.0;
        if (off < 0.0) {
            off += 1.0;
        }
        if (vertical) {
            double off2 = dir.m_122434_() != Direction.Axis.Z ? clickLoc.f_82479_ % 1.0 : clickLoc.f_82481_ % 1.0;
            Direction.AxisDirection axisDir = dir.m_122421_();
            if (off2 < 0.0) {
                axisDir = axisDir.m_122541_();
            }
            off2 = Math.abs(off2);
            if (axisDir == Direction.AxisDirection.NEGATIVE) {
                if (off2 > 0.5) {
                    dir = dir.m_122424_();
                }
            } else if (off2 < 0.5) {
                dir = dir.m_122424_();
            }
        } else {
            dir = dir == Direction.SOUTH || dir == Direction.WEST ? (off > 0.5 ? dir.m_122428_() : dir.m_122427_()) : (off > 0.5 ? dir.m_122427_() : dir.m_122428_());
        }
        Shape shape = this.getSidingShape((LevelAccessor)context.m_43725_(), clickPos, dir);
        return this.addLiquidToPlacement((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)Type.fromDirection(dir)))).m_61124_(SHAPE, (Comparable)((Object)shape)), context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        Type type = (Type)((Object)state.m_61143_(TYPE));
        if (type != Type.DOUBLE && state.m_61143_(SHAPE) == Shape.FULL && itemstack.m_150930_(this.m_5456_())) {
            if (pUseContext.m_7058_()) {
                Direction direction = pUseContext.m_43719_();
                if (type == Type.NORTH) {
                    return direction == Direction.SOUTH;
                }
                if (type == Type.SOUTH) {
                    return direction == Direction.NORTH;
                }
                if (type == Type.WEST) {
                    return direction == Direction.EAST;
                }
                if (type == Type.EAST) {
                    return direction == Direction.WEST;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Direction curDir = ((Type)((Object)state.m_61143_(SidingBlock.TYPE))).direction;
        if (curDir.m_122434_().m_122479_()) {
            for (Direction dir : UPDATE_SHAPE_DIRECTIONS.get(curDir)) {
                if (dir.m_122434_() != facing.m_122434_()) continue;
                Shape shape = this.getSidingShape(level, currentPos, curDir);
                if (state.m_61143_(SHAPE) == shape) continue;
                state = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getSidingShape(level, currentPos, curDir)));
                break;
            }
        }
        this.tickLiquid(state, currentPos, level);
        return state;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> {
                if (state.m_61143_(TYPE) != Type.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        Type type = (Type)((Object)state.m_61143_(TYPE));
        if (type == Type.DOUBLE) {
            return 7;
        }
        return 0;
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        Type type = (Type)((Object)state.m_61143_(TYPE));
        if (type != Type.DOUBLE) {
            OctalDirection[] gapDirections;
            Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
            if (shape == Shape.FULL) {
                gapDirections = switch (type) {
                    case Type.NORTH -> OctalDirection.SOUTH_SINGLE;
                    case Type.SOUTH -> OctalDirection.NORTH_SINGLE;
                    case Type.WEST -> OctalDirection.EAST_SINGLE;
                    default -> OctalDirection.WEST_SINGLE;
                };
            } else if (shape.inner) {
                gapDirections = switch (type) {
                    case Type.NORTH -> {
                        if (shape.positive) {
                            yield OctalDirection.SOUTHWEST_SINGLE;
                        }
                        yield OctalDirection.SOUTHEAST_SINGLE;
                    }
                    case Type.SOUTH -> {
                        if (shape.positive) {
                            yield OctalDirection.NORTHEAST_SINGLE;
                        }
                        yield OctalDirection.NORTHWEST_SINGLE;
                    }
                    case Type.WEST -> {
                        if (shape.positive) {
                            yield OctalDirection.SOUTHEAST_SINGLE;
                        }
                        yield OctalDirection.NORTHEAST_SINGLE;
                    }
                    default -> shape.positive ? OctalDirection.NORTHWEST_SINGLE : OctalDirection.SOUTHWEST_SINGLE;
                };
            } else {
                gapDirections = switch (type) {
                    case Type.NORTH -> {
                        if (shape.positive) {
                            yield OctalDirection.SOUTH_AND_WEST;
                        }
                        yield OctalDirection.SOUTH_AND_EAST;
                    }
                    case Type.SOUTH -> {
                        if (shape.positive) {
                            yield OctalDirection.NORTH_AND_EAST;
                        }
                        yield OctalDirection.NORTH_AND_WEST;
                    }
                    case Type.WEST -> {
                        if (shape.positive) {
                            yield OctalDirection.SOUTH_AND_EAST;
                        }
                        yield OctalDirection.NORTH_AND_EAST;
                    }
                    default -> shape.positive ? OctalDirection.NORTH_AND_WEST : OctalDirection.SOUTH_AND_WEST;
                };
            }
            float y = pos.m_123342_();
            for (OctalDirection gapDirection : gapDirections) {
                float z;
                float x = (float)pos.m_123341_() + 0.5f + gapDirection.xStepHalf;
                if (nodeManager.collidesWith(nodeManager.getEntityBox(x, y, z = (float)pos.m_123343_() + 0.5f + gapDirection.zStepHalf, 1.0))) continue;
                nodeManager.getNode(pos).setPartialPath(x, y, z);
                return this.hasAnyFloorAt(state, pos, level) ? NodeType.WALKABLE : NodeType.OPEN;
            }
            nodeManager.getNode((BlockPos)pos).partial = true;
        }
        return NodeType.CLOSED;
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        Type type = (Type)((Object)state.m_61143_(TYPE));
        if (type == Type.DOUBLE) {
            return FULL_BOXES;
        }
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        if (shape == Shape.FULL) {
            return switch (type) {
                case Type.NORTH -> NORTH_FACE_Y;
                case Type.SOUTH -> SOUTH_FACE_Y;
                case Type.WEST -> WEST_FACE_Y;
                default -> EAST_FACE_Y;
            };
        }
        return switch (type) {
            case Type.NORTH -> {
                if (shape.positive) {
                    if (shape.inner) {
                        yield NORTH_EAST_INNER_FACE_Y;
                    }
                    yield NORTH_EAST_FACE_Y;
                }
                if (shape.inner) {
                    yield NORTH_WEST_INNER_FACE_Y;
                }
                yield NORTH_WEST_FACE_Y;
            }
            case Type.SOUTH -> {
                if (shape.positive) {
                    if (shape.inner) {
                        yield SOUTH_WEST_INNER_FACE_Y;
                    }
                    yield SOUTH_WEST_FACE_Y;
                }
                if (shape.inner) {
                    yield SOUTH_EAST_INNER_FACE_Y;
                }
                yield SOUTH_EAST_FACE_Y;
            }
            case Type.WEST -> {
                if (shape.positive) {
                    if (shape.inner) {
                        yield NORTH_WEST_INNER_FACE_Y;
                    }
                    yield NORTH_WEST_FACE_Y;
                }
                if (shape.inner) {
                    yield SOUTH_WEST_INNER_FACE_Y;
                }
                yield SOUTH_WEST_FACE_Y;
            }
            default -> {
                if (shape.positive) {
                    if (shape.inner) {
                        yield SOUTH_EAST_INNER_FACE_Y;
                    }
                    yield SOUTH_EAST_FACE_Y;
                }
                yield shape.inner ? NORTH_EAST_INNER_FACE_Y : NORTH_EAST_FACE_Y;
            }
        };
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return this.getTopFaceShape(state);
    }

    @Override
    public OctalDirection getDirection(BlockState state) {
        Type type = (Type)((Object)state.m_61143_(TYPE));
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        if (shape == Shape.FULL) {
            return switch (type) {
                case Type.NORTH -> OctalDirection.NORTH;
                case Type.SOUTH -> OctalDirection.SOUTH;
                case Type.WEST -> OctalDirection.WEST;
                default -> OctalDirection.EAST;
            };
        }
        return switch (type) {
            case Type.SOUTH -> {
                if (shape.positive) {
                    yield OctalDirection.SOUTHWEST;
                }
                yield OctalDirection.SOUTHEAST;
            }
            case Type.NORTH -> {
                if (shape.positive) {
                    yield OctalDirection.NORTHEAST;
                }
                yield OctalDirection.NORTHWEST;
            }
            case Type.EAST -> {
                if (shape.positive) {
                    yield OctalDirection.SOUTHEAST;
                }
                yield OctalDirection.NORTHEAST;
            }
            default -> shape.positive ? OctalDirection.NORTHWEST : OctalDirection.SOUTHWEST;
        };
    }

    public BlockState m_6843_(BlockState state, Rotation pRot) {
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.fromDirection(pRot.m_55954_(((Type)((Object)state.m_61143_(SidingBlock.TYPE))).direction))));
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        Direction direction = ((Type)((Object)state.m_61143_(SidingBlock.TYPE))).direction;
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() == Direction.Axis.Z) {
                    return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)shape.getOpposite()));
                }
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)shape.getOpposite()));
            }
            case FRONT_BACK: {
                if (direction.m_122434_() == Direction.Axis.X) {
                    return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)shape.getOpposite()));
                }
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)shape.getOpposite()));
            }
        }
        return super.m_6943_(state, pMirror);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        this.baseState.m_60734_().m_142072_(level, state, pos, entity, fallDistance);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random pRand) {
        this.base.m_7100_(state, level, pos, pRand);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player pPlayer) {
        this.baseState.m_60686_(level, pos, pPlayer);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        this.base.m_6786_(level, pos, state);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseState.m_60690_(level, pos, Blocks.f_50016_, pos, false);
            this.base.m_6807_(this.baseState, level, pos, pOldState, false);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        if (!state.m_60713_(pNewState.m_60734_())) {
            this.baseState.m_60753_(level, pos, pNewState, pIsMoving);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity pEntity) {
        this.base.m_141947_(level, pos, state, pEntity);
    }

    public boolean m_6724_(BlockState state) {
        return this.base.m_6724_(state);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        this.base.m_7455_(state, level, pos, random);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random pRand) {
        this.base.m_7458_(state, level, pos, pRand);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return this.baseState.m_60664_(level, pPlayer, pHand, pHit);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion pExplosion) {
        this.base.m_7592_(level, pos, pExplosion);
    }

    public boolean m_6104_(BlockState state, BlockState pAdjacentBlockState, Direction pSide) {
        return this.base.m_6104_(state, pAdjacentBlockState, pSide);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.base.m_5909_(state, level, pos, context);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.base.m_7749_(state, level, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter pReader, BlockPos pos) {
        return this.base.m_7420_(state, pReader, pos);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile pProjectile) {
        this.base.m_5581_(level, state, pHit, pProjectile);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Integer)state.m_61143_((Property)WATER_LEVEL) != 0 ? 0 : this.baseState.getFireSpreadSpeed(level, pos, direction);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Integer)state.m_61143_((Property)WATER_LEVEL) != 0 ? 0 : this.baseState.getFlammability(level, pos, direction);
    }

    static {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            UPDATE_SHAPE_DIRECTIONS.put(dir, new Direction[]{dir, dir.m_122427_(), dir.m_122428_()});
        }
    }

    public static enum Type implements StringRepresentable
    {
        NORTH("north", Direction.NORTH),
        SOUTH("south", Direction.SOUTH),
        WEST("west", Direction.WEST),
        EAST("east", Direction.EAST),
        DOUBLE("double", Direction.UP);

        private final String name;
        private final Direction direction;

        private Type(String name, Direction direction) {
            this.name = name;
            this.direction = direction;
        }

        public static Type fromDirection(Direction direction) {
            for (Type type : Type.values()) {
                if (type.direction != direction) continue;
                return type;
            }
            return DOUBLE;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public Direction getDirection() {
            return this.direction;
        }
    }

    public static enum Shape implements StringRepresentable
    {
        FULL("full", true, true),
        POSITIVE_QUARTET("pos_quartet", true, false),
        NEGATIVE_QUARTET("neg_quartet", false, false),
        POSITIVE_INNER("pos_inner", true, true),
        NEGATIVE_INNER("neg_inner", false, true);

        private final String name;
        public final boolean positive;
        public final boolean inner;

        private Shape(String name, boolean positive, boolean inner) {
            this.name = name;
            this.positive = positive;
            this.inner = inner;
        }

        public Shape getOpposite() {
            if (this == FULL) {
                return this;
            }
            return this.positive ? Shape.values()[this.ordinal() + 1] : Shape.values()[this.ordinal() - 1];
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

