/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IFallable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.util.LevelUtil;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlabBlockNF
extends SlabBlock
implements IWaterloggedBlock,
ICustomPathfindable,
IFallable {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    public final BlockState baseState;
    public final Block base;

    public SlabBlockNF(Supplier<? extends Block> baseBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.baseState = baseBlock.get().m_49966_();
        this.base = baseBlock.get();
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_56353_, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATER_LEVEL, WATERLOG_TYPE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state.m_61143_((Property)f_56353_) == SlabType.DOUBLE) {
            return (BlockState)state.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0));
        }
        return this.addLiquidToPlacement(state, context);
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.tickLiquid(state, currentPos, level);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> {
                if (state.m_61143_((Property)f_56353_) != SlabType.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        SlabType type = (SlabType)state.m_61143_((Property)f_56353_);
        if (type == SlabType.BOTTOM) {
            return 4;
        }
        if (type == SlabType.DOUBLE) {
            return 7;
        }
        return 0;
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        SlabType type = (SlabType)state.m_61143_((Property)f_56353_);
        if (type == SlabType.TOP) {
            return this.getTypeForTopClosedShape(nodeManager, pos, 0.5f);
        }
        if (type == SlabType.BOTTOM) {
            return this.getTypeForBottomClosedShape(nodeManager, level, pos, 0.5f);
        }
        return NodeType.CLOSED;
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_61143_((Property)f_56353_) == SlabType.BOTTOM ? NodeType.OPEN : NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return switch ((SlabType)state.m_61143_((Property)f_56353_)) {
            case SlabType.DOUBLE, SlabType.TOP -> FULL_BOXES;
            default -> NO_BOXES;
        };
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return switch ((SlabType)state.m_61143_((Property)f_56353_)) {
            case SlabType.DOUBLE, SlabType.BOTTOM -> FULL_BOXES;
            default -> NO_BOXES;
        };
    }

    @Override
    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid pFluid) {
        return IWaterloggedBlock.super.m_6044_(level, pos, state, pFluid);
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState pFluidState) {
        return IWaterloggedBlock.super.m_7361_(level, pos, state, pFluidState);
    }

    @Override
    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        return IWaterloggedBlock.super.m_142598_(level, pos, state);
    }

    @Override
    public Optional<SoundEvent> m_142298_() {
        return IWaterloggedBlock.super.m_142298_();
    }

    @Override
    public void onMovingBlockEntityCreated(BlockState state, Level level, BlockPos pos, MovingBlockEntity entity) {
        if (entity.getBlockState().m_61143_((Property)f_56353_) == SlabType.TOP) {
            entity.setBlockState((BlockState)entity.getBlockState().m_61124_((Property)f_56353_, (Comparable)SlabType.BOTTOM));
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_());
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        this.baseState.m_60734_().m_142072_(level, state, pos, entity, fallDistance);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random pRand) {
        this.base.m_7100_(state, level, pos, pRand);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player pPlayer) {
        this.baseState.m_60686_(level, pos, pPlayer);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        this.base.m_6786_(level, pos, state);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseState.m_60690_(level, pos, Blocks.f_50016_, pos, false);
            this.base.m_6807_(this.baseState, level, pos, pOldState, false);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        if (!state.m_60713_(pNewState.m_60734_())) {
            this.baseState.m_60753_(level, pos, pNewState, pIsMoving);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity pEntity) {
        this.base.m_141947_(level, pos, state, pEntity);
    }

    public boolean m_6724_(BlockState state) {
        return this.base.m_6724_(state);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        this.base.m_7455_(state, level, pos, random);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random pRand) {
        this.base.m_7458_(state, level, pos, pRand);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return this.baseState.m_60664_(level, pPlayer, pHand, pHit);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion pExplosion) {
        this.base.m_7592_(level, pos, pExplosion);
    }

    public boolean m_6104_(BlockState state, BlockState pAdjacentBlockState, Direction pSide) {
        return this.base.m_6104_(state, pAdjacentBlockState, pSide);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.base.m_5909_(state, level, pos, context);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.base.m_7749_(state, level, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter pReader, BlockPos pos) {
        return this.base.m_7420_(state, pReader, pos);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile pProjectile) {
        this.base.m_5581_(level, state, pHit, pProjectile);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LevelUtil.pickCloneItem(state.m_60734_(), player);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Integer)state.m_61143_((Property)WATER_LEVEL) != 0 ? 0 : this.baseState.getFireSpreadSpeed(level, pos, direction);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Integer)state.m_61143_((Property)WATER_LEVEL) != 0 ? 0 : this.baseState.getFlammability(level, pos, direction);
    }
}

