/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.BlockNF;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.Season;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class SnowBlock
extends BlockNF
implements ITimeSimulatedBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public SnowBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (LevelData.isPresent((Level)level) && LevelData.get((Level)level).getSeasonalTemperature(ChunkData.get(level.m_46745_(pos)), pos) > 0.3f || level.m_45517_(LightLayer.BLOCK, pos) > 12) {
            level.m_7471_(pos, false);
        }
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        return Block.m_49918_((VoxelShape)level.m_8055_(belowPos).m_60816_((BlockGetter)level, belowPos), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        IChunkData chunkData;
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level) && (chunkData = ChunkData.get(level.m_46745_(pos))).getTemperature(pos) >= 0.050000012f) {
            chunkData.addSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        IChunkData chunkData;
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level) && (chunkData = ChunkData.get(level.m_46745_(pos))).getTemperature(pos) >= 0.050000012f) {
            chunkData.removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        float temperature = chunkData.getTemperature(pos);
        float seasonalFreezeTemp = 0.3f - temperature;
        LongLongPair freezeWindow = Season.getTimesAtTemperatureInfluence(seasonalFreezeTemp);
        if (seasonalTemp > seasonalFreezeTemp && MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(seasonTime, elapsedTime % 1344001L, freezeWindow.secondLong(), seasonTime % 1344000L), 1, random) >= 1) {
            level.m_7471_(pos, false);
        }
    }
}

