/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.TilledSoilBlock;
import frostnox.nightfall.block.block.UnstableBlock;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.ToolActionsNF;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class SoilBlock
extends UnstableBlock
implements ITimeSimulatedBlock {
    protected final Lazy<Map<SoilCover, BlockState>> coverMap = Lazy.of(() -> DataUtil.mapEnum(SoilCover.class, cover -> ((CoveredSoilBlock)((RegistryObject)map.get(cover)).get()).m_49966_()));
    protected final RegistryObject<? extends TilledSoilBlock> tilledSoilBlock;

    public SoilBlock(Supplier<SoundEvent> slideSound, Map<SoilCover, RegistryObject<? extends CoveredSoilBlock>> map, RegistryObject<? extends TilledSoilBlock> tilledSoilBlock, BlockBehaviour.Properties properties) {
        super(slideSound, properties);
        this.tilledSoilBlock = tilledSoilBlock;
    }

    @Nullable
    public BlockState getCoveredBlock(SoilCover cover) {
        return (BlockState)((Map)this.coverMap.get()).get((Object)cover);
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction == ToolActionsNF.TILL && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
            return ((TilledSoilBlock)this.tilledSoilBlock.get()).m_49966_();
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (facing == Direction.UP && !level.m_5776_() && LevelData.isPresent((Level)level)) {
            if (facingState.m_60739_((BlockGetter)level, facingPos) < 15) {
                ChunkData.get(((Level)level).m_46745_(pos)).addSimulatableBlock(TickPriority.NORMAL, pos);
            } else {
                ChunkData.get(((Level)level).m_46745_(pos)).removeSimulatableBlock(TickPriority.NORMAL, pos);
            }
        }
        return state;
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockPos abovePos;
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level) && level.m_8055_(abovePos = pos.m_7494_()).m_60739_((BlockGetter)level, abovePos) < 15) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    protected void tryGrowCover(BlockState state, ServerLevel level, BlockPos pos, BlockPos abovePos, BlockState aboveState, int light) {
        if (aboveState.m_60819_().m_76178_() && LayerLightEngine.m_75667_((BlockGetter)level, (BlockState)state, (BlockPos)pos, (BlockState)aboveState, (BlockPos)abovePos, (Direction)Direction.UP, (int)aboveState.m_60739_((BlockGetter)level, abovePos)) < level.m_7469_()) {
            Holder holder;
            ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
            if (chunkGenerator instanceof ContinentalChunkGenerator) {
                ContinentalChunkGenerator chunkGen = (ContinentalChunkGenerator)chunkGenerator;
                holder = (Holder)chunkGen.calculateBiome(pos.m_123341_(), 832, pos.m_123343_()).getHolder().get();
            } else {
                holder = level.m_204166_(pos);
            }
            SoilCover cover = SoilCover.getForBiome((Holder<Biome>)holder);
            BlockState coveredBlock = this.getCoveredBlock(cover);
            if (coveredBlock != null && cover.canGrow(light)) {
                level.m_46597_(pos, coveredBlock);
            }
        }
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockPos abovePos = pos.m_7494_();
        int light = level.m_45517_(LightLayer.SKY, abovePos);
        if (light > 0 && LevelUtil.isDay((LevelAccessor)level) && random.nextInt(10) == 0) {
            this.tryGrowCover(state, level, pos, abovePos, level.m_8055_(abovePos), light);
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        BlockPos abovePos = pos.m_7494_();
        int light = level.m_45517_(LightLayer.SKY, abovePos);
        if (light > 0 && MathUtil.getRandomSuccesses(randomTickChance / 10.0, LevelUtil.getDayTimePassed((Level)level, dayTime, elapsedTime), 1, random) >= 1) {
            this.tryGrowCover(state, level, pos, abovePos, chunk.m_8055_(abovePos), light);
        }
    }
}

