/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.math.OctalDirection;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StairBlockNF
extends StairBlock
implements IWaterloggedBlock,
ICustomPathfindable {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    protected static final ObjectList<List<AABB>> TOP_FACE_BOTTOM;
    protected static final ObjectList<List<AABB>> BOTTOM_FACE_TOP;
    public final BlockState baseState;
    public final Block base;

    public StairBlockNF(Supplier<? extends Block> baseBlock, BlockBehaviour.Properties properties) {
        super(() -> ((Block)baseBlock.get()).m_49966_(), properties);
        this.baseState = baseBlock.get().m_49966_();
        this.base = baseBlock.get();
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_56841_, (Comparable)Direction.NORTH)).m_61124_((Property)f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)f_56843_, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    public float m_7325_() {
        return this.f_60444_;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.addLiquidToPlacement(super.m_5573_(context), context);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.tickLiquid(state, currentPos, level);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATER_LEVEL, WATERLOG_TYPE});
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return state.m_61143_((Property)f_56842_) == Half.TOP ? 0 : 4;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        StairsShape shape = (StairsShape)state.m_61143_((Property)f_56843_);
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> {
                if (shape != StairsShape.INNER_LEFT && shape != StairsShape.INNER_RIGHT) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        Half half = (Half)state.m_61143_((Property)f_56842_);
        boolean top = half == Half.TOP;
        float y = top ? (float)pos.m_123342_() : (float)pos.m_123342_() + 0.5f;
        for (OctalDirection gapDirection : this.getGapDirections(state)) {
            float x = (float)pos.m_123341_() + 0.5f + gapDirection.xStepHalf;
            float z = (float)pos.m_123343_() + 0.5f + gapDirection.zStepHalf;
            if (top) {
                if (!(nodeManager.getEntityHeight() <= 0.5f)) break;
                nodeManager.getNode(pos).setPartialPath(x, y, z);
                return NodeType.OPEN_OR_WALKABLE;
            }
            if (nodeManager.collidesWith(nodeManager.getEntityBox(x, y, z))) continue;
            nodeManager.getNode(pos).setPartialPath(x, y, z);
            return NodeType.WALKABLE;
        }
        nodeManager.getNode((BlockPos)pos).partial = true;
        return NodeType.CLOSED;
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        if (state.m_61143_((Property)f_56842_) == Half.TOP) {
            return FULL_BOXES;
        }
        return (List)TOP_FACE_BOTTOM.get(f_56857_[this.m_56982_(state)]);
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        if (state.m_61143_((Property)f_56842_) == Half.BOTTOM) {
            return FULL_BOXES;
        }
        return (List)BOTTOM_FACE_TOP.get(f_56857_[this.m_56982_(state)]);
    }

    @Override
    public OctalDirection getDirection(BlockState state) {
        StairsShape shape = (StairsShape)state.m_61143_((Property)f_56843_);
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT) {
            return OctalDirection.CENTER;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_56841_);
        if (shape == StairsShape.STRAIGHT) {
            return switch (direction) {
                case Direction.SOUTH -> OctalDirection.SOUTH;
                case Direction.NORTH -> OctalDirection.NORTH;
                case Direction.EAST -> OctalDirection.EAST;
                default -> OctalDirection.WEST;
            };
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return switch (direction) {
                case Direction.SOUTH -> OctalDirection.SOUTHWEST;
                case Direction.NORTH -> OctalDirection.NORTHEAST;
                case Direction.EAST -> OctalDirection.SOUTHEAST;
                default -> OctalDirection.NORTHWEST;
            };
        }
        return switch (direction) {
            case Direction.SOUTH -> OctalDirection.SOUTHEAST;
            case Direction.NORTH -> OctalDirection.NORTHWEST;
            case Direction.EAST -> OctalDirection.NORTHEAST;
            default -> OctalDirection.SOUTHWEST;
        };
    }

    protected OctalDirection[] getGapDirections(BlockState state) {
        StairsShape shape = (StairsShape)state.m_61143_((Property)f_56843_);
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT) {
            return OctalDirection.CENTER_SINGLE;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_56841_);
        if (shape == StairsShape.STRAIGHT) {
            return switch (direction) {
                case Direction.NORTH -> OctalDirection.SOUTH_SINGLE;
                case Direction.SOUTH -> OctalDirection.NORTH_SINGLE;
                case Direction.WEST -> OctalDirection.EAST_SINGLE;
                default -> OctalDirection.WEST_SINGLE;
            };
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return switch (direction) {
                case Direction.NORTH -> OctalDirection.SOUTH_AND_WEST;
                case Direction.SOUTH -> OctalDirection.NORTH_AND_EAST;
                case Direction.WEST -> OctalDirection.SOUTH_AND_EAST;
                default -> OctalDirection.NORTH_AND_WEST;
            };
        }
        return switch (direction) {
            case Direction.NORTH -> OctalDirection.SOUTH_AND_EAST;
            case Direction.SOUTH -> OctalDirection.NORTH_AND_WEST;
            case Direction.WEST -> OctalDirection.NORTH_AND_EAST;
            default -> OctalDirection.SOUTH_AND_WEST;
        };
    }

    @Override
    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid pFluid) {
        return IWaterloggedBlock.super.m_6044_(level, pos, state, pFluid);
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState pFluidState) {
        return IWaterloggedBlock.super.m_7361_(level, pos, state, pFluidState);
    }

    @Override
    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        return IWaterloggedBlock.super.m_142598_(level, pos, state);
    }

    @Override
    public Optional<SoundEvent> m_142298_() {
        return IWaterloggedBlock.super.m_142298_();
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        this.base.m_142072_(level, state, pos, entity, fallDistance);
    }

    public boolean m_6104_(BlockState state, BlockState pAdjacentBlockState, Direction pSide) {
        return this.base.m_6104_(state, pAdjacentBlockState, pSide);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.base.m_5909_(state, level, pos, context);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.base.m_7749_(state, level, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter pReader, BlockPos pos) {
        return this.base.m_7420_(state, pReader, pos);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile pProjectile) {
        this.base.m_5581_(level, state, pHit, pProjectile);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LevelUtil.pickCloneItem(state.m_60734_(), player);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Integer)state.m_61143_((Property)WATER_LEVEL) != 0 ? 0 : this.baseState.getFireSpreadSpeed(level, pos, direction);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Integer)state.m_61143_((Property)WATER_LEVEL) != 0 ? 0 : this.baseState.getFlammability(level, pos, direction);
    }

    static {
        ArrayList<List> bottom = new ArrayList<List>(f_56856_.length);
        for (VoxelShape shape : f_56856_) {
            bottom.add(shape.m_83263_(Direction.UP).m_83299_());
        }
        TOP_FACE_BOTTOM = new ObjectImmutableList(bottom);
        ArrayList<List> top = new ArrayList<List>(f_56855_.length);
        for (VoxelShape shape : f_56855_) {
            top.add(shape.m_83263_(Direction.DOWN).m_83299_());
        }
        BOTTOM_FACE_TOP = new ObjectImmutableList(top);
    }
}

