/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.Fertility;
import frostnox.nightfall.block.Humidity;
import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.UnstableBlock;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.MathUtil;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.util.Lazy;

public class TilledSoilBlock
extends UnstableBlock
implements ITimeSimulatedBlock {
    public static final EnumProperty<Humidity> HUMIDITY = BlockStatePropertiesNF.HUMIDITY;
    public final Fertility fertility;
    public final Lazy<BlockState> untilledState;
    private final float dryHumidity;
    private final float moistHumidity;
    private final float irrigatedHumidity;

    public TilledSoilBlock(Fertility fertility, float dryHumidity, float moistHumidity, float irrigatedHumidity, Supplier<? extends Block> untilledBlock, Supplier<SoundEvent> slideSound, BlockBehaviour.Properties properties) {
        super(slideSound, properties);
        this.fertility = fertility;
        this.untilledState = Lazy.of(() -> ((Block)untilledBlock.get()).m_49966_());
        this.dryHumidity = dryHumidity;
        this.moistHumidity = moistHumidity;
        this.irrigatedHumidity = irrigatedHumidity;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(HUMIDITY, (Comparable)((Object)Humidity.DRY)));
    }

    public float getHumidity(BlockState state) {
        return switch ((Humidity)((Object)state.m_61143_(HUMIDITY))) {
            default -> throw new IncompatibleClassChangeError();
            case Humidity.DRY -> this.dryHumidity;
            case Humidity.MOIST -> this.moistHumidity;
            case Humidity.IRRIGATED -> this.irrigatedHumidity;
        };
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        Humidity humidity = null;
        if (FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos)) {
            humidity = Humidity.IRRIGATED;
        } else {
            for (BlockPos searchPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, 0, -4), (BlockPos)pos.m_142082_(4, 0, 4))) {
                BlockState searchState = level.m_8055_(searchPos);
                if (!searchState.m_60713_((Block)BlocksNF.ICE.get()) && !level.m_6425_(searchPos).m_205070_(TagsNF.FRESHWATER)) continue;
                humidity = Humidity.IRRIGATED;
                break;
            }
        }
        if (humidity == null) {
            if (LevelData.isPresent((Level)level)) {
                if (LevelData.get((Level)level).isRainfallCommonAt(ChunkData.get(level.m_46745_(pos)), pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_())) {
                    if (state.m_61143_(HUMIDITY) == Humidity.MOIST) {
                        return;
                    }
                    humidity = level.m_46758_(pos.m_7494_()) ? Humidity.MOIST : Humidity.DRY;
                } else {
                    humidity = Humidity.DRY;
                }
            } else {
                Humidity humidity2 = humidity = level.m_46758_(pos.m_7494_()) ? Humidity.MOIST : Humidity.DRY;
            }
        }
        if (humidity != state.m_61143_(HUMIDITY)) {
            level.m_7731_(pos, (BlockState)state.m_61124_(HUMIDITY, (Comparable)((Object)humidity)), 2);
        }
    }

    public BlockState m_7417_(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.UP && !state.m_60710_((LevelReader)level, pCurrentPos)) {
            return (BlockState)this.untilledState.get();
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        return !level.m_8055_(abovePos).m_60659_((BlockGetter)level, abovePos, Direction.DOWN, SupportType.FULL);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return !this.m_49966_().m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_()) ? (BlockState)this.untilledState.get() : super.m_5573_(pContext);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HUMIDITY});
    }

    @Override
    public void onMovingBlockEntityCreated(BlockState state, Level level, BlockPos pos, MovingBlockEntity entity) {
        entity.setBlockState((BlockState)this.untilledState.get());
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.HIGH, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.HIGH, pos);
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        if (MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 1, random) >= 1) {
            this.m_7455_(state, level, pos, random);
        }
    }

    @Override
    public TickPriority getTickPriority() {
        return TickPriority.HIGH;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ((BlockState)this.untilledState.get()).getCloneItemStack(target, level, pos, player);
    }
}

