/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.math.OctalDirection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TrapdoorBlockNF
extends TrapDoorBlock
implements IWaterloggedBlock,
ICustomPathfindable {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    protected static final List<AABB> NORTH_FACE_Y = f_57521_.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_FACE_Y = f_57520_.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> WEST_FACE_Y = f_57519_.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> EAST_FACE_Y = f_57518_.m_83263_(Direction.UP).m_83299_();
    protected static final float THICKNESS = 0.1875f;
    protected static final float HALF_THICKNESS = 0.09375f;
    public final Supplier<SoundEvent> openSound;
    public final Supplier<SoundEvent> closeSound;

    public TrapdoorBlockNF(BlockBehaviour.Properties properties, Supplier<SoundEvent> openSound, Supplier<SoundEvent> closeSound) {
        super(properties);
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATER_LEVEL, WATERLOG_TYPE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.addLiquidToPlacement(super.m_5573_(context), context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        state = (BlockState)state.m_61122_((Property)f_57514_);
        level.m_7731_(pos, state, 3);
        this.tickLiquid(state, pos, (LevelAccessor)level);
        this.m_57527_(pPlayer, level, pos, (Boolean)state.m_61143_((Property)f_57514_));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected void m_57527_(@Nullable Player player, Level level, BlockPos pos, boolean open) {
        level.m_5594_(player, pos, open ? this.openSound.get() : this.closeSound.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.nextFloat());
        level.m_142346_((Entity)player, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return LevelUtil.isBlockFullySupportedHorizontally(((BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false))).m_60808_((BlockGetter)level, pos).m_83215_(), level, pos.m_142300_(direction.m_122424_()), direction);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Direction)state.m_61143_((Property)f_54117_)).m_122424_() == facing && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        this.tickLiquid(state, currentPos, level);
        return state;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            OctalDirection gapDirection = OctalDirection.fromDirection((Direction)state.m_61143_((Property)f_54117_));
            return this.getTypeForThinSideClosedShape(nodeManager, state, level, pos, gapDirection, 0.09375f);
        }
        if (state.m_61143_((Property)f_57515_) == Half.TOP) {
            return this.getTypeForTopClosedShape(nodeManager, pos, 0.8125f);
        }
        return this.getTypeForBottomClosedShape(nodeManager, level, pos, 0.1875f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            return NodeType.CLOSED;
        }
        return state.m_61143_((Property)f_57515_) == Half.BOTTOM ? NodeType.OPEN : NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case Direction.NORTH -> NORTH_FACE_Y;
                case Direction.SOUTH -> SOUTH_FACE_Y;
                case Direction.WEST -> WEST_FACE_Y;
                default -> EAST_FACE_Y;
            };
        }
        return state.m_61143_((Property)f_57515_) == Half.BOTTOM ? NO_BOXES : FULL_BOXES;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case Direction.NORTH -> NORTH_FACE_Y;
                case Direction.SOUTH -> SOUTH_FACE_Y;
                case Direction.WEST -> WEST_FACE_Y;
                default -> EAST_FACE_Y;
            };
        }
        return state.m_61143_((Property)f_57515_) == Half.TOP ? NO_BOXES : FULL_BOXES;
    }

    @Override
    public OctalDirection getDirection(BlockState state) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            return OctalDirection.fromDirection((Direction)state.m_61143_((Property)f_54117_)).getOpposite();
        }
        return OctalDirection.CENTER;
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return state.m_61143_((Property)f_57515_) == Half.BOTTOM && (Boolean)state.m_61143_((Property)f_57514_) == false ? 1 : 0;
    }

    @Override
    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid pFluid) {
        return IWaterloggedBlock.super.m_6044_(level, pos, state, pFluid);
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState pFluidState) {
        return IWaterloggedBlock.super.m_7361_(level, pos, state, pFluidState);
    }

    @Override
    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        return IWaterloggedBlock.super.m_142598_(level, pos, state);
    }

    @Override
    public Optional<SoundEvent> m_142298_() {
        return IWaterloggedBlock.super.m_142298_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LevelUtil.pickCloneItem(state.m_60734_(), player);
    }
}

