/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IFoodBlock;
import frostnox.nightfall.block.block.WaterloggedBlock;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.MathUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TroughBlock
extends WaterloggedBlock
implements IFoodBlock,
ICustomPathfindable {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final IntegerProperty AMOUNT = IntegerProperty.m_61631_((String)"amount", (int)0, (int)4);
    public static final EnumProperty<FoodType> FOOD_TYPE = EnumProperty.m_61587_((String)"food_type", FoodType.class);
    public static final VoxelShape SHAPE_Z = TroughBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0);
    public static final VoxelShape SHAPE_X = MathUtil.rotate(SHAPE_Z, Rotation.CLOCKWISE_90);

    public TroughBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Z)).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(0))).m_61124_(FOOD_TYPE, (Comparable)((Object)FoodType.HAY)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack item;
        int amount;
        if (!player.m_6144_() && (amount = ((Integer)state.m_61143_((Property)AMOUNT)).intValue()) < 4 && (item = player.m_21120_(hand)).m_204117_(TagsNF.OMNIVORE_FOOD)) {
            if (!player.m_150110_().f_35937_) {
                item.m_41774_(1);
            }
            if (item.m_204117_(TagsNF.HERBIVORE_FOOD)) {
                if (amount == 0 || state.m_61143_(FOOD_TYPE) == FoodType.HAY) {
                    level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(FOOD_TYPE, (Comparable)((Object)FoodType.HAY))).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(amount + 1)));
                } else {
                    level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(FOOD_TYPE, (Comparable)((Object)FoodType.MIX))).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(amount + 1)));
                }
            } else if (item.m_204117_(TagsNF.CARNIVORE_FOOD)) {
                if (amount == 0 || state.m_61143_(FOOD_TYPE) == FoodType.MEAT) {
                    level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(FOOD_TYPE, (Comparable)((Object)FoodType.MEAT))).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(amount + 1)));
                } else {
                    level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(FOOD_TYPE, (Comparable)((Object)FoodType.MIX))).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(amount + 1)));
                }
            } else {
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(FOOD_TYPE, (Comparable)((Object)FoodType.MIX))).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(amount + 1)));
            }
            level.m_5594_(null, pos, (SoundEvent)SoundsNF.TROUGH_FILL.get(), SoundSource.BLOCKS, 1.0f, 0.95f + level.f_46441_.nextFloat() * 0.1f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? SHAPE_Z : SHAPE_X;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)super.m_5573_(pContext).m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    public BlockState m_6843_(BlockState state, Rotation pRot) {
        return switch (pRot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{AXIS, AMOUNT, FOOD_TYPE});
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public boolean isEatable(BlockState state, Diet diet) {
        if ((Integer)state.m_61143_((Property)AMOUNT) == 0) {
            return false;
        }
        return switch (diet) {
            default -> throw new IncompatibleClassChangeError();
            case Diet.HERBIVORE -> {
                if (state.m_61143_(FOOD_TYPE) == FoodType.HAY) {
                    yield true;
                }
                yield false;
            }
            case Diet.CARNIVORE -> {
                if (state.m_61143_(FOOD_TYPE) == FoodType.MEAT) {
                    yield true;
                }
                yield false;
            }
            case Diet.OMNIVORE -> true;
        };
    }

    @Override
    public void eat(Entity eater, Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AMOUNT) - 1)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return this.getTypeForCenteredBottomShape(nodeManager, pos, 0.625f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.OPEN;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return NO_BOXES;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return FULL_BOXES;
    }

    public static enum FoodType implements StringRepresentable
    {
        HAY,
        MEAT,
        MIX;

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.name;
        }
    }
}

