/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.IFallable;
import frostnox.nightfall.block.block.BlockNF;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.entity.MovingBlockToClient;
import frostnox.nightfall.util.LevelUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.compress.utils.Lists;

public class UnstableBlock
extends BlockNF
implements IFallable {
    public final Supplier<SoundEvent> slideSound;

    public UnstableBlock(Supplier<SoundEvent> slideSound, BlockBehaviour.Properties properties) {
        super(properties);
        this.slideSound = slideSound;
    }

    public boolean trySlideOnce(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        Direction dir;
        BlockPos slidePos;
        if (!level.m_8055_(pos.m_7494_()).m_60838_((BlockGetter)level, pos.m_7494_()) && !LevelUtil.canFallThrough(level.m_8055_(pos.m_7495_())) && LevelUtil.canFallThrough(level.m_8055_(slidePos = pos.m_142300_(dir = Direction.Plane.HORIZONTAL.m_122560_(random)))) && LevelUtil.canFallThrough(level.m_8055_(slidePos.m_7495_()))) {
            this.onFall(state, level, pos, null);
            MovingBlockEntity.slide((Level)level, pos, dir, state);
            return true;
        }
        return false;
    }

    public boolean trySlide(Level level, BlockPos movingPos, MovingBlockEntity movingBlock) {
        Direction oppDir = movingBlock.slideDir.m_122424_();
        if (oppDir.m_122434_() == Direction.Axis.Y) {
            oppDir = null;
        }
        ArrayList directions = Lists.newArrayList((Iterator)Direction.Plane.HORIZONTAL.iterator());
        directions.remove(oppDir);
        while (!directions.isEmpty() || oppDir != null) {
            BlockPos slidePos;
            Direction dir;
            if (directions.isEmpty()) {
                dir = oppDir;
                oppDir = null;
            } else {
                dir = (Direction)directions.remove((level.f_46441_.nextInt() & Integer.MAX_VALUE) % directions.size());
            }
            if (!LevelUtil.canFallThrough(level.m_8055_(slidePos = movingPos.m_142300_(dir))) || !LevelUtil.canFallThrough(level.m_8055_(slidePos.m_7495_()))) continue;
            movingBlock.slideDir = dir;
            movingBlock.setSlideTime(0);
            movingBlock.m_20334_(0.0, 0.0, 0.0);
            movingBlock.m_6034_((double)movingPos.m_123341_() + 0.5, (double)movingPos.m_123342_() + 0.005, (double)movingPos.m_123343_() + 0.5);
            if (!level.m_5776_()) {
                NetworkHandler.toAllTracking(movingBlock, new MovingBlockToClient(0, dir, true, movingBlock.m_142049_()));
            }
            return false;
        }
        return true;
    }

    @Override
    public void onLand(Level level, BlockPos pos, BlockState state, BlockState contactState, MovingBlockEntity entity) {
        this.trySlide(level, pos, entity);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && !this.trySlideOnce(state, serverLevel = (ServerLevel)level, pos, level.f_46441_)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    @Override
    public boolean canLand(Level level, BlockPos movingPos, BlockState movingState, BlockState contactState, MovingBlockEntity movingBlock) {
        return this.trySlide(level, movingPos, movingBlock);
    }

    @Override
    public SoundEvent getFallSound(BlockState state) {
        return this.slideSound.get();
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance);
        if (!level.m_5776_() && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).schedulePhysicsTick(pos);
        }
    }
}

