/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.block.WaterloggedBlock;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.MoonPhase;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WardingEffigyBlock
extends WaterloggedBlock
implements ICustomPathfindable {
    public static final VoxelShape SHAPE_Z = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)2.0, (double)11.5), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)9.0, (double)9.5), Block.m_49796_((double)1.5, (double)9.0, (double)6.5, (double)14.5, (double)11.0, (double)9.5), Block.m_49796_((double)5.5, (double)11.0, (double)5.5, (double)10.5, (double)16.0, (double)10.5)});
    public static final VoxelShape SHAPE_X = MathUtil.rotate(SHAPE_Z, Rotation.CLOCKWISE_90);
    protected static final List<AABB> AABB_TOP_Z = SHAPE_Z.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> AABB_TOP_X = SHAPE_X.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> AABB_BOTTOM_Z = SHAPE_Z.m_83263_(Direction.DOWN).m_83299_();
    protected static final List<AABB> AABB_BOTTOM_X = SHAPE_X.m_83263_(Direction.DOWN).m_83299_();
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public WardingEffigyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Z));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)new TranslatableComponent("block.warding_effigy.info").m_130940_(ChatFormatting.BLUE));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        state = super.m_7417_(state, pFacing, pFacingState, level, pCurrentPos, pFacingPos);
        if (pFacing == Direction.DOWN && !state.m_60710_((LevelReader)level, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        return level.m_8055_(belowPos).m_60659_((BlockGetter)level, belowPos, Direction.UP, SupportType.CENTER);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return !this.m_49966_().m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_()) ? null : (BlockState)super.m_5573_(pContext).m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? SHAPE_Z : SHAPE_X;
    }

    public BlockState m_6843_(BlockState state, Rotation pRot) {
        return switch (pRot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{AXIS});
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random pRand) {
        if (LevelUtil.isNight((LevelAccessor)level) && MoonPhase.get((LevelTimeAccess)level) != MoonPhase.NEW && pRand.nextInt() % 4 == 0) {
            level.m_7106_((ParticleOptions)ParticleTypesNF.ESSENCE_MOON.get(), (double)pos.m_123341_() + 0.35 + pRand.nextDouble() * 0.3, (double)pos.m_123342_() + 0.1 + pRand.nextDouble(), (double)pos.m_123343_() + 0.35 + pRand.nextDouble() * 0.3, 0.0, 0.0, 0.0);
        }
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addWardingEffigy(pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeWardingEffigy(pos);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        nodeManager.getNode((BlockPos)pos).partial = true;
        return NodeType.CLOSED;
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? AABB_TOP_Z : AABB_TOP_X;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? AABB_BOTTOM_Z : AABB_BOTTOM_X;
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }
}

