/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.anvil;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.block.anvil.TieredAnvilBlock;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.util.MathUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetalAnvilBlock
extends TieredAnvilBlock
implements ICustomPathfindable,
IWaterloggedBlock {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    private static final VoxelShape BASE = Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)4.0, (double)13.0);
    private static final VoxelShape LEG1 = Block.m_49796_((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape LEG2 = Block.m_49796_((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    protected static final VoxelShape X_AXIS_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG1, LEG2, TOP});
    protected static final VoxelShape Z_AXIS_SHAPE = MathUtil.rotate(X_AXIS_SHAPE, Rotation.CLOCKWISE_90);
    protected static final List<AABB> X_TOP_FACE = X_AXIS_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> Z_TOP_FACE = Z_AXIS_SHAPE.m_83263_(Direction.UP).m_83299_();

    public MetalAnvilBlock(int tier, BlockBehaviour.Properties properties) {
        super(tier, properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        this.tickLiquid(state, pos, level);
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return this.addLiquidToPlacement((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeContext.m_8125_().m_122427_()), placeContext);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? X_AXIS_SHAPE : Z_AXIS_SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATER_LEVEL, WATERLOG_TYPE});
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public void onLand(Level level, BlockPos pos, BlockState state, BlockState contactState, MovingBlockEntity entity) {
        if (!entity.m_20067_()) {
            level.m_5594_(null, pos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.4f, level.f_46441_.nextFloat() * 0.1f + 0.8f);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        nodeManager.getNode((BlockPos)pos).partial = true;
        return NodeType.CLOSED;
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? X_TOP_FACE : Z_TOP_FACE;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return FULL_BOXES;
    }
}

