/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.anvil;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IFallable;
import frostnox.nightfall.block.block.anvil.TieredAnvilBlockEntity;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TieredAnvilBlock
extends BaseEntityBlock
implements IFallable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HAS_METAL = BlockStatePropertiesNF.HAS_METAL;
    public final int tier;

    public TieredAnvilBlock(int tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_METAL, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeContext.m_8125_().m_122427_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HAS_METAL});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            if (!((Boolean)state.m_61143_((Property)HAS_METAL)).booleanValue()) {
                return InteractionResult.SUCCESS;
            }
        } else if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof TieredAnvilBlockEntity) {
            TieredAnvilBlockEntity blockEntity2 = (TieredAnvilBlockEntity)blockEntity;
            ItemStack resultItem = blockEntity2.getResult();
            if (!resultItem.m_41619_()) {
                LevelUtil.giveItemToPlayer(resultItem.m_41777_(), player, true);
                resultItem.m_41764_(0);
                blockEntity2.m_6596_();
                level.m_7260_(pos, state, state, 2);
                return InteractionResult.CONSUME;
            }
            if (!blockEntity2.inProgress) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity2, (BlockPos)pos);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_48717_) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof TieredAnvilBlockEntity) {
            TieredAnvilBlockEntity entity = (TieredAnvilBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, entity.getContainerDrops());
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, p_48717_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.ANVIL.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entity) {
        if (level.m_5776_()) {
            return null;
        }
        return (Boolean)state.m_61143_((Property)HAS_METAL) != false ? TieredAnvilBlock.m_152132_(entity, (BlockEntityType)((BlockEntityType)BlockEntitiesNF.ANVIL.get()), TieredAnvilBlockEntity::serverTick) : null;
    }

    @Override
    public void onFall(BlockState state, ServerLevel level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        if (blockEntity instanceof TieredAnvilBlockEntity) {
            TieredAnvilBlockEntity anvil = (TieredAnvilBlockEntity)blockEntity;
            if (anvil.inProgress) {
                anvil.destroyGrid();
            }
        }
    }
}

