/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.anvil;

import com.mojang.math.Vector3f;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.block.IHeatSource;
import frostnox.nightfall.block.IMicroGrid;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.MenuContainerBlockEntity;
import frostnox.nightfall.block.block.anvil.AnvilAction;
import frostnox.nightfall.block.block.anvil.TieredAnvilBlock;
import frostnox.nightfall.block.block.anvil.TieredAnvilContainer;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.TieredAnvilRecipe;
import frostnox.nightfall.item.item.MeleeWeaponItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.world.AnvilSlagToClient;
import frostnox.nightfall.network.message.world.GridUseToClient;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.math.noise.FractalSimplexNoiseFast;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import it.unimi.dsi.fastutil.ints.IntObjectImmutablePair;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TieredAnvilBlockEntity
extends MenuContainerBlockEntity
implements MenuProvider,
IMicroGrid {
    public static final int GRID_X = 14;
    public static final int GRID_Y = 6;
    public static final int GRID_Z = 8;
    private static final int HEAT_TIME = 1800;
    private final ItemStackHandlerNF result;
    public final boolean[][][] grid = new boolean[14][6][8];
    public final boolean[][][] slag = new boolean[14][6][8];
    private ResourceLocation recipeLocation;
    private TieredHeat cachedHeat = TieredHeat.NONE;
    private int heatTicks;
    private int tickCount;
    private boolean finished = false;
    public boolean inProgress = false;
    public final Color[][][] gridColors = new Color[14][6][8];

    public TieredAnvilBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesNF.ANVIL.get(), pos, state);
    }

    protected TieredAnvilBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.result = new ItemStackHandlerNF();
    }

    @Override
    public ItemStackHandlerNF getInventory() {
        return this.result;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("nightfall.anvil");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new TieredAnvilContainer(pContainerId, pInventory, this);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128431_().contains("recipe")) {
            this.setRecipeID(ResourceLocation.parse((String)tag.m_128461_("recipe")));
        }
        if (tag.m_128441_("heat_ticks")) {
            this.heatTicks = tag.m_128451_("heat_ticks");
        }
        if (tag.m_128441_("finished")) {
            this.finished = tag.m_128471_("finished");
        }
        if (tag.m_128441_("in_progress")) {
            this.inProgress = tag.m_128471_("in_progress");
        }
        ListTag activeCubes = tag.m_128437_("active_cubes", 8);
        ListTag activeSlag = tag.m_128437_("active_slag", 8);
        for (int x = 0; x < this.getGridXSize(); ++x) {
            for (int y = 0; y < this.getGridYSize(); ++y) {
                for (int z = 0; z < this.getGridZSize(); ++z) {
                    this.grid[x][y][z] = activeCubes.contains((Object)StringTag.m_129297_((String)IMicroGrid.idFromPos(x, y, z)));
                    this.slag[x][y][z] = activeSlag.contains((Object)StringTag.m_129297_((String)IMicroGrid.idFromPos(x, y, z)));
                }
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.recipeLocation != null) {
            tag.m_128359_("recipe", this.recipeLocation.toString());
        }
        tag.m_128405_("heat_ticks", this.heatTicks);
        tag.m_128379_("finished", this.finished);
        tag.m_128379_("in_progress", this.inProgress);
        ListTag activeCubes = new ListTag();
        ListTag activeSlag = new ListTag();
        for (int x = 0; x < this.getGridXSize(); ++x) {
            for (int y = 0; y < this.getGridYSize(); ++y) {
                for (int z = 0; z < this.getGridZSize(); ++z) {
                    if (this.grid[x][y][z]) {
                        activeCubes.add((Object)StringTag.m_129297_((String)IMicroGrid.idFromPos(x, y, z)));
                    }
                    if (!this.slag[x][y][z]) continue;
                    activeSlag.add((Object)StringTag.m_129297_((String)IMicroGrid.idFromPos(x, y, z)));
                }
            }
        }
        tag.m_128365_("active_cubes", (Tag)activeCubes);
        tag.m_128365_("active_slag", (Tag)activeSlag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TieredAnvilBlockEntity entity) {
        ++entity.tickCount;
        entity.heatTicks = entity.heatTicks - (level.m_46758_(pos.m_7494_()) ? 2 : 1);
        if (entity.heatTicks < 900 && entity.tickCount % 20 == 0) {
            if (entity.hasHeatSource(entity.recipeLocation)) {
                entity.heatTicks = 1800;
            } else if (entity.heatTicks <= 0) {
                entity.destroyGrid();
            }
        }
        if (entity.heatTicks > 0 && entity.tickCount % 12 == 0) {
            entity.tryToFinishItem();
        }
        entity.m_6596_();
    }

    @Override
    public boolean canUseGrid(Action action) {
        return action.is(TagsNF.SMITHING_ACTION);
    }

    @Override
    public boolean isValidActionType(int type) {
        return type > -1 && type < AnvilAction.values().length;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean useGrid(int ordinal, Vec3i hitPos, Player player, ItemStack item) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_() || !this.inProgress) {
            return false;
        }
        x = hitPos.m_123341_();
        if (!this.gridHas(x, y = hitPos.m_123342_(), z = hitPos.m_123343_())) {
            return false;
        }
        recipe = this.f_58857_.m_7465_().m_44043_(this.recipeLocation);
        if (recipe.isEmpty() || !((var10_9 = recipe.get()) instanceof TieredAnvilRecipe)) {
            return false;
        }
        anvilRecipe = (TieredAnvilRecipe)var10_9;
        var12_12 = item.m_41720_();
        if (!(var12_12 instanceof MeleeWeaponItem)) ** GOTO lbl-1000
        tool = (MeleeWeaponItem)var12_12;
        if (tool.material.getTier() < anvilRecipe.getTier() - 1) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        badTool = v0;
        gridPos = this.getWorldPos(this.f_58858_, ((float)x + 0.5f) / 16.0f, ((float)y + 0.5f) / 16.0f, ((float)z + 0.5f) / 16.0f);
        if (this.getCachedHeat() != TieredHeat.NONE) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)((SimpleParticleType)this.getCachedHeat().getSparkParticle().get()), gridPos.m_7096_(), gridPos.m_7098_(), gridPos.m_7094_(), (badTool != false ? 2 : 11) + this.f_58857_.f_46441_.nextInt(5), 0.0, 0.0, 0.0, 0.11999999731779099);
        }
        this.f_58857_.m_6263_(null, gridPos.f_82479_, gridPos.f_82480_, gridPos.f_82481_, (SoundEvent)SoundsNF.ANVIL_STRIKE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.m_150110_().f_35937_) {
            item.m_41622_(badTool != false ? 2 : 1, (LivingEntity)player, (Consumer<Player>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$useGrid$0(net.minecraft.world.entity.player.Player ), (Lnet/minecraft/world/entity/player/Player;)V)());
        }
        if (badTool) {
            return false;
        }
        changedCubes = new CompoundTag();
        changedSlag = new CompoundTag();
        xMove = 0;
        zMove = 0;
        userYaw = ((player.m_146908_() >= 0.0f ? player.m_146908_() : 360.0f + player.m_146908_()) + this.getRotationDegrees()) % 360.0f;
        if (userYaw >= 135.0f && userYaw < 225.0f) {
            zMove = 1;
        } else if (userYaw < 45.0f || userYaw > 315.0f) {
            zMove = -1;
        } else {
            xMove = userYaw >= 45.0f && userYaw < 135.0f ? 1 : -1;
        }
        action = AnvilAction.values()[ordinal];
        block0 : switch (1.$SwitchMap$frostnox$nightfall$block$block$anvil$AnvilAction[action.ordinal()]) {
            case 1: {
                this.punchCube(x, y, z, changedCubes, changedSlag);
                break;
            }
            case 2: {
                this.punchCube(x, y, z, changedCubes, changedSlag);
                if (this.gridHas(x + zMove, y, z + xMove)) {
                    this.punchCube(x + zMove, y, z + xMove, changedCubes, changedSlag);
                }
                if (!this.gridHas(x - zMove, y, z - xMove)) break;
                this.punchCube(x - zMove, y, z - xMove, changedCubes, changedSlag);
                break;
            }
            case 3: {
                for (gridX = x - 1; gridX <= x + 1; ++gridX) {
                    for (gridZ = z - 1; gridZ <= z + 1; ++gridZ) {
                        if (!this.gridHas(gridX, y, gridZ)) continue;
                        this.punchCube(gridX, y, gridZ, changedCubes, changedSlag);
                    }
                }
                break;
            }
            case 4: {
                this.breakSlag(x, y, z, changedSlag);
                if (this.gridHas(x, y + 1, z)) break;
                if (xMove != 0) {
                    if (this.gridHas(x - xMove, y, z) && this.gridHas(x + xMove, y, z)) break;
                    if (!this.gridHas(x + xMove, y, z)) {
                        xMove *= -1;
                    }
                    for (newX = x + xMove; newX >= 0 && newX < this.getGridXSize(); newX += xMove) {
                        if (this.grid[newX][y][z]) continue;
                        this.moveCube(x, y, z, newX, y, z, changedCubes);
                        break block0;
                    }
                } else {
                    if (this.gridHas(x, y, z - zMove) && this.gridHas(x, y, z + zMove)) break;
                    if (!this.gridHas(x, y, z + zMove)) {
                        zMove *= -1;
                    }
                    for (newZ = z + zMove; newZ >= 0 && newZ < this.getGridZSize(); newZ += zMove) {
                        if (this.grid[x][y][newZ]) continue;
                        this.moveCube(x, y, z, x, y, newZ, changedCubes);
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                this.drawCube(x, y, z, xMove, zMove, changedCubes, changedSlag);
                if (this.gridHas(x + zMove, y, z + xMove)) {
                    this.drawCube(x + zMove, y, z + xMove, xMove, zMove, changedCubes, changedSlag);
                }
                if (!this.gridHas(x - zMove, y, z - xMove)) break;
                this.drawCube(x - zMove, y, z - xMove, xMove, zMove, changedCubes, changedSlag);
                break;
            }
            case 6: {
                this.drawCube(x, y, z, xMove, zMove, changedCubes, changedSlag);
                if (zMove != 0) {
                    i = 1;
                    while (this.gridContainsLocation(x + zMove * i, y, z) && this.gridHas(x + zMove * i, y, z)) {
                        this.drawCube(x + zMove * i, y, z, xMove, zMove, changedCubes, changedSlag);
                        ++i;
                    }
                    i = 1;
                    while (this.gridContainsLocation(x - zMove * i, y, z) && this.gridHas(x - zMove * i, y, z)) {
                        this.drawCube(x - zMove * i, y, z, xMove, zMove, changedCubes, changedSlag);
                        ++i;
                    }
                } else {
                    i = 1;
                    while (this.gridContainsLocation(x, y, z + xMove * i) && this.gridHas(x, y, z + xMove * i)) {
                        this.drawCube(x, y, z + xMove * i, xMove, zMove, changedCubes, changedSlag);
                        ++i;
                    }
                    i = 1;
                    while (this.gridContainsLocation(x, y, z - xMove * i) && this.gridHas(x, y, z - xMove * i)) {
                        this.drawCube(x, y, z - xMove * i, xMove, zMove, changedCubes, changedSlag);
                        ++i;
                    }
                }
                break;
            }
            case 7: {
                this.upsetCube(x, y, z, xMove *= -1, zMove *= -1, changedCubes, changedSlag);
                if (this.gridHas(x + zMove, y, z + xMove)) {
                    this.upsetCube(x + zMove, y, z + xMove, xMove, zMove, changedCubes, changedSlag);
                }
                if (!this.gridHas(x - zMove, y, z - xMove)) break;
                this.upsetCube(x - zMove, y, z - xMove, xMove, zMove, changedCubes, changedSlag);
                break;
            }
            case 8: {
                this.upsetCube(x, y, z, xMove *= -1, zMove *= -1, changedCubes, changedSlag);
                if (zMove != 0) {
                    i = 1;
                    while (this.gridContainsLocation(x + zMove * i, y, z) && this.gridHas(x + zMove * i, y, z)) {
                        this.upsetCube(x + zMove * i, y, z, xMove, zMove, changedCubes, changedSlag);
                        ++i;
                    }
                    i = 1;
                    while (this.gridContainsLocation(x - zMove * i, y, z) && this.gridHas(x - zMove * i, y, z)) {
                        this.upsetCube(x - zMove * i, y, z, xMove, zMove, changedCubes, changedSlag);
                        ++i;
                    }
                } else {
                    i = 1;
                    while (this.gridContainsLocation(x, y, z + xMove * i) && this.gridHas(x, y, z + xMove * i)) {
                        this.upsetCube(x, y, z + xMove * i, xMove, zMove, changedCubes, changedSlag);
                        ++i;
                    }
                    i = 1;
                    while (this.gridContainsLocation(x, y, z - xMove * i) && this.gridHas(x, y, z - xMove * i)) {
                        this.upsetCube(x, y, z - xMove * i, xMove, zMove, changedCubes, changedSlag);
                        ++i;
                    }
                }
                break;
            }
            default: {
                Nightfall.LOGGER.error("Missing anvil grid interaction type '" + action + "'.");
                return false;
            }
        }
        if (!changedCubes.m_128431_().isEmpty()) {
            if (IMicroGrid.compare(this.grid, anvilRecipe.getFinishShape()) == -1) {
                this.destroyGrid();
                return true;
            }
            visited = new ObjectOpenHashSet(336);
            positions = new ObjectArrayList(32);
            components = new ObjectArrayList(6);
            for (String id : changedCubes.m_128431_()) {
                if (changedCubes.m_128471_(id)) continue;
                startPos = IMicroGrid.posFromId(id);
                for (Direction startDir : Direction.values()) {
                    startNeighborX = startPos.m_123341_() + startDir.m_122429_();
                    if (!this.gridHas(startNeighborX, startNeighborY = startPos.m_123342_() + startDir.m_122430_(), startNeighborZ = startPos.m_123343_() + startDir.m_122431_())) continue;
                    positions.push((Object)new Vec3i(startNeighborX, startNeighborY, startNeighborZ));
                    minY = 5;
                    component = new ObjectArrayList(32);
                    while (!positions.isEmpty()) {
                        pos = (Vec3i)positions.pop();
                        if (visited.contains((Object)pos)) continue;
                        visited.add((Object)pos);
                        component.add(pos);
                        if (pos.m_123342_() < minY) {
                            minY = pos.m_123342_();
                        }
                        for (Direction dir : Direction.values()) {
                            neighborX = pos.m_123341_() + dir.m_122429_();
                            if (!this.gridHas(neighborX, neighborY = pos.m_123342_() + dir.m_122430_(), neighborZ = pos.m_123343_() + dir.m_122431_())) continue;
                            positions.push((Object)new Vec3i(neighborX, neighborY, neighborZ));
                        }
                    }
                    if (component.isEmpty() || minY <= 0) continue;
                    components.add(new IntObjectImmutablePair(minY, (Object)component));
                }
            }
            components.sort(Comparator.comparingInt((ToIntFunction<IntObjectPair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, firstInt(), (Lit/unimi/dsi/fastutil/ints/IntObjectPair;)I)()));
            fallingCubes = new ObjectOpenHashSet(336);
            for (IntObjectPair pair : components) {
                component = (List)pair.second();
                component.sort(Comparator.comparingInt((ToIntFunction<Vec3i>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, m_123342_(), (Lnet/minecraft/core/Vec3i;)I)()));
                lowPos = (Vec3i)component.get(0);
                for (minY = lowPos.m_123342_(); minY > 0 && !this.grid[lowPos.m_123341_()][minY - 1][lowPos.m_123343_()]; --minY) {
                }
                if (minY == lowPos.m_123342_()) continue;
                yChange = lowPos.m_123342_() - minY;
                for (Vec3i pos : component) {
                    if (!fallingCubes.contains(pos)) {
                        this.grid[pos.m_123341_()][pos.m_123342_()][pos.m_123343_()] = false;
                        changedCubes.m_128379_(IMicroGrid.idFromPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), false);
                    }
                    this.breakSlag(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), changedSlag);
                    fallY = pos.m_123342_() - yChange;
                    this.grid[pos.m_123341_()][fallY][pos.m_123343_()] = true;
                    changedCubes.m_128379_(IMicroGrid.idFromPos(pos.m_123341_(), fallY, pos.m_123343_()), true);
                    fallingCubes.add(new Vec3i(pos.m_123341_(), fallY, pos.m_123343_()));
                }
            }
        }
        updateCubes = changedCubes.m_128431_().isEmpty() == false;
        v1 = updateSlag = changedSlag.m_128431_().isEmpty() == false;
        if (updateCubes || updateSlag) {
            if (IMicroGrid.equals(this.grid, anvilRecipe.getFinishShape())) {
                this.finished = true;
                if (!this.tryToFinishItem()) {
                    if (updateCubes) {
                        NetworkHandler.toAllTrackingChunk(this.f_58857_.m_46745_(this.m_58899_()), new GridUseToClient(this.m_58899_(), changedCubes));
                    }
                    if (updateSlag) {
                        NetworkHandler.toAllTrackingChunk(this.f_58857_.m_46745_(this.m_58899_()), new AnvilSlagToClient(this.m_58899_(), changedSlag));
                    }
                }
            } else {
                this.finished = false;
                if (updateCubes) {
                    NetworkHandler.toAllTrackingChunk(this.f_58857_.m_46745_(this.m_58899_()), new GridUseToClient(this.m_58899_(), changedCubes));
                }
                if (updateSlag) {
                    NetworkHandler.toAllTrackingChunk(this.f_58857_.m_46745_(this.m_58899_()), new AnvilSlagToClient(this.m_58899_(), changedSlag));
                }
            }
        }
        this.m_6596_();
        return true;
    }

    public void destroyGrid() {
        double x = (double)this.f_58858_.m_123341_() + 0.5;
        double y = this.f_58858_.m_123342_() + 1;
        double z = (double)this.f_58858_.m_123343_() + 0.5;
        if (this.getCachedHeat() != TieredHeat.NONE) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)((SimpleParticleType)this.getCachedHeat().getSparkParticle().get()), x, y, z, 20 + this.f_58857_.f_46441_.nextInt(5), 0.125, 0.0625, 0.125, (double)0.003f);
        }
        this.f_58857_.m_6263_(null, x, y, z, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.clearGrid();
        IMicroGrid.clearGrid(this.slag);
        this.inProgress = false;
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TieredAnvilBlock.HAS_METAL, (Comparable)Boolean.valueOf(false)), 2);
    }

    private void breakSlag(int x, int y, int z, CompoundTag changedSlag) {
        if (this.gridContainsLocation(x, y, z) && this.slag[x][y][z]) {
            this.slag[x][y][z] = false;
            changedSlag.m_128379_(IMicroGrid.idFromPos(x, y, z), false);
        }
    }

    private TieredHeat getCachedHeat() {
        Object t;
        Optional recipe;
        if (this.cachedHeat == TieredHeat.NONE && (recipe = this.f_58857_.m_7465_().m_44043_(this.recipeLocation)).isPresent() && (t = recipe.get()) instanceof TieredAnvilRecipe) {
            TieredAnvilRecipe anvilRecipe = (TieredAnvilRecipe)t;
            this.cachedHeat = TieredHeat.fromTier(anvilRecipe.getTier());
        }
        return this.cachedHeat;
    }

    private boolean tryToFinishItem() {
        Object t;
        Optional recipe;
        if (this.finished && IMicroGrid.isEmpty(this.slag) && (recipe = this.f_58857_.m_7465_().m_44043_(this.recipeLocation)).isPresent() && (t = recipe.get()) instanceof TieredAnvilRecipe) {
            TieredAnvilRecipe anvilRecipe = (TieredAnvilRecipe)t;
            if (this.hasWaterSource() || anvilRecipe.getTier() == 0) {
                double itemX = (double)this.f_58858_.m_123341_() + 0.5;
                double itemY = this.f_58858_.m_123342_() + 1;
                double itemZ = (double)this.f_58858_.m_123343_() + 0.5;
                if (anvilRecipe.getTier() > 0) {
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, itemX, itemY, itemZ, 20 + this.f_58857_.f_46441_.nextInt(5), 0.125, 0.0625, 0.125, (double)0.003f);
                    this.f_58857_.m_6263_(null, itemX, itemY, itemZ, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.result.setStackInSlot(0, anvilRecipe.m_8043_().m_41777_());
                this.clearGrid();
                this.inProgress = false;
                this.heatTicks = 0;
                this.finished = false;
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TieredAnvilBlock.HAS_METAL, (Comparable)Boolean.valueOf(false)), 2);
                return true;
            }
        }
        return false;
    }

    private void punchCube(int x, int y, int z, CompoundTag changedCubes, CompoundTag changedSlag) {
        this.breakSlag(x, y, z, changedSlag);
        this.grid[x][y][z] = false;
        changedCubes.m_128379_(IMicroGrid.idFromPos(x, y, z), false);
    }

    private void drawCube(int x, int y, int z, int xMove, int zMove, CompoundTag changedCubes, CompoundTag changedSlag) {
        block2: {
            block4: {
                block3: {
                    this.breakSlag(x, y, z, changedSlag);
                    if (y <= 0 || this.gridHas(x, y + 1, z) || this.gridHas(x + xMove, y, z + zMove) && this.gridHas(x - xMove, y, z - zMove)) break block2;
                    if (this.grid[x][y - 1][z]) break block3;
                    this.moveCube(x, y, z, x, y - 1, z, changedCubes);
                    break block2;
                }
                if (xMove == 0) break block4;
                for (int newX = x + xMove; newX >= 0 && newX < this.getGridXSize() && !this.grid[newX][y][z]; newX += xMove) {
                    if (this.grid[newX][y - 1][z]) continue;
                    this.moveCube(x, y, z, newX, y - 1, z, changedCubes);
                    return;
                }
                break block2;
            }
            if (zMove == 0) break block2;
            for (int newZ = z + zMove; newZ >= 0 && newZ < this.getGridZSize() && !this.grid[x][y][newZ]; newZ += zMove) {
                if (this.grid[x][y - 1][newZ]) continue;
                this.moveCube(x, y, z, x, y - 1, newZ, changedCubes);
                return;
            }
        }
    }

    private void upsetCube(int x, int y, int z, int xMove, int zMove, CompoundTag changedCubes, CompoundTag changedSlag) {
        this.breakSlag(x, y, z, changedSlag);
        if (!(y >= this.getGridYSize() - 1 || this.grid[x][y + 1][z] || this.gridHas(x + xMove, y, z + zMove) && this.gridHas(x - xMove, y, z - zMove))) {
            if (this.hasAdjacencyExcluding(x, y + 1, z, x, y, z)) {
                this.moveCube(x, y, z, x, y + 1, z, changedCubes);
            } else if (xMove != 0) {
                int newY;
                int newX = x + xMove;
                int n = newY = !this.grid[newX][y][z] ? y : y + 1;
                while (newX >= 0 && newX < this.getGridXSize() && !this.grid[newX][newY][z] && (this.grid[newX][newY][z] || this.gridHas(newX, newY - 1, z))) {
                    newX += xMove;
                }
                if (!this.gridHas(newX - xMove, newY, z)) {
                    this.moveCube(x, y, z, newX - xMove, newY, z, changedCubes);
                }
            } else if (zMove != 0) {
                int newY;
                int newZ = z + zMove;
                int n = newY = !this.grid[x][y][newZ] ? y : y + 1;
                while (newZ >= 0 && newZ < this.getGridZSize() && !this.grid[x][newY][newZ] && (this.grid[x][newY][newZ] || this.gridHas(x, newY - 1, newZ))) {
                    newZ += zMove;
                }
                if (!this.gridHas(x, newY, newZ - zMove)) {
                    this.moveCube(x, y, z, x, newY, newZ - zMove, changedCubes);
                }
            }
        }
    }

    private void moveCube(int x, int y, int z, int xTo, int yTo, int zTo, CompoundTag changedCubes) {
        this.grid[x][y][z] = false;
        changedCubes.m_128379_(IMicroGrid.idFromPos(x, y, z), false);
        this.grid[xTo][yTo][zTo] = true;
        changedCubes.m_128379_(IMicroGrid.idFromPos(xTo, yTo, zTo), true);
    }

    public boolean hasWaterSource() {
        for (BlockPos searchPos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_142082_(-2, -1, -2), (BlockPos)this.f_58858_.m_142082_(2, 1, 2))) {
            BlockState state = this.f_58857_.m_8055_(searchPos);
            if (!state.m_60819_().m_205070_(TagsNF.FRESHWATER)) continue;
            return true;
        }
        return false;
    }

    public TieredHeat getBestHeatSource() {
        if (this.f_58857_ == null) {
            return TieredHeat.NONE;
        }
        TieredHeat bestHeat = TieredHeat.NONE;
        for (BlockPos searchPos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_142082_(-2, -1, -2), (BlockPos)this.f_58858_.m_142082_(2, 1, 2))) {
            IHeatSource heatSource;
            TieredHeat heat;
            BlockState state = this.f_58857_.m_8055_(searchPos);
            Block block = state.m_60734_();
            if (!(block instanceof IHeatSource) || (heat = (heatSource = (IHeatSource)block).getHeat(this.f_58857_, searchPos, state)).getTier() <= bestHeat.getTier()) continue;
            bestHeat = heat;
        }
        return bestHeat;
    }

    public boolean hasHeatSource(ResourceLocation recipeId) {
        Object t;
        if (this.f_58857_ == null) {
            return false;
        }
        Optional recipe = this.f_58857_.m_7465_().m_44043_(recipeId);
        if (recipe.isPresent() && (t = recipe.get()) instanceof TieredAnvilRecipe) {
            TieredAnvilRecipe anvilRecipe = (TieredAnvilRecipe)t;
            int minTier = anvilRecipe.getTier();
            for (BlockPos searchPos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_142082_(-2, -1, -2), (BlockPos)this.f_58858_.m_142082_(2, 1, 2))) {
                IHeatSource heatSource;
                BlockState state = this.f_58857_.m_8055_(searchPos);
                Block block = state.m_60734_();
                if (!(block instanceof IHeatSource) || (heatSource = (IHeatSource)block).getHeat(this.f_58857_, searchPos, state).getTier() < minTier) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canStartSmithing(Player player, ResourceLocation recipeId) {
        TieredAnvilRecipe anvilRecipe;
        Object t;
        if (this.f_58857_ == null || this.inProgress) {
            return false;
        }
        Optional recipe = this.f_58857_.m_7465_().m_44043_(recipeId);
        if (recipe.isPresent() && (t = recipe.get()) instanceof TieredAnvilRecipe && (anvilRecipe = (TieredAnvilRecipe)t).getTier() <= ((TieredAnvilBlock)this.m_58900_().m_60734_()).tier && anvilRecipe.isUnlocked(player)) {
            return anvilRecipe.getTier() == 0 || this.hasHeatSource(recipeId);
        }
        return false;
    }

    public boolean startSmithing(ResourceLocation recipeId) {
        Object t;
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || this.inProgress) {
            return false;
        }
        this.setRecipeID(recipeId);
        this.inProgress = true;
        this.heatTicks = 1800;
        Optional recipe = this.f_58857_.m_7465_().m_44043_(this.recipeLocation);
        IMicroGrid.clearGrid(this.slag);
        if (recipe.isPresent() && (t = recipe.get()) instanceof TieredAnvilRecipe) {
            float slagChance;
            TieredAnvilRecipe anvilRecipe = (TieredAnvilRecipe)t;
            double pX = (double)this.f_58858_.m_123341_() + 0.5;
            double pY = (double)(this.f_58858_.m_123342_() + 1) + 0.125;
            double pZ = (double)this.f_58858_.m_123343_() + 0.5;
            if (this.getCachedHeat() != TieredHeat.NONE) {
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)((SimpleParticleType)this.getCachedHeat().getFlameParticle().get()), pX, pY, pZ, 14 + this.f_58857_.f_46441_.nextInt(5), 0.125, 0.0625, 0.125, (double)0.008f);
                this.f_58857_.m_6263_(null, pX, pY, pZ, (SoundEvent)SoundsNF.FIRE_WHOOSH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            int[][][] startShape = anvilRecipe.getStartShape();
            ObjectArrayList randPositions = new ObjectArrayList(32);
            for (int x = 0; x < 14; ++x) {
                for (int y = 0; y < 6; ++y) {
                    block6: for (int z = 0; z < 8; ++z) {
                        switch (startShape[x][y][z]) {
                            case 0: {
                                this.grid[x][y][z] = false;
                                continue block6;
                            }
                            case 1: {
                                this.grid[x][y][z] = true;
                                continue block6;
                            }
                            default: {
                                randPositions.add(new Vec3i(x, y, z));
                            }
                        }
                    }
                }
            }
            if (!randPositions.isEmpty()) {
                for (int randAmount = anvilRecipe.getRandMin() + this.f_58857_.f_46441_.nextInt(anvilRecipe.getRandMax() - anvilRecipe.getRandMin()); randAmount >= 0 && !randPositions.isEmpty(); --randAmount) {
                    Vec3i pos = (Vec3i)randPositions.remove(this.f_58857_.f_46441_.nextInt(randPositions.size()));
                    this.grid[pos.m_123341_()][pos.m_123342_()][pos.m_123343_()] = true;
                }
            }
            if ((slagChance = anvilRecipe.getSlagChance()) > 0.0f) {
                for (int slagX = 0; slagX < 14; ++slagX) {
                    for (int slagY = 0; slagY < 6; ++slagY) {
                        for (int slagZ = 0; slagZ < 8; ++slagZ) {
                            if (!this.grid[slagX][slagY][slagZ] || !this.canSlagForm(slagX, slagY, slagZ) || !(this.f_58857_.f_46441_.nextFloat() < slagChance)) continue;
                            this.slag[slagX][slagY][slagZ] = true;
                        }
                    }
                }
            }
        } else {
            this.clearGrid();
        }
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TieredAnvilBlock.HAS_METAL, (Comparable)Boolean.valueOf(true)), 2);
        return true;
    }

    private boolean canSlagForm(int x, int y, int z) {
        return !this.gridHas(x + 1, y, z) || !this.gridHas(x - 1, y, z) || !this.gridHas(x, y + 1, z) || !this.gridHas(x, y, z + 1) || !this.gridHas(x, y, z - 1);
    }

    public ItemStack getResult() {
        return this.result.getStackInSlot(0);
    }

    @Override
    public boolean m_6542_(Player player) {
        return super.m_6542_(player) && !this.inProgress;
    }

    @Override
    public boolean[][][] getGrid() {
        return this.grid;
    }

    @Override
    public int getGridXSize() {
        return 14;
    }

    @Override
    public int getGridYSize() {
        return 6;
    }

    @Override
    public int getGridZSize() {
        return 8;
    }

    @Override
    public Vector3f getWorldGridOffset() {
        return new Vector3f(0.0625f, 1.0f, 0.25f);
    }

    @Override
    public float getRotationDegrees() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)TieredAnvilBlock.FACING);
        return switch (direction) {
            case Direction.NORTH -> 90.0f;
            case Direction.WEST -> 180.0f;
            case Direction.SOUTH -> 270.0f;
            default -> 0.0f;
        };
    }

    @Override
    public ResourceLocation getRecipeID() {
        return this.recipeLocation;
    }

    @Override
    public void setRecipeID(ResourceLocation id) {
        Object t;
        Optional recipe;
        if (this.f_58857_ != null && (recipe = this.f_58857_.m_7465_().m_44043_(id)).isPresent() && (t = recipe.get()) instanceof TieredAnvilRecipe) {
            TieredAnvilRecipe anvilRecipe = (TieredAnvilRecipe)t;
            this.cachedHeat = TieredHeat.fromTier(anvilRecipe.getTier());
            if (this.f_58857_.f_46443_ && !id.equals((Object)this.recipeLocation)) {
                Color metalColor = this.cachedHeat == TieredHeat.NONE ? LevelUtil.getMetalColor(anvilRecipe.m_8043_()) : this.cachedHeat.color;
                FractalSimplexNoiseFast noise = new FractalSimplexNoiseFast(this.f_58857_.f_46441_.nextLong(), 0.107f, 2, 0.5f, 2.0f);
                for (int x = 0; x < this.getGridXSize(); ++x) {
                    for (int y = 0; y < this.getGridYSize(); ++y) {
                        for (int z = 0; z < this.getGridZSize(); ++z) {
                            int gb = Math.round(noise.noise3D(x, y, z) * 40.0f);
                            this.gridColors[x][y][z] = new Color(Mth.m_14045_((int)(metalColor.getRed() + Math.round(noise.noise3D(x, y, z) * 40.0f)), (int)0, (int)255), Mth.m_14045_((int)(metalColor.getGreen() + gb), (int)0, (int)255), Mth.m_14045_((int)(metalColor.getBlue() + gb), (int)0, (int)255));
                        }
                    }
                }
            }
        }
        this.recipeLocation = id;
    }

    private static /* synthetic */ void lambda$useGrid$0(Player p) {
        p.m_21190_(PlayerData.get(p).getActiveHand());
    }
}

