/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.anvil;

import frostnox.nightfall.block.block.anvil.TieredAnvilBlock;
import frostnox.nightfall.block.block.anvil.TieredAnvilBlockEntity;
import frostnox.nightfall.data.recipe.TieredAnvilRecipe;
import frostnox.nightfall.registry.forge.ContainersNF;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import frostnox.nightfall.world.inventory.PartialInventoryContainer;
import frostnox.nightfall.world.inventory.SingleSlot;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.compress.utils.Lists;

public class TieredAnvilContainer
extends PartialInventoryContainer {
    public final TieredAnvilBlockEntity entity;
    private final ContainerLevelAccess access;
    public List<TieredAnvilRecipe> recipes = Lists.newArrayList();
    private final ItemStackHandlerNF inventory;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();

    public TieredAnvilContainer(int windowID, final Inventory playerInv, final TieredAnvilBlockEntity entity) {
        super((MenuType)ContainersNF.TIERED_ANVIL.get(), playerInv, windowID, true);
        this.entity = entity;
        this.access = ContainerLevelAccess.m_39289_((Level)entity.m_58904_(), (BlockPos)entity.m_58899_());
        this.inventory = new ItemStackHandlerNF(3){

            protected void onContentsChanged(int slot) {
                if (entity.m_58904_() == null || !entity.m_58904_().f_46443_) {
                    return;
                }
                TieredAnvilContainer.this.setupRecipes(playerInv.f_35978_);
            }
        };
        this.m_38897_((Slot)new SingleSlot((IItemHandler)this.inventory, 0, 17, 17));
        this.m_38897_((Slot)new SingleSlot((IItemHandler)this.inventory, 1, 17, 35));
        this.m_38897_((Slot)new SingleSlot((IItemHandler)this.inventory, 2, 17, 53));
        this.m_38895_(this.selectedRecipe);
        this.selectedRecipe.m_6422_(-1);
    }

    public boolean hasValidInput() {
        return !this.inventory.isEmpty() && !this.recipes.isEmpty();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipe.m_6501_();
    }

    public void setupRecipes(Player player) {
        this.selectedRecipe.m_6422_(-1);
        if (!this.inventory.isEmpty()) {
            this.recipes = this.entity.m_58904_().m_7465_().m_44056_(TieredAnvilRecipe.TYPE, (Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.entity.m_58904_()).stream().filter(recipe -> recipe.getTier() <= ((TieredAnvilBlock)this.entity.m_58900_().m_60734_()).tier && recipe.isUnlocked(player)).toList();
        } else {
            this.recipes.clear();
        }
    }

    public void consumeInputs() {
        this.inventory.clear();
    }

    public static TieredAnvilContainer createClientContainer(int windowID, Inventory playerInv, FriendlyByteBuf extraData) {
        BlockEntity entity = playerInv.f_35978_.f_19853_.m_7702_(extraData.m_130135_());
        if (entity instanceof TieredAnvilBlockEntity) {
            TieredAnvilBlockEntity anvilEntity = (TieredAnvilBlockEntity)entity;
            return new TieredAnvilContainer(windowID, playerInv, anvilEntity);
        }
        throw new IllegalStateException("Anvil block entity does not exist at " + extraData.m_130135_());
    }

    public boolean m_6366_(Player player, int index) {
        if (index >= 0 && index < this.recipes.size() && index != this.selectedRecipe.m_6501_()) {
            this.selectedRecipe.m_6422_(index);
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return this.entity.m_6542_(player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(player, (Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory)));
    }
}

