/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.barrel;

import frostnox.nightfall.block.IHoldable;
import frostnox.nightfall.block.block.MenuContainerBlockEntity;
import frostnox.nightfall.block.block.barrel.BarrelBlockNF;
import frostnox.nightfall.data.recipe.BarrelRecipe;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import frostnox.nightfall.world.inventory.StorageContainer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockEntityNF
extends MenuContainerBlockEntity
implements IHoldable {
    public static final int ROWS = 4;
    public static final int COLUMNS = 3;
    public static final int MAX_RECIPES = 3;
    public final ItemStackHandlerNF inventory;
    public final List<ResourceLocation> activeRecipes = new ObjectArrayList((Object[])new ResourceLocation[3]);
    public final IntList soakTicks = new IntArrayList(new int[3]);
    public final IntList soakDurations = new IntArrayList(IntStream.generate(() -> 1).limit(3L).toArray());
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return pIndex < 3 ? BarrelBlockEntityNF.this.soakTicks.getInt(pIndex) : BarrelBlockEntityNF.this.soakDurations.getInt(pIndex - 3);
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex < 3) {
                BarrelBlockEntityNF.this.soakTicks.set(pIndex, pValue);
            } else {
                BarrelBlockEntityNF.this.soakDurations.set(pIndex - 3, pValue);
            }
        }

        public int m_6499_() {
            return 6;
        }
    };
    private final ContainerOpenersCounter opener = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntityNF.this.playSound(state, SoundEvents.f_11725_);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BarrelBlockNF.OPEN, (Comparable)Boolean.valueOf(true)));
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntityNF.this.playSound(state, SoundEvents.f_11724_);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BarrelBlockNF.OPEN, (Comparable)Boolean.valueOf(false)));
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof StorageContainer) {
                StorageContainer storageContainer = (StorageContainer)abstractContainerMenu;
                return storageContainer.entity == BarrelBlockEntityNF.this;
            }
            return false;
        }
    };

    public BarrelBlockEntityNF(BlockPos pos, BlockState pBlockState) {
        this((BlockEntityType)BlockEntitiesNF.BARREL.get(), pos, pBlockState);
    }

    protected BarrelBlockEntityNF(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.inventory = new ItemStackHandlerNF(12){

            protected void onContentsChanged(int slot) {
                if (BarrelBlockEntityNF.this.f_58857_ == null || BarrelBlockEntityNF.this.f_58857_.m_5776_()) {
                    return;
                }
                BarrelBlockEntityNF.this.m_6596_();
                int column = slot % 3;
                NonNullList items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
                int inputSize = 0;
                for (int i = 0; i < 4; ++i) {
                    ItemStack item = BarrelBlockEntityNF.this.inventory.getStackInSlot(column + i * 3);
                    items.set(i, (Object)item);
                    if (inputSize != 0 || item.m_41619_()) continue;
                    inputSize = item.m_41613_();
                }
                Optional newRecipe = BarrelBlockEntityNF.this.f_58857_.m_7465_().m_44015_(BarrelRecipe.TYPE, (Container)new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandlerNF((NonNullList<ItemStack>)items)), BarrelBlockEntityNF.this.f_58857_);
                BarrelBlockEntityNF.this.activeRecipes.set(column, newRecipe.isPresent() ? ((BarrelRecipe)newRecipe.get()).m_6423_() : null);
                BarrelBlockEntityNF.this.soakTicks.set(column, 0);
                BarrelBlockEntityNF.this.soakDurations.set(column, newRecipe.isPresent() ? (((BarrelRecipe)newRecipe.get()).hasFixedSoakTime() ? ((BarrelRecipe)newRecipe.get()).getSoakTime() : ((BarrelRecipe)newRecipe.get()).getSoakTime() * inputSize) : 1);
            }
        };
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BarrelBlockEntityNF entity) {
        boolean changed = false;
        for (int i = 0; i < 3; ++i) {
            Optional recipe;
            ResourceLocation recipeLocation = entity.activeRecipes.get(i);
            if (recipeLocation == null || !(recipe = level.m_7465_().m_44043_(recipeLocation)).isPresent()) continue;
            int soakTicks = entity.soakTicks.getInt(i) + 1;
            entity.soakTicks.set(i, soakTicks);
            changed = true;
            if (soakTicks < entity.soakDurations.getInt(i)) continue;
            NonNullList items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            for (int j = 0; j < 4; ++j) {
                int slot = i + j * 3;
                items.set(j, (Object)entity.inventory.getStackInSlot(slot));
                entity.inventory.setStackInSlot(slot, ItemStack.f_41583_);
            }
            ItemStack item = ((BarrelRecipe)recipe.get()).assemble(new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandlerNF((NonNullList<ItemStack>)items)));
            entity.inventory.setStackInSlot(i, item);
        }
        if (changed) {
            entity.m_6596_();
        }
    }

    @Override
    @Nullable
    public ContainerData getData() {
        return this.data;
    }

    @Override
    public ItemStackHandlerNF getInventory() {
        return this.inventory;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("nightfall.barrel");
    }

    protected AbstractContainerMenu m_6555_(int pId, Inventory playerInv) {
        return StorageContainer.createBarrelContainer(pId, playerInv, (BlockEntity)this);
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.opener.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.opener.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.opener.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    private void playSound(BlockState state, SoundEvent pSound) {
        Vec3i normal = ((Direction)state.m_61143_((Property)BarrelBlockNF.FACING)).m_122436_();
        this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5 + (double)normal.m_123341_() / 2.0, (double)this.f_58858_.m_123342_() + 0.5 + (double)normal.m_123342_() / 2.0, (double)this.f_58858_.m_123343_() + 0.5 + (double)normal.m_123343_() / 2.0, pSound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        DataUtil.loadSlottedData(tag.m_128437_("recipes", 10), this.activeRecipes, t -> ResourceLocation.parse((String)t.m_128461_("recipe")));
        DataUtil.loadSlottedData(tag.m_128437_("soakTicks", 10), this.soakTicks, t -> t.m_128451_("ticks"));
        DataUtil.loadSlottedData(tag.m_128437_("soakDurations", 10), this.soakDurations, t -> t.m_128451_("duration"));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("recipes", (Tag)DataUtil.writeSlottedData(this.activeRecipes, (t, r) -> t.m_128359_("recipe", r.toString())));
        tag.m_128365_("soakTicks", (Tag)DataUtil.writeSlottedData(this.soakTicks, (t, i) -> t.m_128405_("ticks", i.intValue()), i -> i == 0));
        tag.m_128365_("soakDurations", (Tag)DataUtil.writeSlottedData(this.soakDurations, (t, i) -> t.m_128405_("duration", i.intValue()), i -> i == 1));
    }

    @Override
    public CompoundTag writeDataAndClear() {
        CompoundTag data = this.m_187481_();
        data.m_128405_("state", Block.m_49956_((BlockState)this.m_58900_().m_60734_().m_49966_()));
        this.inventory.clear();
        return data;
    }

    @Override
    public void onDrop(Level level, BlockPos pos) {
        NonNullList<ItemStack> drops = this.getContainerDrops();
        drops.add((Object)new ItemStack((ItemLike)this.m_58900_().m_60734_().m_5456_()));
        if (level != null) {
            Containers.m_19010_((Level)level, (BlockPos)pos, drops);
        }
    }
}

