/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.barrel;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.barrel.BarrelBlockEntityNF;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.item.item.FilledBucketItem;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockNF
extends WaterloggedEntityBlock
implements ICustomPathfindable {
    public static final DirectionProperty FACING = BlockStatePropertiesNF.FACING_NOT_DOWN;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHAPE_Y = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_Z = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0);
    protected static final List<AABB> AABB_X = List.of((AABB)SHAPE_X.m_83299_().get(0));
    protected static final List<AABB> AABB_Y = List.of((AABB)SHAPE_Y.m_83299_().get(0));
    protected static final List<AABB> AABB_Z = List.of((AABB)SHAPE_Z.m_83299_().get(0));

    public BarrelBlockNF(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.BARREL.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entity) {
        if (level.m_5776_()) {
            return null;
        }
        return BarrelBlockNF.createTickerHelper(entity, (BlockEntityType)BlockEntitiesNF.BARREL.get(), BarrelBlockEntityNF::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos facingPos = pos.m_142300_(facing);
        if (!level.m_8055_(facingPos).m_60659_((BlockGetter)level, facingPos, facing.m_122424_(), SupportType.FULL) && (blockEntity = level.m_7702_(pos)) instanceof BarrelBlockEntityNF) {
            BarrelBlockEntityNF barrel = (BarrelBlockEntityNF)blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            ItemStack item = pPlayer.m_21120_(pHand);
            Item item2 = item.m_41720_();
            if (item2 instanceof FilledBucketItem) {
                FilledBucketItem bucket = (FilledBucketItem)item2;
                barrel.m_6555_(serverPlayer.f_8940_, pPlayer.m_150109_()).m_7648_(pPlayer, 27 + pPlayer.m_150109_().f_35977_);
                if (item.m_41619_()) {
                    bucket.playEmptySound(null, (LevelAccessor)level, pos);
                }
            } else {
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)barrel, (BlockPos)pos);
            }
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return switch (((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> SHAPE_X;
            case Direction.Axis.Y -> SHAPE_Y;
            case Direction.Axis.Z -> SHAPE_Z;
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(pNewState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof Container) {
            Container container = (Container)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
        }
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity;
        if (pStack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
            container.m_58638_(pStack.m_41786_());
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BarrelBlockEntityNF) {
            BarrelBlockEntityNF barrel = (BarrelBlockEntityNF)blockEntity;
            barrel.recheckOpen();
        }
    }

    public BlockState m_6843_(BlockState state, Rotation pRotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        return state.m_60717_(pMirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, OPEN});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)(pContext.m_43719_().m_122434_().m_122478_() ? Direction.UP : pContext.m_43719_()));
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        if (state.m_61143_((Property)FACING) == Direction.UP) {
            return NodeType.CLOSED;
        }
        return this.getTypeForCenteredBottomShape(nodeManager, pos, 0.75f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_61143_((Property)FACING) == Direction.UP ? NodeType.CLOSED : NodeType.OPEN;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return switch (((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> AABB_X;
            case Direction.Axis.Y -> AABB_Y;
            case Direction.Axis.Z -> AABB_Z;
        };
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return switch (((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> AABB_X;
            case Direction.Axis.Y -> AABB_Y;
            case Direction.Axis.Z -> AABB_Z;
        };
    }
}

