/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.bowl;

import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.bowl.BowlBlockEntity;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.data.recipe.BowlCrushingRecipe;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class BowlBlock
extends WaterloggedEntityBlock {
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), (VoxelShape)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), (VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (BooleanOp)BooleanOp.f_82687_));

    public BowlBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.BOWL.get()).m_155264_(pos, state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!(state = super.m_7417_(state, facing, facingState, level, pos, facingPos)).m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        if (player.m_6047_() && player.m_21120_(pHand).m_41619_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BowlBlockEntity)) return InteractionResult.PASS;
        BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(pHand);
        if (bowl.item.m_41619_()) {
            if (heldItem.m_41619_()) return InteractionResult.PASS;
            bowl.item = player.m_150110_().f_35937_ ? new ItemStack((ItemLike)heldItem.m_41720_()) : heldItem.m_41620_(1);
            bowl.itemAngle = (float)Math.round(-player.m_5675_(1.0f) / 45.0f) * 45.0f;
            bowl.m_6596_();
            level.m_7260_(pos, state, state, 2);
            return InteractionResult.CONSUME;
        } else {
            IPlayerData capP = PlayerData.get(player);
            capP.setHeldItemForRecipe(heldItem);
            RecipeWrapper container = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{bowl.item})));
            ForgeHooks.setCraftingPlayer((Player)player);
            Optional recipe = level.m_7465_().m_44015_(BowlCrushingRecipe.TYPE, (Container)container, level);
            ForgeHooks.setCraftingPlayer(null);
            capP.setHeldItemForRecipe(ItemStack.f_41583_);
            if (recipe.isPresent() && ((BowlCrushingRecipe)recipe.get()).isUnlocked(player)) {
                ++bowl.crushes;
                if (heldItem.m_41763_() && bowl.crushes % 2 == 0) {
                    heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(pHand));
                }
                level.m_5594_(null, pos, (SoundEvent)SoundsNF.WOODEN_BOWL_CRUSH.get(), SoundSource.PLAYERS, 1.0f, 0.97f + 0.06f * level.f_46441_.nextFloat());
                ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, bowl.item), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.35, (double)pos.m_123343_() + 0.5, 3 + level.f_46441_.nextInt() % 2, 0.025, 0.01, 0.025, 0.025);
                if (bowl.crushes < 4) return InteractionResult.CONSUME;
                bowl.item = new ItemStack((ItemLike)((BowlCrushingRecipe)recipe.get()).m_8043_().m_41720_(), bowl.item.m_41613_());
                bowl.crushes = 0;
                bowl.m_6596_();
                level.m_7260_(pos, state, state, 2);
                return InteractionResult.CONSUME;
            } else {
                LevelUtil.giveItemToPlayer(bowl.item.m_41777_(), player, true);
                bowl.item = ItemStack.f_41583_;
                bowl.m_6596_();
                level.m_7260_(pos, state, state, 2);
            }
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(pNewState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)bowl.item);
        }
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }
}

