/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.campfire;

import frostnox.nightfall.block.block.campfire.CampfireBlockNF;
import frostnox.nightfall.data.recipe.CampfireRecipe;
import frostnox.nightfall.data.recipe.SingleRecipe;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CampfireBlockEntityNF
extends BlockEntity
implements Clearable {
    public static final int CAPACITY = 3;
    public static final int COOK_TIME = 1200;
    public static final int FIREWOOD_BURN_TICKS = 2400;
    public final NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private final int[] cookTicks = new int[3];
    private int burnTicks;

    public CampfireBlockEntityNF(BlockPos pos, BlockState pBlockState) {
        this((BlockEntityType)BlockEntitiesNF.CAMPFIRE.get(), pos, pBlockState);
    }

    protected CampfireBlockEntityNF(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, CampfireBlockEntityNF campfire) {
        boolean changed = false;
        for (int i = 0; i < campfire.items.size(); ++i) {
            ItemStack item = (ItemStack)campfire.items.get(i);
            if (item.m_41619_() || item.m_150930_((Item)ItemsNF.BURNT_FOOD.get())) continue;
            changed = true;
            int n = i;
            campfire.cookTicks[n] = campfire.cookTicks[n] + 1;
            RecipeWrapper container = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{item})));
            Optional campfireRecipe = level.m_7465_().m_44015_(CampfireRecipe.TYPE, (Container)container, level);
            if (campfire.cookTicks[i] < campfireRecipe.map(SingleRecipe::getCookTime).orElse(1200)) continue;
            campfire.cookTicks[i] = 0;
            ItemStack cookedItem = campfireRecipe.map(recipe -> recipe.assemble(container)).orElse(new ItemStack((ItemLike)ItemsNF.BURNT_FOOD.get()));
            campfire.items.set(i, (Object)cookedItem);
            level.m_7260_(pos, state, state, 3);
            level.m_5594_(null, pos, (SoundEvent)SoundsNF.SIZZLE.get(), SoundSource.BLOCKS, 1.0f, 0.97f + level.f_46441_.nextFloat() * 0.06f);
        }
        ++campfire.burnTicks;
        if (campfire.burnTicks >= 2400) {
            campfire.burnTicks = 0;
            int firewood = (Integer)state.m_61143_((Property)CampfireBlockNF.FIREWOOD);
            if (firewood == 1) {
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)CampfireBlockNF.FIREWOOD, (Comparable)Integer.valueOf(0))).m_61124_((Property)CampfireBlockNF.LIT, (Comparable)Boolean.valueOf(false)));
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)CampfireBlockNF.FIREWOOD, (Comparable)Integer.valueOf(firewood - 1)));
            }
            ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ParticleTypesNF.FLAME_RED.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.21875, (double)pos.m_123343_() + 0.5, 12, 0.25, 0.109375, 0.25, 0.014);
            level.m_5594_(null, pos, (SoundEvent)SoundsNF.FIRE_WHOOSH.get(), SoundSource.BLOCKS, 0.5f, 0.9f + level.f_46441_.nextFloat() * 0.1f);
        }
        if (changed) {
            CampfireBlockEntityNF.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, CampfireBlockEntityNF campfire) {
        boolean changed = false;
        for (int i = 0; i < campfire.items.size(); ++i) {
            if (campfire.cookTicks[i] > 0) {
                changed = true;
                campfire.cookTicks[i] = Mth.m_14045_((int)(campfire.cookTicks[i] - 2), (int)0, (int)1200);
            }
            if (campfire.burnTicks <= 0) continue;
            changed = true;
            --campfire.burnTicks;
        }
        if (changed) {
            CampfireBlockEntityNF.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, CampfireBlockEntityNF campfire) {
        Random random = level.f_46441_;
        if (random.nextFloat() < 0.11f) {
            for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                CampfireBlock.m_51251_((Level)level, (BlockPos)pos, (boolean)false, (boolean)false);
            }
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(CampfireBlockNF.AXIS);
        for (int i = 0; i < campfire.items.size(); ++i) {
            if (((ItemStack)campfire.items.get(i)).m_41619_() || !(random.nextFloat() < 0.2f)) continue;
            double x = (double)pos.m_123341_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            if (axis == Direction.Axis.Z) {
                if (i % 2 == 1) {
                    x += 0.25 * (double)((i + 1) / 2);
                } else if (i > 0) {
                    x -= 0.25 * (double)(i / 2);
                }
            } else if (i % 2 == 1) {
                z += 0.25 * (double)((i + 1) / 2);
            } else if (i > 0) {
                z -= 0.25 * (double)(i / 2);
            }
            double y = (double)pos.m_123342_() + 1.0;
            for (int j = 0; j < 2; ++j) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128425_("cookTicks", 11)) {
            int[] cookTicks = tag.m_128465_("cookTicks");
            System.arraycopy(cookTicks, 0, this.cookTicks, 0, cookTicks.length);
        }
        this.burnTicks = tag.m_128451_("burnTicks");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)true);
        tag.m_128385_("cookTicks", this.cookTicks);
        tag.m_128405_("burnTicks", this.burnTicks);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)true);
        return tag;
    }

    public boolean placeFood(ItemStack food) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = (ItemStack)this.items.get(i);
            if (!item.m_41619_()) continue;
            this.cookTicks[i] = 0;
            this.items.set(i, (Object)food.m_41620_(1));
            this.m_6596_();
            if (!((Boolean)this.m_58900_().m_61143_((Property)CampfireBlockNF.HAS_FOOD)).booleanValue()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CampfireBlockNF.HAS_FOOD, (Comparable)Boolean.valueOf(true)));
            } else {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
            return true;
        }
        return false;
    }

    public ItemStack takeFood() {
        ItemStack bestItem = ItemStack.f_41583_;
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = (ItemStack)this.items.get(i);
            if (item.m_41619_()) continue;
            bestItem = item;
            index = i;
            if (this.f_58857_.m_7465_().m_44015_(CampfireRecipe.TYPE, (Container)new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{item}))), this.f_58857_).isEmpty()) break;
        }
        if (!bestItem.m_41619_()) {
            this.cookTicks[index] = 0;
            this.items.set(index, (Object)ItemStack.f_41583_);
            this.m_6596_();
            if (this.items.stream().allMatch(ItemStack::m_41619_)) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CampfireBlockNF.HAS_FOOD, (Comparable)Boolean.valueOf(false)));
            } else {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
            return bestItem;
        }
        return ItemStack.f_41583_;
    }

    public void m_6211_() {
        this.items.clear();
    }
}

