/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.campfire;

import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IAdjustableNodeType;
import frostnox.nightfall.block.IHeatSource;
import frostnox.nightfall.block.IIgnitable;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.campfire.CampfireBlockEntityNF;
import frostnox.nightfall.data.recipe.CampfireRecipe;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.item.item.FireStarterItem;
import frostnox.nightfall.item.item.IgnitableItem;
import frostnox.nightfall.item.item.TorchItem;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class CampfireBlockNF
extends WaterloggedEntityBlock
implements IIgnitable,
IHeatSource,
IAdjustableNodeType {
    public static final int MAX_FUEL = 4;
    private static final VoxelShape INTERACTION_SHAPE_HIGH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape INTERACTION_SHAPE_LOW = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape INTERACTION_SHAPE_ZERO = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    private static final VoxelShape COLLISION_SHAPE_Z1 = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)5.0, (double)4.0, (double)16.0);
    private static final VoxelShape COLLISION_SHAPE_Z2 = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE_Z1, (VoxelShape)Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0));
    private static final VoxelShape COLLISION_SHAPE_Z3 = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE_Z2, (VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)11.0, (double)16.0, (double)7.0, (double)16.0));
    private static final VoxelShape COLLISION_SHAPE_Z4 = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE_Z3, (VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)5.0));
    private static final VoxelShape COLLISION_SHAPE_X1 = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0, (double)5.0);
    private static final VoxelShape COLLISION_SHAPE_X2 = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE_X1, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)4.0, (double)15.0));
    private static final VoxelShape COLLISION_SHAPE_X3 = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE_X2, (VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)5.0, (double)7.0, (double)16.0));
    private static final VoxelShape COLLISION_SHAPE_X4 = Shapes.m_83110_((VoxelShape)COLLISION_SHAPE_X3, (VoxelShape)Block.m_49796_((double)11.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0));
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty HAS_FOOD = BlockStatePropertiesNF.HAS_FOOD;
    public static final IntegerProperty FIREWOOD = BlockStatePropertiesNF.FIREWOOD;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public CampfireBlockNF(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_FOOD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FIREWOOD, (Comparable)Integer.valueOf(4))).m_61124_(AXIS, (Comparable)Direction.Axis.Z));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CampfireBlockEntityNF) {
            CampfireBlockEntityNF campfire = (CampfireBlockEntityNF)blockEntity;
            ItemStack item = player.m_21120_(pHand);
            if (item.m_150930_((Item)ItemsNF.FIREWOOD.get())) {
                int firewood = (Integer)state.m_61143_((Property)FIREWOOD);
                if (firewood < 4) {
                    level.m_5594_(player, pos, (SoundEvent)SoundsNF.FIREWOOD_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!level.f_46443_) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)FIREWOOD, (Comparable)Integer.valueOf(firewood + 1)));
                        if (!player.m_150110_().f_35937_) {
                            item.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
                return InteractionResult.CONSUME;
            }
            if (item.m_41720_() instanceof FireStarterItem || item.m_41720_() instanceof IgnitableItem || item.m_41720_() instanceof TorchItem) {
                return InteractionResult.PASS;
            }
            if ((campfire.items.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : level.m_7465_().m_44015_(CampfireRecipe.TYPE, (Container)new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{item}))), level)).isPresent()) {
                if (!level.f_46443_ && campfire.placeFood(player.m_150110_().f_35937_ ? item.m_41777_() : item)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (campfire.items.stream().anyMatch(food -> !food.m_41619_())) {
                ItemStack food2;
                if (!level.f_46443_ && !(food2 = campfire.takeFood()).m_41619_()) {
                    LevelUtil.giveItemToPlayer(food2, player, true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        this.spreadHeat((Level)level, pos, this.getHeat((Level)level, pos, state));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (this.isIgnited(state = super.m_7417_(state, facing, facingState, level, pos, facingPos))) {
            this.scheduleHeatTick(level, pos, this);
        }
        return state;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity pEntity) {
        if (!pEntity.m_5825_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && pEntity instanceof LivingEntity) {
            pEntity.m_6469_((DamageSource)DamageTypeSource.IN_FIRE, 5.0f);
        }
        super.m_7892_(state, level, pos, pEntity);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        if (!state.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CampfireBlockEntityNF) {
                CampfireBlockEntityNF campfire = (CampfireBlockEntityNF)blockEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, campfire.items);
            }
            super.m_6810_(state, level, pos, pNewState, pIsMoving);
            this.spreadHeat(level, pos, TieredHeat.NONE);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return this.addLiquidToPlacement((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122434_()), pContext);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        int firewood = (Integer)state.m_61143_((Property)FIREWOOD);
        return firewood <= 2 ? (firewood == 0 ? INTERACTION_SHAPE_ZERO : INTERACTION_SHAPE_LOW) : INTERACTION_SHAPE_HIGH;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        if ((Integer)state.m_61143_((Property)FIREWOOD) == 0) {
            EntityCollisionContext entityContext;
            if (pContext instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)pContext).m_193113_() != null) {
                return Shapes.m_83040_();
            }
            return INTERACTION_SHAPE_ZERO;
        }
        if (state.m_61143_(AXIS) == Direction.Axis.Z) {
            return switch ((Integer)state.m_61143_((Property)FIREWOOD)) {
                case 1 -> COLLISION_SHAPE_Z1;
                case 2 -> COLLISION_SHAPE_Z2;
                case 3 -> COLLISION_SHAPE_Z3;
                default -> COLLISION_SHAPE_Z4;
            };
        }
        return switch ((Integer)state.m_61143_((Property)FIREWOOD)) {
            case 1 -> COLLISION_SHAPE_X1;
            case 2 -> COLLISION_SHAPE_X2;
            case 3 -> COLLISION_SHAPE_X3;
            default -> COLLISION_SHAPE_X4;
        };
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random pRand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            if (pRand.nextInt(10) == 0) {
                level.m_7785_((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + pRand.nextFloat(), pRand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (pRand.nextBoolean()) {
                int firewood = (Integer)state.m_61143_((Property)FIREWOOD);
                if (state.m_61143_(AXIS) == Direction.Axis.Z) {
                    CampfireBlockNF.spawnFireParticle(level, pRand, (double)x + 0.0625, y, z, false);
                    if (firewood >= 2) {
                        CampfireBlockNF.spawnFireParticle(level, pRand, (double)x + 0.6875, y, z, false);
                    }
                    if (firewood >= 3) {
                        CampfireBlockNF.spawnFireParticle(level, pRand, x, (double)y + 0.1875, (double)z + 0.6875, true);
                    }
                    if (firewood == 4) {
                        CampfireBlockNF.spawnFireParticle(level, pRand, x, (double)y + 0.1875, (double)z + 0.0625, true);
                    }
                } else {
                    CampfireBlockNF.spawnFireParticle(level, pRand, x, y, (double)z + 0.0625, true);
                    if (firewood >= 2) {
                        CampfireBlockNF.spawnFireParticle(level, pRand, x, y, (double)z + 0.6875, true);
                    }
                    if (firewood >= 3) {
                        CampfireBlockNF.spawnFireParticle(level, pRand, (double)x + 0.6875, (double)y + 0.1875, z, false);
                    }
                    if (firewood == 4) {
                        CampfireBlockNF.spawnFireParticle(level, pRand, (double)x + 0.0625, (double)y + 0.1875, z, false);
                    }
                }
            }
        }
    }

    private static void spawnFireParticle(Level level, Random rand, double xMin, double yMin, double zMin, boolean xAligned) {
        double x = xMin;
        double y = yMin;
        double z = zMin;
        switch (rand.nextInt(3)) {
            case 0: {
                x += (xAligned ? 1.0 : 0.25) * rand.nextDouble();
                y += 0.25;
                z += (xAligned ? 0.25 : 1.0) * rand.nextDouble();
                break;
            }
            case 1: {
                if (xAligned) {
                    x += rand.nextDouble();
                } else {
                    z += rand.nextDouble();
                }
                y += 0.25 * rand.nextDouble();
                break;
            }
            case 2: {
                if (xAligned) {
                    x += rand.nextDouble();
                    z += 0.25;
                } else {
                    z += rand.nextDouble();
                    x += 0.25;
                }
                y += 0.25 * rand.nextDouble();
            }
        }
        level.m_7106_((ParticleOptions)ParticleTypesNF.FLAME_RED.get(), x, y, z, 0.0, 0.0, 0.0);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos blockpos = pHit.m_82425_();
        if (!level.f_46443_ && pProjectile.m_6060_() && pProjectile.m_142265_(level, blockpos) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && (Integer)state.m_61143_((Property)WATER_LEVEL) == 0) {
            level.m_7731_(blockpos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation pRot) {
        return switch (pRot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{LIT, HAS_FOOD, FIREWOOD, AXIS});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> pBlockEntityType) {
        if (level.f_46443_) {
            return (Boolean)state.m_61143_((Property)LIT) != false ? CampfireBlockNF.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntitiesNF.CAMPFIRE.get(), CampfireBlockEntityNF::particleTick) : null;
        }
        return (Boolean)state.m_61143_((Property)LIT) != false ? CampfireBlockNF.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntitiesNF.CAMPFIRE.get(), CampfireBlockEntityNF::cookTick) : CampfireBlockNF.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntitiesNF.CAMPFIRE.get(), CampfireBlockEntityNF::cooldownTick);
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluid) {
        if (super.m_7361_(level, pos, state, fluid)) {
            if (level.m_5776_()) {
                return true;
            }
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
                this.scheduleHeatTick(level, pos, this);
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.375f, 2.6f + (level.m_5822_().nextFloat() - level.m_5822_().nextFloat()) * 0.8f);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, 8, 0.25, 0.25, 0.25, 0.0);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CampfireBlockEntityNF(pos, state);
    }

    @Override
    public boolean tryToIgnite(Level level, BlockPos pos, BlockState state, ItemStack stack, TieredHeat heat) {
        if (level.m_5776_() || (Integer)state.m_61143_((Property)FIREWOOD) == 0) {
            return false;
        }
        if (!this.isIgnited(state)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
            this.scheduleHeatTick((LevelAccessor)level, pos, this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnited(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    @Override
    public TieredHeat getHeat(Level level, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? TieredHeat.RED : TieredHeat.NONE;
    }

    @Override
    public NodeType adjustNodeType(NodeType type, BlockState state, LivingEntity entity) {
        return !this.isIgnited(state) || entity.m_5825_() ? type : (type.walkable ? NodeType.PASSABLE_DANGER_MINOR : NodeType.IMPASSABLE_DANGER_MINOR);
    }
}

