/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.cauldron;

import frostnox.nightfall.block.IHoldable;
import frostnox.nightfall.block.block.MenuContainerBlockEntity;
import frostnox.nightfall.block.block.cauldron.CauldronBlockNF;
import frostnox.nightfall.block.block.cauldron.Task;
import frostnox.nightfall.data.recipe.CauldronRecipe;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import frostnox.nightfall.world.inventory.StorageContainer;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class CauldronBlockEntity
extends MenuContainerBlockEntity
implements IHoldable {
    public final ItemStackHandlerNF inventory;
    protected ResourceLocation recipeLocation;
    protected int cookTicks;
    protected int cookTicksTotal = 3000;
    public ItemStack meal = ItemStack.f_41583_;
    public boolean hot = false;
    private boolean needsUpdate = false;
    public int animTick;
    public int forceEntityRenderTick = -1;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            if (pIndex == 0) {
                return CauldronBlockEntity.this.cookTicks;
            }
            return CauldronBlockEntity.this.cookTicksTotal;
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex == 0) {
                CauldronBlockEntity.this.cookTicks = pValue;
            } else {
                CauldronBlockEntity.this.cookTicksTotal = pValue;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CauldronBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesNF.CAULDRON.get(), pos, state);
    }

    protected CauldronBlockEntity(BlockEntityType<?> pType, final BlockPos pos, BlockState pBlockState) {
        super(pType, pos, pBlockState);
        this.inventory = new ItemStackHandlerNF(4){

            protected void onContentsChanged(int slot) {
                Optional newRecipe;
                if (CauldronBlockEntity.this.f_58857_ == null || CauldronBlockEntity.this.f_58857_.m_5776_()) {
                    return;
                }
                CauldronBlockEntity.this.m_6596_();
                if (CauldronBlockEntity.this.m_58900_().m_61143_(CauldronBlockNF.TASK) == Task.IDLE && CauldronBlockEntity.this.canCookMeal()) {
                    CauldronBlockEntity.this.f_58857_.m_46597_(pos, (BlockState)CauldronBlockEntity.this.m_58900_().m_61124_(CauldronBlockNF.TASK, (Comparable)((Object)Task.COOK)));
                }
                CauldronBlockEntity.this.recipeLocation = (newRecipe = CauldronBlockEntity.this.f_58857_.m_7465_().m_44015_(CauldronRecipe.TYPE, (Container)new RecipeWrapper((IItemHandlerModifiable)CauldronBlockEntity.this.inventory), CauldronBlockEntity.this.f_58857_)).isPresent() ? ((CauldronRecipe)newRecipe.get()).m_6423_() : null;
                CauldronBlockEntity.this.cookTicks = 0;
                CauldronBlockEntity.this.cookTicksTotal = newRecipe.isPresent() ? ((CauldronRecipe)newRecipe.get()).getCookTime() : 3000;
            }
        };
    }

    public int getCookTicks() {
        return this.cookTicks;
    }

    public int getCookTicksTotal() {
        return this.cookTicksTotal;
    }

    public boolean canCookMeal() {
        if (!this.hot) {
            return false;
        }
        int water = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack item = this.inventory.getStackInSlot(i);
            if (item.m_41619_()) {
                return false;
            }
            if (!item.m_150930_((Item)ItemsNF.WATER.get()) && !item.m_150930_((Item)ItemsNF.SEAWATER.get()) || ++water <= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public ContainerData getData() {
        return this.data;
    }

    @Override
    public ItemStackHandlerNF getInventory() {
        return this.inventory;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("nightfall.cauldron");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return StorageContainer.createCauldronContainer(pContainerId, pInventory, (BlockEntity)this);
    }

    public void m_5856_(Player pPlayer) {
        this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)SoundsNF.CERAMIC_OPEN_LARGE.get(), SoundSource.BLOCKS, 1.0f, 0.94f + this.f_58857_.f_46441_.nextFloat() * 0.12f);
        this.f_58857_.m_142346_((Entity)pPlayer, GameEvent.f_157803_, this.f_58858_);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("recipe", 8)) {
            this.recipeLocation = ResourceLocation.parse((String)tag.m_128461_("recipe"));
        }
        this.cookTicks = tag.m_128451_("ticks");
        this.cookTicksTotal = tag.m_128451_("ticksTotal");
        this.meal = ItemStack.m_41712_((CompoundTag)tag.m_128469_("meal"));
        this.hot = tag.m_128471_("hot");
        this.needsUpdate = !this.meal.m_41619_() || this.hot;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.recipeLocation != null) {
            tag.m_128359_("recipe", this.recipeLocation.toString());
        }
        tag.m_128405_("ticks", this.cookTicks);
        tag.m_128405_("ticksTotal", this.cookTicksTotal);
        tag.m_128379_("hot", this.hot);
        if (!this.meal.m_41619_()) {
            tag.m_128365_("meal", (Tag)this.meal.m_41739_(new CompoundTag()));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }
        return null;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("hot", this.hot);
        if (!this.meal.m_41619_()) {
            tag.m_128365_("meal", (Tag)this.meal.m_41739_(new CompoundTag()));
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.hot = tag.m_128471_("hot");
        this.meal = ItemStack.m_41712_((CompoundTag)tag.m_128469_("meal"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CauldronBlockEntity entity) {
        entity.animTick = entity.animTick == 0 ? level.f_46441_.nextInt(4096) : ++entity.animTick;
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, CauldronBlockEntity entity) {
        if (!entity.hasMeal() && entity.canCookMeal()) {
            ++entity.cookTicks;
            entity.m_6596_();
            if (entity.cookTicks >= entity.cookTicksTotal) {
                RecipeWrapper container = new RecipeWrapper((IItemHandlerModifiable)entity.inventory);
                CauldronRecipe bestRecipe = null;
                for (CauldronRecipe recipe : level.m_7465_().m_44056_(CauldronRecipe.TYPE, (Container)container, level)) {
                    if (bestRecipe != null && recipe.getInput().size() <= bestRecipe.getInput().size()) continue;
                    bestRecipe = recipe;
                }
                entity.m_6211_();
                entity.meal = bestRecipe == null ? new ItemStack((ItemLike)ItemsNF.SUSPICIOUS_STEW.get(), 4) : bestRecipe.assembleItem(container, null);
                entity.needsUpdate = true;
                state = (BlockState)state.m_61124_(CauldronBlockNF.TASK, (Comparable)((Object)Task.DONE));
                level.m_46597_(pos, state);
            }
            if (state.m_61143_(CauldronBlockNF.TASK) == Task.IDLE) {
                level.m_46597_(pos, (BlockState)state.m_61124_(CauldronBlockNF.TASK, (Comparable)((Object)Task.COOK)));
            }
        } else if (state.m_61143_(CauldronBlockNF.TASK) == Task.COOK) {
            level.m_46597_(pos, (BlockState)state.m_61124_(CauldronBlockNF.TASK, (Comparable)((Object)Task.IDLE)));
        }
    }

    public static void idleTick(Level level, BlockPos pos, BlockState state, CauldronBlockEntity entity) {
        if (entity.cookTicks > 0) {
            entity.cookTicks -= 2;
            entity.m_6596_();
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        return super.m_6542_(player) && !this.hasMeal();
    }

    public boolean hasMeal() {
        return !this.meal.m_41619_();
    }

    public ItemStack takeMeal() {
        ItemStack serving = this.meal.m_41620_(1);
        this.needsUpdate = true;
        if (this.meal.m_41619_()) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CauldronBlockNF.TASK, (Comparable)((Object)Task.IDLE)));
        } else {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        return serving;
    }

    public void applyHeat(boolean heated) {
        if (this.hot != heated) {
            this.hot = heated;
            this.needsUpdate = true;
            this.m_6596_();
            Task task = (Task)((Object)this.m_58900_().m_61143_(CauldronBlockNF.TASK));
            if (!heated && task == Task.COOK) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CauldronBlockNF.TASK, (Comparable)((Object)Task.IDLE)));
            } else if (task == Task.IDLE && this.canCookMeal()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CauldronBlockNF.TASK, (Comparable)((Object)Task.COOK)));
            } else {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
        }
    }

    @Override
    public CompoundTag writeDataAndClear() {
        this.hot = false;
        CompoundTag data = this.m_187481_();
        data.m_128405_("state", Block.m_49956_((BlockState)((BlockState)this.m_58900_().m_60734_().m_49966_().m_61124_(CauldronBlockNF.TASK, (Comparable)((Object)(this.meal.m_41619_() ? Task.IDLE : Task.DONE))))));
        this.inventory.clear();
        return data;
    }

    @Override
    public void onDrop(Level level, BlockPos pos) {
        NonNullList<ItemStack> drops = this.getContainerDrops();
        drops.add((Object)new ItemStack((ItemLike)this.m_58900_().m_60734_().m_5456_()));
        if (level != null) {
            Containers.m_19010_((Level)level, (BlockPos)pos, drops);
        }
    }

    @Override
    public boolean useBlockEntityItemRenderer() {
        return true;
    }

    @Override
    public double getThirdPersonYOffset() {
        return -0.1875;
    }
}

