/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.cauldron;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IHeatable;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.cauldron.CauldronBlockEntity;
import frostnox.nightfall.block.block.cauldron.Task;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.item.item.ChangeOnUseFinishItem;
import frostnox.nightfall.item.item.FilledBucketItem;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CauldronBlockNF
extends WaterloggedEntityBlock
implements IHeatable,
ICustomPathfindable {
    private static final VoxelShape SHAPE_Z = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)8.0, (double)7.5, (double)10.0, (double)9.0, (double)8.5), Block.m_49796_((double)13.0, (double)5.0, (double)6.0, (double)14.0, (double)6.0, (double)10.0), Block.m_49796_((double)2.0, (double)5.0, (double)6.0, (double)3.0, (double)6.0, (double)10.0)});
    private static final VoxelShape SHAPE_X = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.5, (double)8.0, (double)6.0, (double)8.5, (double)9.0, (double)10.0), Block.m_49796_((double)6.0, (double)5.0, (double)13.0, (double)10.0, (double)6.0, (double)14.0), Block.m_49796_((double)6.0, (double)5.0, (double)2.0, (double)10.0, (double)6.0, (double)3.0)});
    private static final VoxelShape SHAPE_Z_OPEN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)5.0, (double)6.0, (double)14.0, (double)6.0, (double)10.0), Block.m_49796_((double)2.0, (double)5.0, (double)6.0, (double)3.0, (double)6.0, (double)10.0)});
    private static final VoxelShape SHAPE_X_OPEN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)5.0, (double)13.0, (double)10.0, (double)6.0, (double)14.0), Block.m_49796_((double)6.0, (double)5.0, (double)2.0, (double)10.0, (double)6.0, (double)3.0)});
    private static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape COLLISION_SHAPE_OPEN = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
    protected static final List<AABB> AABB = List.of((AABB)COLLISION_SHAPE.m_83299_().get(0));
    protected static final List<AABB> AABB_OPEN = List.of((AABB)COLLISION_SHAPE_OPEN.m_83299_().get(0));
    public static final EnumProperty<Task> TASK = EnumProperty.m_61587_((String)"task", Task.class);
    public static final BooleanProperty SUPPORT = BlockStatePropertiesNF.SUPPORT;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public CauldronBlockNF(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TASK, (Comparable)((Object)Task.IDLE))).m_61124_((Property)SUPPORT, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Z));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CauldronBlockEntity) {
            CauldronBlockEntity cauldron = (CauldronBlockEntity)blockEntity;
            if (cauldron.hasMeal()) {
                Item item = cauldron.meal.m_41720_();
                if (item instanceof ChangeOnUseFinishItem) {
                    ChangeOnUseFinishItem item2 = (ChangeOnUseFinishItem)item;
                    ItemStack useItem = player.m_21120_(hand);
                    if (useItem.m_150930_(item2.changeItem.get())) {
                        if (!player.m_150110_().f_35937_) {
                            useItem.m_41774_(1);
                        }
                        LevelUtil.giveItemToPlayer(cauldron.takeMeal(), player, true);
                    } else if (player.m_36391_(false)) {
                        player.m_5584_(level, cauldron.takeMeal());
                    }
                } else {
                    LevelUtil.giveItemToPlayer(cauldron.takeMeal(), player, true);
                }
            } else {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack item = player.m_21120_(hand);
                Item item3 = item.m_41720_();
                if (item3 instanceof FilledBucketItem) {
                    FilledBucketItem bucket = (FilledBucketItem)item3;
                    cauldron.m_6555_(serverPlayer.f_8940_, player.m_150109_()).m_7648_(player, 27 + player.m_150109_().f_35977_);
                    if (item.m_41619_()) {
                        bucket.playEmptySound(null, (LevelAccessor)level, pos);
                    }
                } else {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)cauldron, (BlockPos)pos);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(pNewState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof Container) {
            Container container = (Container)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
        }
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity;
        if (pStack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
            container.m_58638_(pStack.m_41786_());
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return this.addLiquidToPlacement((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122434_())).m_61124_((Property)SUPPORT, (Comparable)Boolean.valueOf(pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_()).m_60713_((Block)BlocksNF.CAMPFIRE.get()))), pContext);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        state = super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
        if (facing == Direction.DOWN) {
            state = (BlockState)state.m_61124_((Property)SUPPORT, (Comparable)Boolean.valueOf(facingState.m_60713_((Block)BlocksNF.CAMPFIRE.get())));
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        if (!state.m_61138_(TASK)) {
            return state.m_61143_(AXIS) == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
        }
        return state.m_61143_(AXIS) == Direction.Axis.X ? (state.m_61143_(TASK) == Task.IDLE ? SHAPE_X : SHAPE_X_OPEN) : (state.m_61143_(TASK) == Task.IDLE ? SHAPE_Z : SHAPE_Z_OPEN);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        if (!state.m_61138_(TASK)) {
            return COLLISION_SHAPE;
        }
        return state.m_61143_(TASK) == Task.DONE ? COLLISION_SHAPE_OPEN : COLLISION_SHAPE;
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random pRand) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CauldronBlockEntity) {
            CauldronBlockEntity cauldron = (CauldronBlockEntity)blockEntity;
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            if (cauldron.hot && pRand.nextInt(6) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.5, (double)y + 0.4375, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockState m_6843_(BlockState state, Rotation pRot) {
        return switch (pRot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{TASK, SUPPORT, AXIS});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> pBlockEntityType) {
        if (level.f_46443_) {
            return CauldronBlockNF.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntitiesNF.CAULDRON.get(), CauldronBlockEntity::clientTick);
        }
        return switch ((Task)((Object)state.m_61143_(TASK))) {
            default -> throw new IncompatibleClassChangeError();
            case Task.IDLE -> CauldronBlockNF.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntitiesNF.CAULDRON.get(), CauldronBlockEntity::idleTick);
            case Task.COOK -> CauldronBlockNF.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntitiesNF.CAULDRON.get(), CauldronBlockEntity::cookTick);
            case Task.DONE -> null;
        };
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluid) {
        if (super.m_7361_(level, pos, state, fluid)) {
            BlockEntity blockEntity;
            if (level.m_5776_()) {
                return true;
            }
            if (state.m_61143_(TASK) == Task.COOK) {
                level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_(TASK, (Comparable)((Object)Task.IDLE)), 3);
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof CauldronBlockEntity) {
                CauldronBlockEntity cauldron = (CauldronBlockEntity)blockEntity;
                if (cauldron.hot) {
                    cauldron.hot = false;
                    cauldron.m_6596_();
                    level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.375f, 2.6f + (level.m_5822_().nextFloat() - level.m_5822_().nextFloat()) * 0.8f);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, 8, 0.25, 0.25, 0.25, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CauldronBlockEntity(pos, state);
    }

    @Override
    public void applyHeat(Level level, BlockPos pos, BlockState state, TieredHeat heat, Direction fromDir) {
        BlockEntity blockEntity;
        if (fromDir == Direction.DOWN && (blockEntity = level.m_7702_(pos)) instanceof CauldronBlockEntity) {
            CauldronBlockEntity cauldron = (CauldronBlockEntity)blockEntity;
            cauldron.applyHeat(heat != TieredHeat.NONE);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return this.getTypeForCenteredBottomShape(nodeManager, pos, state.m_61138_(TASK) ? (state.m_61143_(TASK) == Task.IDLE ? 0.5f : 0.4375f) : 0.5f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.OPEN;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return state.m_61138_(TASK) ? (state.m_61143_(TASK) == Task.IDLE ? AABB : AABB_OPEN) : AABB;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return state.m_61138_(TASK) ? (state.m_61143_(TASK) == Task.IDLE ? AABB : AABB_OPEN) : AABB;
    }
}

