/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.crucible;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IHeatable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.crucible.CrucibleBlockEntity;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.item.item.FilledBucketItem;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.MathUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CrucibleBlock
extends WaterloggedEntityBlock
implements ICustomPathfindable,
IHeatable {
    public static final IntegerProperty HEAT = BlockStatePropertiesNF.HEAT_FULL;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private static final VoxelShape SHAPE_Z = Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)CrucibleBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)CrucibleBlock.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)CrucibleBlock.m_49796_((double)2.0, (double)5.0, (double)6.0, (double)14.0, (double)6.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_X = MathUtil.rotate(SHAPE_Z, Rotation.CLOCKWISE_90);
    protected static final List<AABB> AABB_TOP_Z = SHAPE_Z.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> AABB_TOP_X = SHAPE_X.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> AABB_BOTTOM_Z = SHAPE_Z.m_83263_(Direction.DOWN).m_83299_();
    protected static final List<AABB> AABB_BOTTOM_X = SHAPE_X.m_83263_(Direction.DOWN).m_83299_();
    public final int fluidCapacity;
    public final float maxTemp;

    public CrucibleBlock(int fluidCapacity, float maxTemp, BlockBehaviour.Properties properties) {
        super(properties);
        this.fluidCapacity = fluidCapacity;
        this.maxTemp = maxTemp;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH))).m_61124_((Property)HEAT, (Comparable)Integer.valueOf(0))).m_61124_(AXIS, (Comparable)Direction.Axis.Z));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)new TranslatableComponent("block.capacity", new Object[]{this.fluidCapacity}).m_130940_(ChatFormatting.DARK_GREEN));
        pTooltip.add((Component)new TranslatableComponent("block.crucible.pour"));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? SHAPE_Z : SHAPE_X;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEAT, AXIS});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.addLiquidToPlacement((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_8125_().m_122434_()), context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_6047_() && player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity blockEntity2 = (CrucibleBlockEntity)blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack item = player.m_21120_(hand);
            Item item2 = item.m_41720_();
            if (item2 instanceof FilledBucketItem) {
                FilledBucketItem bucket = (FilledBucketItem)item2;
                blockEntity2.m_6555_(serverPlayer.f_8940_, player.m_150109_()).m_7648_(player, 27 + player.m_150109_().f_35977_);
                if (item.m_41619_()) {
                    bucket.playEmptySound(null, (LevelAccessor)level, pos);
                }
            } else {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity2, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_48717_) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity entity = (CrucibleBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, entity.getContainerDrops());
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, p_48717_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.CRUCIBLE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entity) {
        if (level.m_5776_()) {
            return null;
        }
        return CrucibleBlock.createTickerHelper(entity, (BlockEntityType)BlockEntitiesNF.CRUCIBLE.get(), CrucibleBlockEntity::serverTick);
    }

    public BlockState m_6843_(BlockState state, Rotation pRot) {
        return switch (pRot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return this.getTypeForCenteredBottomShape(nodeManager, pos, 0.625f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.OPEN;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? AABB_TOP_Z : AABB_TOP_X;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? AABB_BOTTOM_Z : AABB_BOTTOM_X;
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public void applyHeat(Level level, BlockPos pos, BlockState state, TieredHeat heat, Direction fromDir) {
        BlockEntity blockEntity;
        if (fromDir == Direction.DOWN && (blockEntity = level.m_7702_(pos)) instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
            crucible.targetTemperature = Math.min(heat.getBaseTemp(), this.maxTemp);
        }
    }
}

