/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.crucible;

import frostnox.nightfall.block.IHoldable;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.MenuContainerBlockEntity;
import frostnox.nightfall.block.block.crucible.CrucibleBlock;
import frostnox.nightfall.block.block.crucible.CrucibleContainer;
import frostnox.nightfall.block.block.mold.ItemMoldBlockEntity;
import frostnox.nightfall.block.fluid.MetalFluid;
import frostnox.nightfall.data.recipe.CrucibleRecipe;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CrucibleBlockEntity
extends MenuContainerBlockEntity
implements MenuProvider,
IHoldable {
    public static final int ITEM_CAPACITY = 4;
    protected final ItemStackHandlerNF inventory;
    public final List<FluidStack> fluids = new ObjectArrayList(4);
    protected final List<ResourceLocation> recipeLocations = new ObjectArrayList((Object[])new ResourceLocation[4]);
    public final IntList cookTicks = new IntArrayList(new int[4]);
    public final IntList cookDurations = new IntArrayList(IntStream.generate(() -> 1).limit(4L).toArray());
    protected float temperature;
    protected float targetTemperature;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return pIndex < 4 ? CrucibleBlockEntity.this.cookTicks.getInt(pIndex) : CrucibleBlockEntity.this.cookDurations.getInt(pIndex - 4);
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex < 4) {
                CrucibleBlockEntity.this.cookTicks.set(pIndex, pValue);
            } else {
                CrucibleBlockEntity.this.cookDurations.set(pIndex - 4, pValue);
            }
        }

        public int m_6499_() {
            return 8;
        }
    };

    public CrucibleBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesNF.CRUCIBLE.get(), pos, state);
    }

    protected CrucibleBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.inventory = new ItemStackHandlerNF(4){

            protected void onContentsChanged(int slot) {
                if (CrucibleBlockEntity.this.f_58857_ == null || CrucibleBlockEntity.this.f_58857_.m_5776_()) {
                    return;
                }
                CrucibleBlockEntity.this.m_6596_();
                ItemStack item = CrucibleBlockEntity.this.inventory.getStackInSlot(slot);
                Optional newRecipe = CrucibleBlockEntity.this.f_58857_.m_7465_().m_44015_(CrucibleRecipe.TYPE, (Container)new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandlerNF(item)), CrucibleBlockEntity.this.f_58857_);
                CrucibleBlockEntity.this.recipeLocations.set(slot, newRecipe.isPresent() ? ((CrucibleRecipe)newRecipe.get()).m_6423_() : null);
                CrucibleBlockEntity.this.cookTicks.set(slot, 0);
                CrucibleBlockEntity.this.cookDurations.set(slot, newRecipe.isPresent() ? ((CrucibleRecipe)newRecipe.get()).getCookTime() * item.m_41613_() : 1);
            }
        };
    }

    protected Component m_6820_() {
        return new TranslatableComponent("nightfall.crucible");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new CrucibleContainer(pContainerId, pInventory, this);
    }

    public void m_5856_(Player pPlayer) {
        this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.625, (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)SoundsNF.CERAMIC_OPEN_SMALL.get(), SoundSource.BLOCKS, 1.0f, 0.94f + this.f_58857_.f_46441_.nextFloat() * 0.12f);
        this.f_58857_.m_142346_((Entity)pPlayer, GameEvent.f_157803_, this.f_58858_);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        DataUtil.loadSlottedData(tag.m_128437_("recipes", 10), this.recipeLocations, t -> ResourceLocation.parse((String)t.m_128461_("recipe")));
        this.fluids.clear();
        DataUtil.loadFluids(this.fluids, tag);
        DataUtil.loadSlottedData(tag.m_128437_("cookTicks", 10), this.cookTicks, t -> t.m_128451_("ticks"));
        DataUtil.loadSlottedData(tag.m_128437_("cookDurations", 10), this.cookDurations, t -> t.m_128451_("duration"));
        this.temperature = tag.m_128457_("temperature");
        this.targetTemperature = tag.m_128457_("targetTemperature");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("recipes", (Tag)DataUtil.writeSlottedData(this.recipeLocations, (t, r) -> t.m_128359_("recipe", r.toString())));
        DataUtil.writeFluids(this.fluids, tag);
        tag.m_128365_("cookTicks", (Tag)DataUtil.writeSlottedData(this.cookTicks, (t, i) -> t.m_128405_("ticks", i.intValue()), i -> i == 0));
        tag.m_128365_("cookDurations", (Tag)DataUtil.writeSlottedData(this.cookDurations, (t, i) -> t.m_128405_("duration", i.intValue()), i -> i == 1));
        tag.m_128350_("temperature", this.temperature);
        tag.m_128350_("targetTemperature", this.targetTemperature);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        if (!this.fluids.isEmpty()) {
            DataUtil.writeFluids(this.fluids, tag);
        }
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.fluids.clear();
        DataUtil.loadFluids(this.fluids, tag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity entity) {
        boolean changed = false;
        float targetTemp = entity.targetTemperature;
        if (level.m_46758_(pos.m_7494_())) {
            targetTemp -= 200.0f;
        }
        if (entity.temperature < targetTemp) {
            entity.temperature = Math.min(entity.temperature + 2.0f, targetTemp);
            heat = TieredHeat.fromTemp(entity.temperature);
            if (((Integer)state.m_61143_((Property)CrucibleBlock.HEAT)).intValue() != heat.getTier()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CrucibleBlock.HEAT, (Comparable)Integer.valueOf(heat.getTier())), 2);
            }
            changed = true;
        } else if (entity.temperature > targetTemp) {
            entity.temperature = Math.max(entity.temperature - 1.0f, targetTemp);
            heat = TieredHeat.fromTemp(entity.temperature);
            if (((Integer)state.m_61143_((Property)CrucibleBlock.HEAT)).intValue() != heat.getTier()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CrucibleBlock.HEAT, (Comparable)Integer.valueOf(heat.getTier())), 2);
            }
            changed = true;
        }
        for (int i = 0; i < 4; ++i) {
            int cookTicks;
            ResourceLocation recipeLocation = entity.recipeLocations.get(i);
            if (recipeLocation == null) continue;
            CrucibleRecipe recipe = (CrucibleRecipe)level.m_7465_().m_44043_(recipeLocation).orElseThrow();
            if (entity.temperature >= recipe.getTemperature()) {
                RecipeWrapper inventory;
                FluidStack fluid;
                cookTicks = entity.cookTicks.getInt(i) + 1;
                entity.cookTicks.set(i, cookTicks);
                changed = true;
                if (cookTicks < entity.cookDurations.getInt(i) || !(fluid = recipe.assembleFluid(inventory = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandlerNF(entity.inventory.getStackInSlot(i))))).isEmpty() && entity.getFluidUnits() == entity.getFluidCapacity(entity.m_58900_())) continue;
                entity.addFluid(fluid, Integer.MAX_VALUE);
                entity.m_6836_(i, recipe.assemble(inventory));
                entity.tryAlloying();
                level.m_7260_(entity.m_58899_(), entity.m_58900_(), entity.m_58900_(), 20);
                continue;
            }
            cookTicks = entity.cookTicks.getInt(i);
            if (cookTicks <= 0) continue;
            entity.cookTicks.set(i, cookTicks - 1);
            changed = true;
        }
        if (changed) {
            entity.m_6596_();
        }
    }

    public int getFluidUnits() {
        int amount = 0;
        for (FluidStack fluid : this.fluids) {
            amount += fluid.getAmount();
        }
        return amount;
    }

    public boolean addFluid(FluidStack newFluid, int maxAmount) {
        int units = this.getFluidUnits();
        int amount = Math.min(maxAmount, Math.min(this.getFluidCapacity(this.m_58900_()) - units, newFluid.getAmount()));
        if (amount > 0) {
            for (FluidStack fluid : this.fluids) {
                if (!fluid.isFluidEqual(newFluid)) continue;
                fluid.grow(amount);
                newFluid.shrink(amount);
                return true;
            }
            this.fluids.add(new FluidStack(newFluid.getFluid(), amount));
            newFluid.shrink(amount);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void removeEmptyFluids() {
        this.fluids.removeIf(FluidStack::isEmpty);
        this.m_6596_();
    }

    public void tryAlloying() {
        for (Fluid fluid : ForgeRegistries.FLUIDS) {
            if (!(fluid instanceof MetalFluid)) continue;
            MetalFluid metalFluid = (MetalFluid)fluid;
            if (!metalFluid.metal.canCreateFromFluids(this.fluids, this.temperature)) continue;
            int units = this.getFluidUnits();
            this.fluids.clear();
            this.fluids.add(new FluidStack(fluid, units));
            this.m_6596_();
        }
    }

    public FluidStack getRecentMetalFluid() {
        for (int i = this.fluids.size() - 1; i >= 0; --i) {
            FluidStack fluid = this.fluids.get(i);
            if (!(fluid.getFluid() instanceof MetalFluid)) continue;
            return fluid;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public ItemStackHandlerNF getInventory() {
        return this.inventory;
    }

    public int getFluidCapacity(BlockState state) {
        return ((CrucibleBlock)state.m_60734_()).fluidCapacity;
    }

    public void emptyInventory() {
        for (int i = 0; i < 4; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Override
    public NonNullList<ItemStack> getContainerDrops() {
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < 4; ++i) {
            list.add((Object)this.inventory.getStackInSlot(i));
        }
        return list;
    }

    @Override
    public CompoundTag writeDataAndClear() {
        this.targetTemperature = 0.0f;
        CompoundTag data = this.m_187481_();
        data.m_128405_("state", Block.m_49956_((BlockState)((BlockState)this.m_58900_().m_61124_(CrucibleBlock.AXIS, (Comparable)Direction.Axis.Z))));
        this.emptyInventory();
        return data;
    }

    @Override
    public void onDrop(Level level, BlockPos pos) {
        NonNullList<ItemStack> drops = this.getContainerDrops();
        drops.add((Object)new ItemStack((ItemLike)this.m_58900_().m_60734_().m_5456_()));
        if (level != null) {
            Containers.m_19010_((Level)level, (BlockPos)pos, drops);
        }
    }

    @Override
    public boolean heldUse(BlockPos usePos, Player player) {
        FluidStack fluid = this.getRecentMetalFluid();
        Fluid fluid2 = fluid.getFluid();
        if (fluid2 instanceof MetalFluid) {
            MetalFluid metalFluid = (MetalFluid)fluid2;
            if (this.temperature >= metalFluid.metal.getMeltTemp()) {
                CrucibleBlockEntity crucible;
                BlockEntity blockEntity = player.f_19853_.m_7702_(usePos);
                boolean poured = false;
                if (blockEntity instanceof ItemMoldBlockEntity) {
                    ItemMoldBlockEntity mold = (ItemMoldBlockEntity)blockEntity;
                    if (mold.addFluid(fluid, metalFluid.metal.getMeltTemp())) {
                        poured = true;
                    }
                } else if (blockEntity instanceof CrucibleBlockEntity && (crucible = (CrucibleBlockEntity)blockEntity).addFluid(fluid, 10)) {
                    poured = true;
                    player.f_19853_.m_7260_(crucible.m_58899_(), crucible.m_58900_(), crucible.m_58900_(), 20);
                }
                if (poured) {
                    this.removeEmptyFluids();
                    this.tryAlloying();
                    player.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)SoundsNF.CRUCIBLE_POUR.get(), SoundSource.PLAYERS, 0.75f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public double getFirstPersonYOffset() {
        return 0.125;
    }

    @Override
    public double getThirdPersonYOffset() {
        return -0.1875;
    }
}

