/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.eggnest;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IFoodBlock;
import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.eggnest.EggNestBlockEntity;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public abstract class EggNestBlock
extends BaseEntityBlock
implements ITimeSimulatedBlock,
IFoodBlock {
    public static final IntegerProperty EGGS = BlockStatePropertiesNF.EGGS;
    public final Supplier<? extends Item> eggItem;
    public final int hatchDuration;
    public final float minTemp;
    public final float maxTemp;

    public EggNestBlock(Supplier<? extends Item> eggItem, int hatchDuration, float minTemp, float maxTemp, BlockBehaviour.Properties properties) {
        super(properties);
        this.hatchDuration = hatchDuration;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.eggItem = eggItem;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EGGS, (Comparable)Integer.valueOf(0)));
    }

    protected abstract LivingEntity hatchBaby(ServerLevel var1, BlockPos var2, int var3);

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntitiesNF.EGG_NEST.get()).m_155264_(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int eggs = (Integer)state.m_61143_((Property)EGGS);
        if (eggs == 0 || pPlayer.m_36341_() || pPlayer.m_21120_(pHand).m_150930_(Items.f_42751_)) {
            return InteractionResult.PASS;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(eggs - 1)), 2);
        if (!level.f_46443_) {
            LevelUtil.giveItemToPlayer(new ItemStack((ItemLike)this.eggItem.get()), pPlayer, true);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof EggNestBlockEntity) {
                EggNestBlockEntity nest = (EggNestBlockEntity)blockEntity;
                int bestTime = 0;
                int bestIndex = 0;
                for (int i = 0; i < nest.hatchTimes.length; ++i) {
                    if (nest.hatchTimes[i] < 0) {
                        nest.hatchTimes[i] = 0;
                        return InteractionResult.CONSUME;
                    }
                    if (nest.hatchTimes[i] <= 0 || nest.hatchTimes[i] <= bestTime) continue;
                    bestTime = nest.hatchTimes[i];
                    bestIndex = i;
                }
                nest.hatchTimes[bestIndex] = 0;
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)EGGS) > 0;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EggNestBlockEntity) {
            EggNestBlockEntity nest = (EggNestBlockEntity)blockEntity;
            int passedTicks = (int)(level.m_46467_() - nest.lastProcessedTick);
            int eggs = (Integer)state.m_61143_((Property)EGGS);
            if (LevelData.isPresent((Level)level)) {
                IChunkData chunkData;
                ILevelData levelData = LevelData.get((Level)level);
                float temp = levelData.getSeasonalTemperature(chunkData = ChunkData.get(level.m_46745_(pos)), pos);
                if (temp >= this.minTemp && temp <= this.maxTemp) {
                    for (int i = 0; i < nest.hatchTimes.length; ++i) {
                        if (nest.hatchTimes[i] <= 0) continue;
                        int n = i;
                        nest.hatchTimes[n] = nest.hatchTimes[n] - passedTicks;
                        if (nest.hatchTimes[i] > 0) continue;
                        nest.hatchTimes[i] = 0;
                        --eggs;
                        this.hatchBaby(level, pos, nest.eggData[i]);
                    }
                } else {
                    for (int i = 0; i < nest.hatchTimes.length; ++i) {
                        if (nest.hatchTimes[i] <= 0) continue;
                        nest.hatchTimes[i] = -1;
                    }
                }
            } else {
                for (int i = 0; i < nest.hatchTimes.length; ++i) {
                    if (nest.hatchTimes[i] <= 0) continue;
                    int n = i;
                    nest.hatchTimes[n] = nest.hatchTimes[n] - passedTicks;
                    if (nest.hatchTimes[i] > 0) continue;
                    nest.hatchTimes[i] = 0;
                    --eggs;
                    this.hatchBaby(level, pos, nest.eggData[i]);
                }
            }
            nest.lastProcessedTick = level.m_46467_();
            if (eggs != (Integer)state.m_61143_((Property)EGGS)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(eggs)), 3);
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!(state = super.m_7417_(state, facing, facingState, level, pos, facingPos)).m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Block.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{EGGS});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    @Override
    public boolean isEatable(BlockState state, Diet diet) {
        return (Integer)state.m_61143_((Property)EGGS) > 0 && diet != Diet.HERBIVORE;
    }

    @Override
    public void eat(Entity eater, Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)EGGS) - 1)), 2);
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EggNestBlockEntity) {
            EggNestBlockEntity eggNestBlockEntity = (EggNestBlockEntity)blockEntity;
        }
    }
}

