/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.fireable;

import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.block.IAdjustableNodeType;
import frostnox.nightfall.block.IIgnitable;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.fireable.FireableBlockEntity;
import frostnox.nightfall.block.block.fireable.IFireableBlockEntity;
import frostnox.nightfall.block.block.fuel.BurningFuelBlockEntity;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public abstract class FireableBlock
extends BaseEntityBlock
implements IAdjustableNodeType {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.95, (double)16.0);
    public final int cookTicks;
    public final TieredHeat cookHeat;

    public FireableBlock(int cookTicks, TieredHeat cookHeat, BlockBehaviour.Properties properties) {
        super(properties);
        this.cookTicks = cookTicks;
        this.cookHeat = cookHeat;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public abstract BlockState getFiredBlock(Level var1, BlockPos var2, BlockState var3);

    public abstract boolean isStructureValid(Level var1, BlockPos var2, BlockState var3);

    /*
     * Unable to fully structure code
     */
    public static void serverEntityTick(Level level, BlockPos pos, BlockState state, IFireableBlockEntity entity) {
        block11: {
            fireable = (FireableBlock)state.m_60734_();
            updated = false;
            if (!((Boolean)state.m_61143_((Property)FireableBlock.LIT)).booleanValue() && level.m_46467_() % 67L == 0L) {
                entity.setInStructure(fireable.isStructureValid(level, pos, state));
                if (entity.inStructure() && (var7_6 = level.m_7702_(pos.m_7495_())) instanceof BurningFuelBlockEntity) {
                    fuel = (BurningFuelBlockEntity)var7_6;
                    if (fuel.temperature >= fireable.cookHeat.getBaseTemp()) {
                        updated = true;
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)FireableBlock.LIT, (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
            if (!updated && entity.getCookTicks() <= 0) break block11;
            if (!updated && level.m_46467_() % 67L == 0L) {
                entity.setInStructure(fireable.isStructureValid(level, pos, state));
                if (((Boolean)state.m_61143_((Property)FireableBlock.LIT)).booleanValue() && !entity.inStructure()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)FireableBlock.LIT, (Comparable)Boolean.valueOf(false)));
                }
            }
            if (updated) ** GOTO lbl-1000
            if (entity.inStructure() && (var7_6 = level.m_7702_(pos.m_7495_())) instanceof BurningFuelBlockEntity) {
                fuel = (BurningFuelBlockEntity)var7_6;
                ** if (!(fuel.temperature >= fireable.cookHeat.getBaseTemp())) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                entity.setCookTicks(entity.getCookTicks() + 1);
                ((BlockEntity)entity).m_6596_();
                ** GOTO lbl31
            }
lbl-1000:
            // 2 sources

            {
                if (entity.getCookTicks() > 0) {
                    entity.setCookTicks(Math.max(0, entity.getCookTicks() - 30));
                    ((BlockEntity)entity).m_6596_();
                    if (entity.getCookTicks() == 0) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)FireableBlock.LIT, (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
lbl31:
            // 6 sources

            if (entity.getCookTicks() >= fireable.cookTicks) {
                level.m_46597_(pos, fireable.getFiredBlock(level, pos, state));
            }
        }
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)new TranslatableComponent("block.fireable").m_7220_((Component)new TranslatableComponent("heat.tier." + this.cookHeat.getTier()).m_130948_(Style.f_131099_.m_178520_(this.cookHeat.color.getRGB()))));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter pReader, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity pEntity) {
        if (!pEntity.m_5825_() && pEntity.f_19802_ <= 10 && this.isIgnited(state) && pEntity instanceof LivingEntity) {
            pEntity.m_6469_((DamageSource)DamageTypeSource.HOT_FLOOR, 1.0f);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_186464_(pos, (Block)this, 4 + level.m_5822_().nextInt(9), TickPriority.HIGH);
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_186464_(pos, (Block)this, 4 + level.m_5822_().nextInt(9), TickPriority.HIGH);
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockPos spreadPos;
        BlockState spreadState;
        Block block;
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && (block = (spreadState = level.m_8055_(spreadPos = pos.m_7494_())).m_60734_()) instanceof IIgnitable) {
            IIgnitable ignitable = (IIgnitable)block;
            ignitable.tryToIgnite((Level)level, spreadPos, spreadState, ItemStack.f_41583_, TieredHeat.RED);
        }
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            AABB box = state.m_60808_((BlockGetter)level, pos).m_83215_();
            double xSize = box.f_82291_ - box.f_82288_;
            double zSize = box.f_82293_ - box.f_82290_;
            double size = box.m_82309_();
            double xSizeHalf = xSize / 2.0;
            double zSizeHalf = zSize / 2.0;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + box.f_82289_;
            double z = (double)pos.m_123343_() + 0.5;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (!(rand.nextDouble() < 0.85 * size)) continue;
                double xPos = x + (dir.m_122429_() == 0 ? -xSizeHalf + rand.nextDouble() * xSize : xSizeHalf * (double)dir.m_122429_());
                double yPos = y + rand.nextDouble() * box.f_82292_;
                double zPos = z + (dir.m_122431_() == 0 ? -zSizeHalf + rand.nextDouble() * zSize : zSizeHalf * (double)dir.m_122431_());
                VoxelShape shape = level.m_8055_(pos.m_142300_(dir)).m_60812_((BlockGetter)level, pos.m_142300_(dir));
                if (!shape.m_83281_() && shape.m_83215_().m_82338_(pos.m_142300_(dir)).m_82393_(xPos, yPos, zPos)) continue;
                level.m_7106_((ParticleOptions)this.cookHeat.getFlameParticle().get(), xPos, yPos, zPos, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, xPos, yPos, zPos, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(state, level, pos, pBlock, pFromPos, pIsMoving);
        if (pFromPos.m_123342_() >= pos.m_123342_() && this.isIgnited(state) && level.m_6425_(pFromPos).m_205070_(FluidTags.f_13131_)) {
            this.tryToExtinguish(state, pos, level, ItemStack.f_41583_);
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FireableBlockEntity) {
                FireableBlockEntity fireable = (FireableBlockEntity)blockEntity;
                fireable.inStructure = this.isStructureValid(level, pos, state);
            }
        }
    }

    public boolean tryToExtinguish(BlockState state, BlockPos pos, Level level, ItemStack stack) {
        if (level.m_5776_() || !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IFireableBlockEntity) {
            IFireableBlockEntity fireable = (IFireableBlockEntity)blockEntity;
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
            fireable.setCookTicks(0);
            ((BlockEntity)fireable).m_6596_();
        }
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.35f, 2.6f + (level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.8f);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, 6, 0.25, 0.25, 0.25, 0.0);
        return true;
    }

    public boolean isIgnited(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.FIREABLE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.m_5776_() ? null : FireableBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntitiesNF.FIREABLE.get()), FireableBlock::serverEntityTick);
    }

    @Override
    public NodeType adjustNodeType(NodeType type, BlockState state, LivingEntity entity) {
        return !this.isIgnited(state) || entity.m_5825_() ? type : (type.walkable ? NodeType.PASSABLE_DANGER_MINOR : NodeType.IMPASSABLE_DANGER_MINOR);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LevelUtil.pickCloneItem(state.m_60734_(), player);
    }
}

