/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.fireable;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.fireable.FireableBlock;
import frostnox.nightfall.block.block.fireable.SimpleFireableBlock;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class FireablePartialBlock
extends SimpleFireableBlock
implements IWaterloggedBlock,
ICustomPathfindable {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    public final int excludedWaterLevel;

    public FireablePartialBlock(int cookTicks, TieredHeat cookHeat, RegistryObject<? extends Block> firedBlock, int excludedWaterLevel, BlockBehaviour.Properties properties) {
        super(cookTicks, cookHeat, firedBlock, properties);
        this.excludedWaterLevel = excludedWaterLevel;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.FRESH)));
    }

    @Override
    public boolean isStructureValid(Level level, BlockPos pos, BlockState state) {
        if (this.cookHeat.getTier() <= 1) {
            return true;
        }
        return LevelUtil.getNearbyKilnTier(level, pos) >= this.cookHeat.getTier() - 1;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return ((Block)this.firedBlock.get()).m_5940_(state, blockGetter, pos, collisionContext);
    }

    @Override
    public VoxelShape m_7947_(BlockState state, BlockGetter pReader, BlockPos pos) {
        return this.m_5939_(state, pReader, pos, CollisionContext.m_82749_());
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.f_60443_ ? ((Block)this.firedBlock.get()).m_5939_(state, level, pos, context) : Shapes.m_83040_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATER_LEVEL, WATERLOG_TYPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (fluidstate.m_76152_() == FluidsNF.WATER.get()) {
            return (BlockState)blockstate.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(7));
        }
        if (fluidstate.m_76152_() == FluidsNF.WATER_FLOWING.get() && fluidstate.m_76186_() > this.getExcludedWaterLevel(blockstate)) {
            return (BlockState)blockstate.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(fluidstate.m_76186_()));
        }
        return blockstate;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        this.tickLiquid(state, pos, level);
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return this.excludedWaterLevel;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.FIREABLE_POTTERY.get()).m_155264_(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.m_5776_() ? null : FireablePartialBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntitiesNF.FIREABLE_POTTERY.get()), FireableBlock::serverEntityTick);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return ((Block)this.firedBlock.get()).m_7357_(state, level, pos, pType);
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        Object object = this.firedBlock.get();
        if (object instanceof ICustomPathfindable) {
            ICustomPathfindable pathfindable = (ICustomPathfindable)object;
            return pathfindable.getRawNodeType(nodeManager, state, level, pos);
        }
        return NodeType.CLOSED;
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        Object object = this.firedBlock.get();
        if (object instanceof ICustomPathfindable) {
            ICustomPathfindable pathfindable = (ICustomPathfindable)object;
            return pathfindable.getFloorNodeType(nodeManager, state, level, pos);
        }
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        Object object = this.firedBlock.get();
        if (object instanceof ICustomPathfindable) {
            ICustomPathfindable pathfindable = (ICustomPathfindable)object;
            return pathfindable.getTopFaceShape(state);
        }
        return FULL_BOXES;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        Object object = this.firedBlock.get();
        if (object instanceof ICustomPathfindable) {
            ICustomPathfindable pathfindable = (ICustomPathfindable)object;
            return pathfindable.getBottomFaceShape(state);
        }
        return FULL_BOXES;
    }
}

