/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.fuel;

import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IAdjustableNodeType;
import frostnox.nightfall.block.IHeatSource;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.UnstableBlock;
import frostnox.nightfall.block.block.fuel.BurningFuelBlockEntity;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class BurningFuelBlock
extends BaseEntityBlock
implements IHeatSource,
IAdjustableNodeType {
    public static final IntegerProperty HEAT = BlockStatePropertiesNF.HEAT;
    @Nullable
    public final BiFunction<Level, BlockPos, Block> cookChecker;
    public final int burnTicks;
    public final float burnTemp;
    public final Lazy<BlockState> baseFuel;

    public BurningFuelBlock(int burnTicks, float burnTemp, @Nullable BiFunction<Level, BlockPos, Block> cookChecker, Supplier<? extends Block> baseFuel, BlockBehaviour.Properties properties) {
        super(properties);
        this.burnTicks = burnTicks;
        this.burnTemp = burnTemp;
        this.cookChecker = cookChecker;
        this.baseFuel = Lazy.of(() -> ((Block)baseFuel.get()).m_49966_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HEAT, (Comparable)Integer.valueOf(1)));
    }

    public BurningFuelBlock(int burnTicks, float burnTemp, Supplier<? extends Block> baseFuel, BlockBehaviour.Properties properties) {
        this(burnTicks, burnTemp, null, baseFuel, properties);
    }

    public float getTargetTemperature(Level level, BlockState state, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BurningFuelBlockEntity)) {
            return 0.0f;
        }
        BurningFuelBlockEntity fuel = (BurningFuelBlockEntity)blockEntity;
        return this.burnTemp + fuel.structureTempBonus + BurningFuelBlock.getRainTempPenalty(level, pos);
    }

    protected BlockState createBurningState(BlockState originalState) {
        return (BlockState)this.m_49966_().m_61124_((Property)HEAT, (Comparable)Integer.valueOf(TieredHeat.fromTemp(this.burnTemp).getTier()));
    }

    protected void createAt(BlockState originalState, BlockPos pos, Level level) {
        level.m_46597_(pos, this.createBurningState(originalState));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BurningFuelBlockEntity) {
            BurningFuelBlockEntity fuel = (BurningFuelBlockEntity)blockEntity;
            if (fuel.burnTicks != -1) {
                fuel.temperature = this.burnTemp;
                fuel.m_6596_();
            }
        }
    }

    public static float getRainTempPenalty(Level level, BlockPos pos) {
        return level.m_46758_(pos.m_7494_()) ? -200.0f : 0.0f;
    }

    public boolean increaseHeat(Level level, BlockState state, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)HEAT) == 5 || LevelUtil.isTouchingWater(level, pos)) {
            return false;
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)HEAT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)HEAT) + 1)));
        this.scheduleHeatTick((LevelAccessor)level, pos, (Block)this);
        return true;
    }

    public boolean decreaseHeat(Level level, BlockState state, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)HEAT) == 1) {
            level.m_46597_(pos, ((UnstableBlock)BlocksNF.ASH.get()).m_49966_());
        } else {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)HEAT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)HEAT) - 1)));
            this.scheduleHeatTick((LevelAccessor)level, pos, (Block)this);
        }
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity pEntity) {
        BlockEntity blockEntity;
        if (!pEntity.m_5825_() && pEntity.f_19802_ <= 10 && pEntity instanceof LivingEntity && (blockEntity = level.m_7702_(pos)) instanceof BurningFuelBlockEntity) {
            BurningFuelBlockEntity fuel = (BurningFuelBlockEntity)blockEntity;
            pEntity.m_6469_((DamageSource)DamageTypeSource.HOT_FLOOR, fuel.temperature / 600.0f);
        }
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        BlockPos blockpos;
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        TieredHeat heat = this.getHeat(level, pos, state);
        if (rand.nextDouble() < 0.15) {
            level.m_7785_(x, y, z, (SoundEvent)SoundsNF.FIRE_CRACKLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        if (rand.nextDouble() < 0.9) {
            double xPos = x + (rand.nextDouble() - 0.5);
            double yPos = y + 1.05;
            double zPos = z + (rand.nextDouble() - 0.5);
            level.m_7106_((ParticleOptions)heat.getFlameParticle().get(), xPos, yPos, zPos, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, xPos, yPos, zPos, 0.0, 0.0, 0.0);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(rand.nextDouble() < 0.85)) continue;
            double xPos = x + (direction.m_122429_() == 0 ? rand.nextDouble() - 0.5 : (double)((float)direction.m_122429_() / 1.9f));
            double yPos = y + rand.nextDouble();
            double zPos = z + (direction.m_122431_() == 0 ? rand.nextDouble() - 0.5 : (double)((float)direction.m_122431_() / 1.9f));
            VoxelShape shape = level.m_8055_(pos.m_142300_(direction)).m_60812_((BlockGetter)level, pos.m_142300_(direction));
            if (!shape.m_83281_() && shape.m_83215_().m_82338_(pos.m_142300_(direction)).m_82393_(xPos, yPos, zPos)) continue;
            level.m_7106_((ParticleOptions)heat.getFlameParticle().get(), xPos, yPos, zPos, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, xPos, yPos, zPos, 0.0, 0.0, 0.0);
        }
        if (rand.nextDouble() < 0.55 && level.m_46758_(blockpos = pos.m_7494_())) {
            level.m_7785_(x, y, z, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.175f, 2.0f + (level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.8f, false);
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        this.spreadHeat((Level)level, pos, this.getHeat((Level)level, pos, state));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, newState, pIsMoving);
        if (!newState.m_60713_((Block)this)) {
            this.spreadHeat(level, pos, TieredHeat.NONE);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.scheduleHeatTick((LevelAccessor)level, pos, (Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HEAT});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        this.scheduleHeatTick(level, pos, (Block)this);
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(state, level, pos, pBlock, pFromPos, pIsMoving);
        if (pFromPos.m_123342_() >= pos.m_123342_() && (Integer)state.m_61143_((Property)HEAT) > 0 && level.m_6425_(pFromPos).m_205070_(FluidTags.f_13131_)) {
            this.tryToExtinguish(state, pos, level, ItemStack.f_41583_);
        }
    }

    public boolean tryToExtinguish(BlockState state, BlockPos pos, Level level, ItemStack stack) {
        if (level.m_5776_()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BurningFuelBlockEntity) {
            BurningFuelBlockEntity fuel = (BurningFuelBlockEntity)blockEntity;
            fuel.burnTicks = (int)((float)fuel.burnTicks - (float)this.burnTicks * 0.1f);
            fuel.m_6596_();
            if (fuel.burnTicks <= 0) {
                level.m_7731_(pos, ((UnstableBlock)BlocksNF.ASH.get()).m_49966_(), 3);
            } else {
                this.scheduleHeatTick((LevelAccessor)level, pos, (Block)this);
            }
        }
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.375f, 2.6f + (level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.8f);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, 8, 0.25, 0.25, 0.25, 0.0);
        return true;
    }

    @Override
    public TieredHeat getHeat(Level level, BlockPos pos, BlockState state) {
        return TieredHeat.fromTier((Integer)state.m_61143_((Property)HEAT));
    }

    @Override
    public float getTemperature(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BurningFuelBlockEntity) {
            BurningFuelBlockEntity fuel = (BurningFuelBlockEntity)blockEntity;
            return fuel.temperature;
        }
        return this.getHeat(level, pos, state).getBaseTemp();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.FUEL.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.m_5776_() ? null : BurningFuelBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntitiesNF.FUEL.get()), BurningFuelBlockEntity::serverTick);
    }

    @Override
    public NodeType adjustNodeType(NodeType type, BlockState state, LivingEntity entity) {
        return entity.m_5825_() ? type : NodeType.IMPASSABLE_DANGER_MINOR;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ((BlockState)this.baseFuel.get()).getCloneItemStack(target, level, pos, player);
    }
}

