/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.fuel;

import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.UnstableBlock;
import frostnox.nightfall.block.block.fuel.BurningFuelBlock;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.LevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BurningFuelBlockEntity
extends BlockEntity {
    public int cookTicks;
    public int burnTicks;
    public float temperature;
    public float structureTempBonus;

    public BurningFuelBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesNF.FUEL.get(), pos, state);
    }

    protected BurningFuelBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState state) {
        super(pType, pPos, state);
        this.burnTicks = ((BurningFuelBlock)state.m_60734_()).burnTicks;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BurningFuelBlockEntity entity) {
        BurningFuelBlock block = (BurningFuelBlock)state.m_60734_();
        if (level.m_46467_() % 66L == 0L) {
            float baseTemp = block.burnTemp;
            entity.structureTempBonus = LevelUtil.getNearbySmelterTier(level, pos) >= TieredHeat.fromTemp(baseTemp).getTier() ? 200.0f : 0.0f;
        }
        if (block.cookChecker != null && block.cookChecker.apply(level, pos) != null) {
            ++entity.cookTicks;
        }
        --entity.burnTicks;
        if (entity.burnTicks <= 0) {
            ((BurningFuelBlock)entity.m_58900_().m_60734_()).spreadHeat(level, pos, TieredHeat.NONE);
            if ((float)entity.cookTicks >= (float)block.burnTicks * 0.9f && block.cookChecker != null) {
                Block cookBlock = block.cookChecker.apply(level, pos);
                if (cookBlock != null) {
                    level.m_7731_(pos, cookBlock.m_49966_(), 19);
                } else {
                    level.m_7731_(pos, ((UnstableBlock)BlocksNF.ASH.get()).m_49966_(), 3);
                }
            } else {
                level.m_7731_(pos, ((UnstableBlock)BlocksNF.ASH.get()).m_49966_(), 3);
            }
        } else {
            float oldTemp = entity.temperature;
            float targetTemp = block.getTargetTemperature(level, state, pos);
            if (entity.temperature < targetTemp) {
                entity.temperature += 1.0f;
            } else if (entity.temperature > targetTemp) {
                entity.temperature -= 1.0f;
            }
            if (entity.temperature != oldTemp) {
                TieredHeat heat = block.getHeat(level, pos, state);
                if (heat != TieredHeat.fromTemp(entity.temperature)) {
                    if (entity.temperature < oldTemp) {
                        block.decreaseHeat(level, state, pos);
                    } else {
                        block.increaseHeat(level, state, pos);
                    }
                }
                entity.m_6596_();
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cookTicks = tag.m_128451_("cookTicks");
        this.burnTicks = tag.m_128451_("burnTicks");
        this.temperature = tag.m_128457_("temperature");
        this.structureTempBonus = tag.m_128457_("structureTempBonus");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("cookTicks", this.cookTicks);
        tag.m_128405_("burnTicks", this.burnTicks);
        tag.m_128350_("temperature", this.temperature);
        tag.m_128350_("structureTempBonus", this.structureTempBonus);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

