/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.mold;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.mold.ItemMoldBlockEntity;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ItemMoldBlock
extends WaterloggedEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty TICKING = BlockStatePropertiesNF.TICKING;
    public final TagKey<Item> matchingItemTag;
    public final int maxUnits;
    private final VoxelShape shapeX;
    private final VoxelShape shapeZ;

    public ItemMoldBlock(VoxelShape shape, TagKey<Item> matchingItemTag, int maxUnits, BlockBehaviour.Properties properties) {
        super(properties);
        this.shapeZ = shape;
        this.shapeX = Shapes.m_83048_((double)shape.m_83288_(Direction.Axis.Z), (double)shape.m_83288_(Direction.Axis.Y), (double)shape.m_83288_(Direction.Axis.X), (double)shape.m_83297_(Direction.Axis.Z), (double)shape.m_83297_(Direction.Axis.Y), (double)shape.m_83297_(Direction.Axis.X));
        this.matchingItemTag = matchingItemTag;
        this.maxUnits = maxUnits;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false)));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)new TranslatableComponent("block.capacity", new Object[]{this.maxUnits}).m_130940_(ChatFormatting.DARK_GREEN));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        return level.m_8055_(belowPos).m_60659_((BlockGetter)level, belowPos, Direction.UP, SupportType.CENTER);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        super.m_7417_(state, pFacing, pFacingState, level, pCurrentPos, pFacingPos);
        if (pFacing == Direction.DOWN && !state.m_60710_((LevelReader)level, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? this.shapeZ : this.shapeX;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, TICKING});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemMoldBlockEntity mold;
        if (player.m_6047_() && player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ItemMoldBlockEntity && (mold = (ItemMoldBlockEntity)blockEntity).isFull() && mold.isCool()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            LevelUtil.giveItemToPlayer(mold.getCastItem().m_41777_(), player, true);
            mold.getCastItem().m_41764_(0);
            mold.clearFluid();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_()) : null;
        }
        return state;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_48717_) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof ItemMoldBlockEntity) {
            ItemMoldBlockEntity entity = (ItemMoldBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, entity.getContainerDrops());
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, p_48717_);
    }

    public BlockState m_6843_(BlockState state, Rotation pRotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        return state.m_60717_(pMirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.ITEM_MOLD.get()).m_155264_(pos, state);
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entity) {
        if (!((Boolean)state.m_61143_((Property)TICKING)).booleanValue()) {
            return null;
        }
        if (level.m_5776_()) {
            return ItemMoldBlock.createTickerHelper(entity, (BlockEntityType)BlockEntitiesNF.ITEM_MOLD.get(), ItemMoldBlockEntity::clientTick);
        }
        return ItemMoldBlock.createTickerHelper(entity, (BlockEntityType)BlockEntitiesNF.ITEM_MOLD.get(), ItemMoldBlockEntity::serverTick);
    }
}

