/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.mold;

import frostnox.nightfall.block.IDropsItems;
import frostnox.nightfall.block.IHoldable;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.mold.ItemMoldBlock;
import frostnox.nightfall.block.fluid.MetalFluid;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ItemMoldBlockEntity
extends BlockEntity
implements IHoldable,
IDropsItems {
    protected FluidStack inputFluid = FluidStack.EMPTY;
    protected float temperature;

    public ItemMoldBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesNF.ITEM_MOLD.get(), pos, state);
    }

    protected ItemMoldBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
        this.temperature = tag.m_128457_("temperature");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.inputFluid.isEmpty()) {
            this.inputFluid.writeToNBT(tag);
        }
        tag.m_128350_("temperature", this.temperature);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ItemMoldBlockEntity entity) {
        if (entity.temperature > 0.0f) {
            entity.temperature -= 0.5f;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ItemMoldBlockEntity entity) {
        if (entity.temperature > 0.0f) {
            TieredHeat oldHeat = TieredHeat.fromTemp(entity.temperature);
            entity.temperature -= 0.5f;
            if (oldHeat != TieredHeat.fromTemp(entity.temperature)) {
                level.m_7260_(pos, state, state, 2);
            }
        }
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public boolean isEmpty() {
        return this.inputFluid.isEmpty();
    }

    public boolean isFull() {
        return this.inputFluid.getAmount() >= this.getMaxUnits();
    }

    public boolean isCool() {
        return this.temperature < TieredHeat.RED.getBaseTemp();
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getMaxUnits() {
        return ((ItemMoldBlock)this.m_58900_().m_60734_()).maxUnits;
    }

    public ItemStack getCastItem() {
        Fluid fluid;
        if (this.isCool() && this.isFull() && (fluid = this.inputFluid.getFluid()) instanceof MetalFluid) {
            MetalFluid metalFluid = (MetalFluid)fluid;
            return new ItemStack((ItemLike)metalFluid.metal.getMatchingItem(((ItemMoldBlock)this.m_58900_().m_60734_()).matchingItemTag));
        }
        return ItemStack.f_41583_;
    }

    @Override
    public NonNullList<ItemStack> getContainerDrops() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.getCastItem());
        return list;
    }

    public boolean addFluid(FluidStack fluid, float temperature) {
        boolean empty = this.inputFluid.isEmpty();
        if ((empty || this.inputFluid.getFluid().m_6212_(fluid.getFluid())) && this.inputFluid.getAmount() < this.getMaxUnits() && !fluid.isEmpty()) {
            if (this.temperature < temperature) {
                this.temperature = temperature;
            }
            int amount = Math.min(fluid.getAmount(), Math.min(this.getMaxUnits() - this.inputFluid.getAmount(), 10));
            if (empty) {
                this.inputFluid = new FluidStack(fluid.getFluid(), amount);
            } else {
                this.inputFluid.grow(Math.min(fluid.getAmount(), amount));
            }
            fluid.shrink(amount);
            this.m_6596_();
            if (empty) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ItemMoldBlock.TICKING, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
            return true;
        }
        return false;
    }

    public void clearFluid() {
        this.temperature = 0.0f;
        if (!this.inputFluid.isEmpty()) {
            this.inputFluid = FluidStack.EMPTY;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ItemMoldBlock.TICKING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void setInputFluid(FluidStack fluid) {
        this.inputFluid = fluid;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public CompoundTag writeDataAndClear() {
        CompoundTag data = this.m_187481_();
        data.m_128405_("state", Block.m_49956_((BlockState)((BlockState)this.m_58900_().m_61124_((Property)ItemMoldBlock.FACING, (Comparable)Direction.NORTH))));
        this.inputFluid = FluidStack.EMPTY;
        return data;
    }

    @Override
    public void onDrop(Level level, BlockPos pos) {
        NonNullList<ItemStack> drops = this.getContainerDrops();
        drops.add((Object)new ItemStack((ItemLike)this.m_58900_().m_60734_().m_5456_()));
        if (level != null) {
            Containers.m_19010_((Level)level, (BlockPos)pos, drops);
        }
    }

    @Override
    public boolean useBlockEntityItemRenderer() {
        return true;
    }

    @Override
    public double getFirstPersonYOffset() {
        return 0.4;
    }
}

