/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.nest;

import frostnox.nightfall.block.BlockEventListener;
import frostnox.nightfall.block.block.nest.NestBlockEntity;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.entity.HeadYRotToClient;
import frostnox.nightfall.registry.vanilla.GameEventsNF;
import frostnox.nightfall.util.MathUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class GuardedNestBlockEntity
extends NestBlockEntity {
    protected final GameEventListener eventListener;
    @Nullable
    public UUID scout;
    @Nullable
    protected ActionableEntity dummy;

    public GuardedNestBlockEntity(BlockEntityType<?> pType, BlockPos pos, BlockState pBlockState, int capacity, int respawnTime, BiFunction<ServerLevel, BlockPos, ActionableEntity> respawnFunc, int listenRange) {
        super(pType, pos, pBlockState, capacity, respawnTime, respawnFunc);
        this.eventListener = new BlockEventListener((PositionSource)new BlockPositionSource(pos), listenRange){

            public boolean m_142721_(Level level, GameEvent event, @Nullable Entity entity, BlockPos pos) {
                return GuardedNestBlockEntity.this.handleGameEvent(level, event, entity, pos);
            }
        };
    }

    public GameEventListener getEventListener() {
        return this.eventListener;
    }

    protected boolean shouldEventTriggerNest(float range, BlockPos pos, GameEvent event, Entity entity) {
        return pos.m_123331_((Vec3i)this.f_58858_) <= (double)(range * range);
    }

    protected boolean handleGameEvent(Level level, GameEvent event, @Nullable Entity entity, BlockPos pos) {
        LivingEntity livingEntity;
        block9: {
            block8: {
                Player player;
                if (!this.hasAnyEntities() || !(entity instanceof LivingEntity)) break block8;
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof FakePlayer) && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_())) break block9;
            }
            return false;
        }
        if (this.shouldEventTriggerNest(GameEventsNF.getEventRange(event, entity), pos, event, entity)) {
            if (this.dummy == null) {
                this.dummy = (ActionableEntity)((Object)this.respawnFunc.apply((ServerLevel)level, pos));
            }
            if (this.dummy.canTargetFromSound(livingEntity)) {
                if (this.removeEntityToSafePos(null) != null) {
                    while (this.hasAnyEntities()) {
                        Entity entity2 = this.popEntity(false);
                        if (!(entity2 instanceof ActionableEntity)) continue;
                        ActionableEntity guard = (ActionableEntity)entity2;
                        guard.getAudioSensing().getEventListener().m_142721_(level, event, entity, pos);
                        List<Entity> heardEntities = guard.getAudioSensing().getHeardEntities();
                        if (heardEntities.isEmpty()) continue;
                        Entity target = heardEntities.get(0);
                        guard.m_146922_(MathUtil.getAngleDegrees(target.m_20189_() - guard.m_20189_(), target.m_20185_() - guard.m_20185_()));
                        guard.m_5616_(guard.m_146908_());
                        guard.m_5618_(guard.m_146908_());
                        NetworkHandler.toAllTracking((Entity)guard, new HeadYRotToClient(guard.m_146908_(), guard.m_142049_()));
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("scoutUUID")) {
            this.scout = tag.m_128342_("scoutUUID");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.scout != null) {
            tag.m_128362_("scoutUUID", this.scout);
        }
    }
}

