/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.nest;

import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.nest.NestBlockEntity;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.util.MathUtil;
import it.unimi.dsi.fastutil.ints.IntLongPair;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.ticks.TickPriority;

public abstract class NestBlock
extends BaseEntityBlock
implements ITimeSimulatedBlock {
    public NestBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NestBlockEntity) {
            NestBlockEntity nest = (NestBlockEntity)blockEntity;
            nest.randomTick(level, pos);
        }
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.NORMAL, pos);
            BlockEntity blockEntity = levelReader.m_7702_(pos);
            if (blockEntity instanceof NestBlockEntity) {
                NestBlockEntity nest = (NestBlockEntity)blockEntity;
                nest.lastFullTime = level.m_46467_();
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(pNewState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof NestBlockEntity) {
            NestBlockEntity nest = (NestBlockEntity)blockEntity;
            nest.removeAllEntities(true);
        }
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        BlockEntity blockEntity;
        if (elapsedTime != Long.MAX_VALUE && (blockEntity = chunk.m_7702_(pos)) instanceof NestBlockEntity) {
            IntLongPair successesAndTicks;
            NestBlockEntity nest = (NestBlockEntity)blockEntity;
            long firstRespawnTime = nest.lastFullTime + (long)nest.respawnTime;
            long startTime = Math.max(0L, gameTime - elapsedTime);
            if (firstRespawnTime > startTime) {
                elapsedTime -= firstRespawnTime - startTime;
            }
            while (nest.canRespawn()) {
                successesAndTicks = MathUtil.getRandomSuccessesAndRemainingTrials(randomTickChance, elapsedTime, 1, random);
                if (successesAndTicks.firstInt() >= 1) {
                    nest.lastFullTime = gameTime - successesAndTicks.secondLong();
                    nest.respawnEntity(pos);
                    if (successesAndTicks.secondLong() - (long)nest.respawnTime <= 0L) {
                        elapsedTime = successesAndTicks.secondLong();
                        break;
                    }
                    elapsedTime = successesAndTicks.secondLong() - (long)nest.respawnTime;
                    continue;
                }
                return;
            }
            if (elapsedTime > 0L && (successesAndTicks = MathUtil.getRandomSuccessesAndRemainingTrials(randomTickChance, elapsedTime, 1, random)).firstInt() >= 1) {
                nest.lastFullTime = gameTime - (elapsedTime - successesAndTicks.secondLong());
                nest.m_6596_();
            }
        }
    }
}

