/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.nest;

import frostnox.nightfall.entity.IHomeEntity;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.util.LevelUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NestBlockEntity
extends BlockEntity
implements Clearable {
    public final int capacity;
    public final int respawnTime;
    protected final BiFunction<ServerLevel, BlockPos, ActionableEntity> respawnFunc;
    protected final List<CompoundTag> entityData;
    protected final Set<UUID> trackedEntities;
    public long lastFullTime = Long.MIN_VALUE;

    public NestBlockEntity(BlockEntityType<?> pType, BlockPos pos, BlockState pBlockState, int capacity, int respawnTime, BiFunction<ServerLevel, BlockPos, ActionableEntity> respawnFunc) {
        super(pType, pos, pBlockState);
        this.capacity = capacity;
        this.respawnTime = respawnTime;
        this.respawnFunc = respawnFunc;
        this.entityData = new ObjectArrayList(capacity);
        this.trackedEntities = new ObjectArraySet(capacity);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag entitiesList = tag.m_128437_("entities", 10);
        for (int i = 0; i < entitiesList.size(); ++i) {
            CompoundTag data = entitiesList.m_128728_(i);
            this.entityData.add(data);
        }
        if (tag.m_128441_("trackedEntities")) {
            ListTag ids = tag.m_128437_("trackedEntities", 11);
            for (Tag idTag : ids) {
                this.trackedEntities.add(NbtUtils.m_129233_((Tag)idTag));
            }
        }
        this.lastFullTime = tag.m_128454_("lastFullTime");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag entitiesList = new ListTag();
        for (CompoundTag data : this.entityData) {
            CompoundTag dataCopy = data.m_6426_();
            dataCopy.m_128473_("UUID");
            entitiesList.add((Object)dataCopy);
        }
        tag.m_128365_("entities", (Tag)entitiesList);
        if (!this.trackedEntities.isEmpty()) {
            ListTag ids = new ListTag();
            for (UUID id : this.trackedEntities) {
                ids.add((Object)NbtUtils.m_129226_((UUID)id));
            }
            tag.m_128365_("trackedEntities", (Tag)ids);
        }
        tag.m_128356_("lastFullTime", this.lastFullTime);
    }

    public void m_6211_() {
        this.entityData.clear();
    }

    public boolean isFull() {
        return this.entityData.size() >= this.capacity;
    }

    public boolean hasAnyEntities() {
        return !this.entityData.isEmpty();
    }

    public boolean canRespawn() {
        return this.entityData.size() + this.trackedEntities.size() < this.capacity;
    }

    public void respawnEntity(BlockPos pos) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.addEntity((Entity)this.respawnFunc.apply(serverLevel, pos));
        }
    }

    public void addEntity(Entity entity) {
        if (this.entityData.size() < this.capacity) {
            entity.m_8127_();
            entity.m_20153_();
            CompoundTag tag = new CompoundTag();
            entity.m_20223_(tag);
            this.entityData.add(tag);
            this.trackedEntities.remove(entity.m_142081_());
            entity.m_146870_();
            this.m_6596_();
        }
    }

    @Nullable
    public Entity popEntity(boolean forgetHome) {
        return this.removeEntity(this.entityData.size() - 1, forgetHome);
    }

    protected Direction[] getExitDirections() {
        return LevelUtil.HORIZONTAL_DIRECTIONS;
    }

    @Nullable
    public BlockPos removeEntityToSafePos(@Nullable Entity entity) {
        if (entity == null) {
            if (this.entityData.isEmpty()) {
                return null;
            }
            CompoundTag data = this.entityData.get(this.entityData.size() - 1);
            entity = EntityType.m_20645_((CompoundTag)data, (Level)this.f_58857_, e -> e);
        }
        if (entity.m_5720_() == SoundSource.HOSTILE && this.f_58857_.m_46791_() == Difficulty.PEACEFUL) {
            return null;
        }
        BlockPos pos = this.m_58899_();
        int randYRot = this.f_58857_.f_46441_.nextInt(360);
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, (float)randYRot, 0.0f);
        if (NestBlockEntity.canPlaceEntityAt(entity, this.m_58899_(), (BlockGetter)this.f_58857_)) {
            return this.m_58899_();
        }
        if (this.m_58900_().m_60767_().m_76334_()) {
            ObjectArrayList directions = new ObjectArrayList((Object[])this.getExitDirections());
            Collections.shuffle(directions, this.f_58857_.f_46441_);
            while (!directions.isEmpty()) {
                Direction direction = (Direction)directions.remove(0);
                pos = this.m_58899_().m_142300_(direction);
                entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, direction.m_122434_() == Direction.Axis.Y ? (float)randYRot : direction.m_122435_() % 360.0f, 0.0f);
                if (!NestBlockEntity.canPlaceEntityAt(entity, pos, (BlockGetter)this.f_58857_)) continue;
                return pos;
            }
        }
        return null;
    }

    public static boolean canPlaceEntityAt(Entity entity, BlockPos pos, BlockGetter level) {
        BlockState pState = level.m_8055_(pos);
        VoxelShape blockShape = pState.m_60742_(level, pos, CollisionContext.m_82750_((Entity)entity)).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return !Shapes.m_83157_((VoxelShape)blockShape, (VoxelShape)Shapes.m_83064_((AABB)entity.m_142469_()), (BooleanOp)BooleanOp.f_82689_);
    }

    @Nullable
    public Entity removeEntity(int index, boolean forgetHome) {
        if (this.entityData.isEmpty() || index < 0 || index >= this.entityData.size()) {
            return null;
        }
        CompoundTag data = this.entityData.remove(index);
        Entity entity = EntityType.m_20645_((CompoundTag)data, (Level)this.f_58857_, e -> e);
        this.m_6596_();
        if (entity != null) {
            this.removeEntityToSafePos(entity);
            if (entity instanceof IHomeEntity) {
                IHomeEntity homeEntity = (IHomeEntity)entity;
                if (forgetHome) {
                    homeEntity.setHomePos(null);
                } else {
                    this.trackedEntities.add(entity.m_142081_());
                }
                homeEntity.onExitHome();
            }
            entity.m_5618_(entity.m_146908_());
            entity.m_5616_(entity.m_146908_());
            this.f_58857_.m_7967_(entity);
            entity.m_146922_(entity.m_146908_());
            return entity;
        }
        return null;
    }

    public void removeAllEntities(boolean forgetHome) {
        while (!this.entityData.isEmpty()) {
            this.popEntity(forgetHome);
        }
    }

    public void startTrackingEntity(UUID id) {
        if (this.trackedEntities.add(id)) {
            this.m_6596_();
        }
    }

    public void stopTrackingEntity(UUID id) {
        if (this.trackedEntities.remove(id)) {
            this.m_6596_();
        }
    }

    public void randomTick(ServerLevel level, BlockPos pos) {
        if (this.canRespawn()) {
            if (level.m_46467_() - this.lastFullTime >= (long)this.respawnTime) {
                this.addEntity((Entity)this.respawnFunc.apply(level, pos));
                this.m_6596_();
            }
        } else {
            this.lastFullTime = level.m_46467_();
            this.m_6596_();
        }
    }
}

