/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.nest;

import frostnox.nightfall.block.block.nest.GuardedNestBlockEntity;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.monster.RockwormEntity;
import frostnox.nightfall.registry.ActionsNF;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class RockwormNestBlockEntity
extends GuardedNestBlockEntity {
    private static final Direction[] EXIT_UP = new Direction[]{Direction.UP};
    protected long lastDigTime = 0L;

    public RockwormNestBlockEntity(BlockEntityType<?> pType, BlockPos pos, BlockState pBlockState, int capacity, int respawnTime, BiFunction<ServerLevel, BlockPos, ActionableEntity> respawnFunc, int listenRange) {
        super(pType, pos, pBlockState, capacity, respawnTime, respawnFunc, listenRange);
    }

    public BlockPos getEmergePos() {
        BlockPos pos = this.m_58899_();
        for (int i = 0; i < 5; ++i) {
            BlockState block = this.f_58857_.m_8055_(pos = pos.m_7494_());
            if (block.m_204336_(TagsNF.STONE_TUNNELS) && block.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y) continue;
            return pos;
        }
        return pos;
    }

    @Override
    @Nullable
    public Entity removeEntity(int index, boolean forgetHome) {
        Entity entity = super.removeEntity(index, forgetHome);
        if (entity instanceof RockwormEntity) {
            RockwormEntity rockworm = (RockwormEntity)entity;
            rockworm.retreatCooldown = 6;
            rockworm.startAction(ActionsNF.ROCKWORM_EMERGE.getId());
        }
        return entity;
    }

    @Override
    protected Direction[] getExitDirections() {
        return EXIT_UP;
    }

    @Override
    public BlockPos removeEntityToSafePos(@Nullable Entity entity) {
        if (entity == null) {
            if (this.entityData.isEmpty()) {
                return null;
            }
            CompoundTag data = (CompoundTag)this.entityData.get(this.entityData.size() - 1);
            entity = EntityType.m_20645_((CompoundTag)data, (Level)this.f_58857_, e -> e);
        }
        if (entity.m_5720_() == SoundSource.HOSTILE && this.f_58857_.m_46791_() == Difficulty.PEACEFUL) {
            return null;
        }
        BlockPos pos = this.m_58899_();
        int randYRot = this.f_58857_.f_46441_.nextInt(360);
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, (float)randYRot, 0.0f);
        for (int i = 0; i < 5; ++i) {
            pos = pos.m_7494_();
            entity.m_6027_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            if (RockwormNestBlockEntity.canPlaceEntityAt(entity, pos, (BlockGetter)this.f_58857_)) {
                return pos;
            }
            BlockState block = this.f_58857_.m_8055_(pos);
            if (block.m_204336_(TagsNF.STONE_TUNNELS) && block.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y) continue;
            return null;
        }
        return null;
    }

    @Override
    protected boolean shouldEventTriggerNest(float range, BlockPos pos, GameEvent event, Entity entity) {
        double blockDistSqr = this.getEmergePos().m_7494_().m_123331_((Vec3i)pos);
        return blockDistSqr <= (double)(range * range) && blockDistSqr < 9.610000000000001;
    }

    @Override
    protected boolean handleGameEvent(Level level, GameEvent event, @Nullable Entity entity, BlockPos pos) {
        if (super.handleGameEvent(level, event, entity, pos)) {
            if (this.hasAnyEntities() && level.m_46467_() - this.lastDigTime >= 15L) {
                BlockState block;
                BlockPos digPos = this.m_58899_();
                for (int i = 0; i < 5 && (block = level.m_8055_(digPos = digPos.m_7494_())).m_204336_(TagsNF.STONE_TUNNELS) && block.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y; ++i) {
                }
                this.dummy.mineBlock(level, digPos);
                this.lastDigTime = level.m_46467_();
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lastDigTime = tag.m_128454_("lastDigTime");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("lastDigTime", this.lastDigTime);
    }
}

