/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.nest;

import frostnox.nightfall.block.block.SpiderWebBlock;
import frostnox.nightfall.block.block.nest.GuardedNestBlock;
import frostnox.nightfall.block.block.nest.GuardedNestBlockEntity;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.entity.entity.monster.SpiderEntity;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.math.AxisDirection;
import it.unimi.dsi.fastutil.ints.IntLongPair;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class SpiderNestBlock
extends GuardedNestBlock {
    public static final int WEB_RADIUS_SQR = 20;

    public SpiderNestBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void growWebs(WorldGenLevel level, BlockPos center, int maxCycles) {
        ObjectArraySet visited = new ObjectArraySet(40);
        visited.add((Object)center);
        ObjectArrayFIFOQueue positions = new ObjectArrayFIFOQueue(40);
        for (Direction dir : Direction.values()) {
            BlockPos adjPos = center.m_142300_(dir);
            positions.enqueue((Object)adjPos);
            visited.add((Object)adjPos);
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        double shortestWebDist = 0.0;
        int cycles = 0;
        SpiderWebBlock webBlock = (SpiderWebBlock)((Object)BlocksNF.SPIDER_WEB.get());
        while (!positions.isEmpty()) {
            BlockPos pos = (BlockPos)positions.dequeue();
            double distSqr = pos.m_123331_((Vec3i)center);
            if (distSqr > 20.0) continue;
            BlockState state = level.m_8055_(pos);
            if (webBlock.canSpreadAt((BlockGetter)level, pos, state)) {
                if (!(distSqr <= shortestWebDist) && cycles >= maxCycles) continue;
                if (distSqr > shortestWebDist) {
                    if (cycles < maxCycles) {
                        ++cycles;
                    }
                    shortestWebDist = distSqr + 0.001;
                }
                level.m_7731_(pos, webBlock.getFullyAttachedState((BlockGetter)level, pos), 3);
            } else if (!state.m_60713_((Block)webBlock)) {
                if (state.m_60767_().m_76334_()) {
                    mutablePos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                } else {
                    mutablePos.m_122178_(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_());
                }
                if (visited.contains((Object)mutablePos)) continue;
                BlockPos belowPos = mutablePos.m_7949_();
                visited.add((Object)belowPos);
                positions.enqueue((Object)belowPos);
                continue;
            }
            for (AxisDirection dir : AxisDirection.values()) {
                mutablePos.m_122178_(pos.m_123341_() + dir.x, pos.m_123342_() + dir.y, pos.m_123343_() + dir.z);
                if (visited.contains((Object)mutablePos)) continue;
                BlockPos neighborPos = mutablePos.m_7949_();
                visited.add((Object)neighborPos);
                positions.enqueue((Object)neighborPos);
            }
        }
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        super.m_7455_(state, level, pos, random);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GuardedNestBlockEntity) {
            Entity entity;
            GuardedNestBlockEntity nest = (GuardedNestBlockEntity)blockEntity;
            if ((nest.scout == null || !nest.trackedEntities.contains(nest.scout)) && nest.removeEntityToSafePos(null) != null && (entity = nest.popEntity(false)) instanceof SpiderEntity) {
                SpiderEntity spider = (SpiderEntity)entity;
                spider.isScout = true;
                nest.scout = spider.m_142081_();
            }
            if (!nest.canRespawn() && random.nextInt(3) == 0) {
                this.growWebs((WorldGenLevel)level, pos, 1);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.SPIDER_NEST.get()).m_155264_(pos, state);
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        BlockEntity blockEntity;
        if (elapsedTime != Long.MAX_VALUE && (blockEntity = chunk.m_7702_(pos)) instanceof GuardedNestBlockEntity) {
            IntLongPair successesAndTicks;
            long startTime;
            long firstRespawnTime;
            Entity entity;
            GuardedNestBlockEntity nest = (GuardedNestBlockEntity)blockEntity;
            if (nest.hasAnyEntities() && (nest.scout == null || !nest.trackedEntities.contains(nest.scout)) && MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 1, random) >= 1 && nest.removeEntityToSafePos(null) != null && (entity = nest.popEntity(false)) instanceof SpiderEntity) {
                SpiderEntity spider = (SpiderEntity)entity;
                spider.isScout = true;
                nest.scout = spider.m_142081_();
            }
            if ((firstRespawnTime = nest.lastFullTime + (long)nest.respawnTime) > (startTime = Math.max(0L, gameTime - elapsedTime))) {
                elapsedTime -= firstRespawnTime - startTime;
            }
            while (nest.canRespawn()) {
                successesAndTicks = MathUtil.getRandomSuccessesAndRemainingTrials(randomTickChance, elapsedTime, 1, random);
                if (successesAndTicks.firstInt() >= 1) {
                    Entity entity2;
                    nest.lastFullTime = gameTime - successesAndTicks.secondLong();
                    nest.respawnEntity(pos);
                    if ((nest.scout == null || !nest.trackedEntities.contains(nest.scout)) && nest.removeEntityToSafePos(null) != null && (entity2 = nest.popEntity(false)) instanceof SpiderEntity) {
                        SpiderEntity spider = (SpiderEntity)entity2;
                        spider.isScout = true;
                        nest.scout = spider.m_142081_();
                    }
                    if (successesAndTicks.secondLong() - (long)nest.respawnTime <= 0L) {
                        elapsedTime = successesAndTicks.secondLong();
                        break;
                    }
                    elapsedTime = successesAndTicks.secondLong() - (long)nest.respawnTime;
                    continue;
                }
                return;
            }
            if (elapsedTime > 0L) {
                successesAndTicks = MathUtil.getRandomSuccessesAndRemainingTrials(randomTickChance, elapsedTime, 1, random);
                if (successesAndTicks.firstInt() >= 1) {
                    nest.lastFullTime = gameTime - (elapsedTime - successesAndTicks.secondLong());
                    nest.m_6596_();
                }
                this.growWebs((WorldGenLevel)level, pos, MathUtil.getRandomSuccesses(randomTickChance / 3.0, elapsedTime, 8, random));
            }
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }
}

