/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.pile;

import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.TimeDataBlockEntity;
import frostnox.nightfall.block.block.pile.PileBlock;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.MathUtil;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class DryingPileBlock
extends PileBlock
implements EntityBlock,
ITimeSimulatedBlock {
    public final Supplier<? extends PileBlock> dryBlock;
    public final int ticksToDry;
    public final int minLightToDry;

    public DryingPileBlock(Supplier<? extends Item> drop, Supplier<? extends PileBlock> dryBlock, int ticksToDry, int minLightToDry, VoxelShape shapeZ, BlockBehaviour.Properties properties) {
        super(drop, shapeZ, properties);
        this.dryBlock = dryBlock;
        this.ticksToDry = ticksToDry;
        this.minLightToDry = minLightToDry;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TimeDataBlockEntity) {
            TimeDataBlockEntity pile = (TimeDataBlockEntity)blockEntity;
            if (!level.m_46758_(pos) && level.m_45524_(pos, 0) >= this.minLightToDry) {
                float humidity;
                LevelChunk chunk = level.m_46745_(pos);
                float f = humidity = ChunkData.isPresent(chunk) ? ChunkData.get(chunk).getHumidity(pos) : 0.5f;
                if ((double)(level.m_46467_() - pile.lastProcessedTick) >= (double)this.ticksToDry * (1.5 - (double)humidity)) {
                    level.m_7731_(pos, (BlockState)((BlockState)this.dryBlock.get().m_49966_().m_61124_((Property)COUNT, (Comparable)((Integer)state.m_61143_((Property)COUNT)))).m_61124_((Property)AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)AXIS))), 3);
                }
            } else {
                pile.lastProcessedTick = level.m_46467_();
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.TIME_DATA.get()).m_155264_(pos, state);
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        if (MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 1, random) >= 1) {
            this.m_7455_(state, level, pos, random);
        }
    }
}

