/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.pot;

import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.pot.PotBlockEntity;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class PotBlock
extends WaterloggedEntityBlock
implements ICustomPathfindable {
    protected static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)COLLISION_SHAPE, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), Block.m_49796_((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)});
    protected static final List<AABB> AABB = COLLISION_SHAPE.m_83299_();

    public PotBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.POT.get()).m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos abovePos = pos.m_7494_();
        if (!level.m_8055_(abovePos).m_60659_((BlockGetter)level, abovePos, Direction.DOWN, SupportType.CENTER) && (blockEntity = level.m_7702_(pos)) instanceof PotBlockEntity) {
            PotBlockEntity pot = (PotBlockEntity)blockEntity;
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)pot, (BlockPos)pos);
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return COLLISION_SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(pNewState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof Container) {
            Container container = (Container)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
        }
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity;
        if (pStack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
            container.m_58638_(pStack.m_41786_());
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.m_142535_(fallDistance, 1.0f, DamageSource.f_19315_)) {
            MovingBlockEntity movingBlock;
            if (entity instanceof MovingBlockEntity && (movingBlock = (MovingBlockEntity)entity).getBlockState().m_204336_(TagsNF.SHATTER_ON_FALL)) {
                movingBlock.tryPlacement();
            }
            level.m_46961_(pos, true);
        }
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile pProjectile) {
        if (!level.f_46443_ && pProjectile.m_6095_().m_204039_(EntityTypeTags.f_13124_) && pProjectile.m_20184_().m_82553_() >= 1.4) {
            level.m_46961_(pHit.m_82425_(), true);
        }
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return this.getTypeForCenteredBottomShape(nodeManager, pos, 0.75f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.OPEN;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return AABB;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return AABB;
    }
}

