/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.rack;

import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.rack.RackBlockEntity;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RackBlock
extends WaterloggedEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)3.0, (double)2.0, (double)13.0, (double)13.0, (double)14.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = MathUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_90);
    protected static final VoxelShape SOUTH_SHAPE = MathUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_180);
    protected static final VoxelShape WEST_SHAPE = MathUtil.rotate(NORTH_SHAPE, Rotation.COUNTERCLOCKWISE_90);

    public RackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.RACK.get()).m_155264_(pos, state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos supportPos = pos.m_142300_(facing.m_122424_());
        return Block.m_49918_((VoxelShape)level.m_8055_(supportPos).m_60816_((BlockGetter)level, supportPos), (Direction)facing);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!(state = super.m_7417_(state, facing, facingState, level, pos, facingPos)).m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RackBlockEntity) {
            RackBlockEntity rack = (RackBlockEntity)blockEntity;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            ItemStack heldItem = pPlayer.m_21120_(pHand);
            double y = Math.abs(pHit.m_82450_().f_82480_) % 1.0;
            int index = y < 0.3125 ? 0 : (y < 0.6875 ? 1 : 2);
            ItemStack item = (ItemStack)rack.items.get(index);
            if (!item.m_41619_()) {
                pPlayer.m_150109_().m_150079_(item.m_41777_());
                rack.items.set(index, (Object)ItemStack.f_41583_);
                rack.m_6596_();
                level.m_7260_(pos, state, state, 2);
                return InteractionResult.CONSUME;
            }
            if (heldItem.m_204117_(TagsNF.RACK_ITEM)) {
                rack.items.set(index, (Object)heldItem.m_41777_());
                if (!pPlayer.m_150110_().f_35937_) {
                    pPlayer.m_21008_(pHand, ItemStack.f_41583_);
                }
                rack.m_6596_();
                level.m_7260_(pos, state, state, 2);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            default -> WEST_SHAPE;
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(pNewState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof RackBlockEntity) {
            RackBlockEntity rack = (RackBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)rack.items);
        }
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_43719_());
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation pRotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        return state.m_60717_(pMirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }
}

