/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.shelf;

import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.block.WaterloggedEntityBlock;
import frostnox.nightfall.block.block.shelf.ShelfBlockEntity;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.math.OctalDirection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends WaterloggedEntityBlock
implements ICustomPathfindable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)8.0), Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)8.0), Block.m_49796_((double)2.0, (double)7.0, (double)0.0, (double)14.0, (double)9.0, (double)8.0), Block.m_49796_((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)8.0)});
    protected static final VoxelShape NORTH_SHAPE = MathUtil.rotate(SOUTH_SHAPE, Rotation.CLOCKWISE_180);
    protected static final VoxelShape EAST_SHAPE = MathUtil.rotate(SOUTH_SHAPE, Rotation.COUNTERCLOCKWISE_90);
    protected static final VoxelShape WEST_SHAPE = MathUtil.rotate(SOUTH_SHAPE, Rotation.CLOCKWISE_90);
    protected static final List<AABB> NORTH_FACE_Y = NORTH_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> SOUTH_FACE_Y = SOUTH_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> WEST_FACE_Y = WEST_SHAPE.m_83263_(Direction.UP).m_83299_();
    protected static final List<AABB> EAST_FACE_Y = EAST_SHAPE.m_83263_(Direction.UP).m_83299_();

    public ShelfBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.SHELF.get()).m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ShelfBlockEntity) {
            double x;
            ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
            Vec3 loc = pHit.m_82450_();
            double y = loc.f_82480_ % 1.0;
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            double d = x = facing.m_122434_() == Direction.Axis.Z ? loc.f_82479_ % 1.0 : loc.f_82481_ % 1.0;
            if (y < 0.0) {
                y += 1.0;
            }
            if (x < 0.0) {
                x += 1.0;
            }
            if (x > 0.0 && x < 1.0 && y > 0.0 && y < 1.0) {
                ItemStack item;
                int index;
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                int n = (facing == Direction.SOUTH || facing == Direction.WEST ? x < 0.5 : x > 0.5) ? 0 : (index = 1);
                if (y < 0.5) {
                    index += 2;
                }
                if (!(item = (ItemStack)shelf.items.get(index)).m_41619_()) {
                    pPlayer.m_150109_().m_150079_(item.m_41777_());
                    shelf.items.set(index, (Object)ItemStack.f_41583_);
                    shelf.m_6596_();
                    level.m_7260_(pos, state, state, 2);
                    return InteractionResult.CONSUME;
                }
                ItemStack heldItem = pPlayer.m_21120_(pHand);
                if (heldItem.m_41741_() > 4) {
                    shelf.items.set(index, (Object)heldItem.m_41777_());
                    if (!pPlayer.m_150110_().f_35937_) {
                        pPlayer.m_21008_(pHand, ItemStack.f_41583_);
                    }
                    shelf.m_6596_();
                    level.m_7260_(pos, state, state, 2);
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            default -> WEST_SHAPE;
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(pNewState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)shelf.items);
        }
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            if (context.m_43719_().m_122434_() == Direction.Axis.Y) {
                double x;
                Direction dir = context.m_8125_();
                Vec3 loc = context.m_43720_();
                double d = x = dir.m_122434_() == Direction.Axis.X ? loc.f_82479_ % 1.0 : loc.f_82481_ % 1.0;
                if (x < 0.0) {
                    x += 1.0;
                }
                if (dir.m_122421_() == Direction.AxisDirection.NEGATIVE ? x < 0.5 : x > 0.5) {
                    dir = dir.m_122424_();
                }
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)dir);
            }
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_43719_());
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation pRotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        return state.m_60717_(pMirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 1;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        OctalDirection gapDirection = OctalDirection.fromDirection((Direction)state.m_61143_((Property)FACING));
        return this.getTypeForSideClosedShape(nodeManager, state, level, pos, gapDirection);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return this.getBottomFaceShape(state);
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_FACE_Y;
            case Direction.SOUTH -> SOUTH_FACE_Y;
            case Direction.WEST -> WEST_FACE_Y;
            default -> EAST_FACE_Y;
        };
    }

    @Override
    public OctalDirection getDirection(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> OctalDirection.SOUTH;
            case Direction.SOUTH -> OctalDirection.NORTH;
            case Direction.WEST -> OctalDirection.EAST;
            default -> OctalDirection.WEST;
        };
    }
}

