/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.tree;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.block.tree.TreeTrunkBlockEntity;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TreeBranchesBlock
extends Block
implements ICustomPathfindable {
    public static final BooleanProperty ALTERNATE = BlockStatePropertiesNF.ALTERNATE;
    public static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public final ITree type;

    public TreeBranchesBlock(ITree type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ALTERNATE, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        if (!TreeTrunkBlockEntity.updating && !pNewState.m_60713_((Block)this)) {
            TreeGenerator gen = this.type.getGenerator();
            if (gen.maxLeavesRadius <= 1) {
                return;
            }
            int minX = pos.m_123341_() - gen.maxLeavesDistXZ;
            int maxX = pos.m_123341_() + gen.maxLeavesDistXZ;
            int minZ = pos.m_123343_() - gen.maxLeavesDistXZ;
            int maxZ = pos.m_123343_() + gen.maxLeavesDistXZ;
            List<TreeTrunkBlockEntity> nearbyTrunks = TreeTrunkBlockEntity.getNearbyTrunks(level, this.type, pos, minX, maxX, minZ, maxZ);
            for (TreeTrunkBlockEntity nearbyTrunk : nearbyTrunks) {
                TreeGenerator.Data simulatedData = gen.getTree((WorldGenLevel)level, nearbyTrunk, true);
                if (!simulatedData.branchLeaves.contains((Object)pos) && !simulatedData.trunkLeaves.contains((Object)pos)) continue;
                nearbyTrunk.updateBlocks(pos, simulatedData, true);
            }
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.m_142535_(fallDistance, 1.0f, DamageSource.f_19315_)) {
            level.m_46961_(pos, true);
        }
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter pReader, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        if (context instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)context).m_193113_() != null) {
            return entityContext.m_193113_() instanceof LivingEntity ? COLLISION_SHAPE : Shapes.m_83040_();
        }
        return super.m_5939_(state, level, pos, context);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public boolean m_6104_(BlockState state, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.m_204336_(TagsNF.BRANCHES_OR_LEAVES);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ALTERNATE});
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ALTERNATE, (Comparable)Boolean.valueOf(context.m_43723_() != null && context.m_43723_().m_6144_()));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return this.getTypeForBottomClosedShape(nodeManager, level, pos, 0.75f);
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.OPEN;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return NO_BOXES;
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return FULL_BOXES;
    }
}

