/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.tree;

import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.block.tree.TreeBranchesBlock;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.world.Season;
import java.util.Random;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.common.IForgeShearable;

public class TreeLeavesBlock
extends TreeBranchesBlock
implements IForgeShearable {
    protected final IBlockRenderProperties renderProperties = new IBlockRenderProperties(){

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            boolean hasParticle;
            boolean bl = hasParticle = TreeLeavesBlock.this.type.getParticle() != null;
            if (hasParticle && level.m_46467_() % 10L == 0L) {
                Vec3 pos = target.m_82450_();
                level.m_7106_((ParticleOptions)new BlockParticleOption((ParticleType)TreeLeavesBlock.this.type.getParticle().get(), state), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            return hasParticle;
        }

        public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
            boolean hasParticle;
            boolean bl = hasParticle = TreeLeavesBlock.this.type.getParticle() != null;
            if (hasParticle) {
                for (int i = 0; i < 3 + Math.abs(level.f_46441_.nextInt() % 4); ++i) {
                    double x = (double)pos.m_123341_() + level.f_46441_.nextDouble();
                    double y = (double)pos.m_123342_() + level.f_46441_.nextDouble();
                    double z = (double)pos.m_123343_() + level.f_46441_.nextDouble();
                    level.m_7106_((ParticleOptions)new BlockParticleOption((ParticleType)TreeLeavesBlock.this.type.getParticle().get(), state), x, y, z, 0.0, 0.0, 0.0);
                }
            }
            return hasParticle;
        }
    };

    public TreeLeavesBlock(ITree type, BlockBehaviour.Properties properties) {
        super(type, properties);
    }

    @Override
    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!level.m_46758_(pos.m_7494_()) || random.nextInt() % 15 != 0 || (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP))) {
            double d0 = (double)pos.m_123341_() + random.nextDouble();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + random.nextDouble();
            level.m_7106_((ParticleOptions)ParticleTypesNF.DRIPPING_WATER.get(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
        if (this.type.getParticle() != null) {
            int tickMod;
            switch (Season.get(level)) {
                case SPRING: {
                    tickMod = 2400;
                    break;
                }
                case SUMMER: {
                    tickMod = 1600;
                    break;
                }
                case FALL: {
                    tickMod = 550;
                    break;
                }
                default: {
                    return;
                }
            }
            if (random.nextInt() % tickMod == 0) {
                double x = (double)pos.m_123341_() + random.nextDouble();
                double y = pos.m_123342_();
                double z = (double)pos.m_123343_() + random.nextDouble();
                level.m_7106_((ParticleOptions)new BlockParticleOption((ParticleType)this.type.getParticle().get(), state), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.m_142535_(Math.max(0.0f, fallDistance - 1.5f), 1.0f, DamageSource.f_19315_)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.m_5776_() || this.type.getParticle() == null) {
            return;
        }
        Vec3 velocity = entity.m_20184_();
        if (level.m_46467_() % 12L == 0L && !entity.m_6047_() && velocity.m_82556_() > 0.0) {
            double x = (double)pos.m_123341_() + level.f_46441_.nextDouble();
            double y = (double)pos.m_123342_() + level.f_46441_.nextDouble();
            double z = (double)pos.m_123343_() + level.f_46441_.nextDouble();
            level.m_7106_((ParticleOptions)new BlockParticleOption((ParticleType)this.type.getParticle().get(), state), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public Object getRenderPropertiesInternal() {
        return this.renderProperties;
    }
}

