/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.tree;

import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.BushBlockNF;
import frostnox.nightfall.block.block.tree.TreeTrunkBlock;
import frostnox.nightfall.block.block.tree.TreeTrunkBlockEntity;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.Season;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import it.unimi.dsi.fastutil.ints.IntLongPair;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.PlantType;

public class TreeSeedBlock
extends BushBlock
implements ITimeSimulatedBlock {
    public static final IntegerProperty STAGE = BlockStateProperties.f_61387_;
    public final TreeTrunkBlock treeBlock;
    public static final VoxelShape SHAPE_0 = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    public static final VoxelShape SHAPE_1 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public TreeSeedBlock(TreeTrunkBlock treeBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.treeBlock = treeBlock;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public float m_5880_(BlockState state, Player pPlayer, BlockGetter level, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)STAGE) == 0) {
            return Float.POSITIVE_INFINITY;
        }
        return super.m_5880_(state, pPlayer, level, pos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.treeBlock.treeGenerator.canPlaceOnBlock(level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)STAGE) == 0 ? SHAPE_0 : SHAPE_1;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{STAGE});
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return null;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (random.nextBoolean()) {
            if (this.treeBlock.treeGenerator.canGrowAt((BlockAndTintGetter)level, pos)) {
                if ((Integer)state.m_61143_((Property)STAGE) == 1) {
                    this.treeBlock.growSaplingAt(level, pos);
                } else {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)), 3);
                }
            } else {
                level.m_7731_(pos, ((BushBlockNF)((Object)BlocksNF.DEAD_BUSH.get())).m_49966_(), 3);
            }
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        int successes = 2 - (Integer)state.m_61143_((Property)STAGE);
        IntLongPair result = MathUtil.getRandomSuccessesAndRemainingTrials(randomTickChance / 2.0, elapsedTime, successes, random);
        if (result.firstInt() >= 1 && !this.treeBlock.treeGenerator.canGrowAt((BlockAndTintGetter)level, pos)) {
            level.m_7731_(pos, ((BushBlockNF)((Object)BlocksNF.DEAD_BUSH.get())).m_49966_(), 3);
            return;
        }
        if (successes == 2 && result.firstInt() == 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)), 3);
        } else if (result.firstInt() >= successes) {
            level.m_46597_(pos, this.treeBlock.m_49966_());
            BlockEntity blockEntity = chunk.m_7702_(pos);
            if (blockEntity instanceof TreeTrunkBlockEntity) {
                TreeTrunkBlockEntity trunk = (TreeTrunkBlockEntity)blockEntity;
                trunk.initSeed();
                trunk.m_6596_();
                int spacing = this.treeBlock.type.getGrowthIntervalTicks();
                int stages = MathUtil.getRandomSuccesses(randomTickChance, result.secondLong() - (long)spacing, this.treeBlock.treeGenerator.maxLength - trunk.maxHeight - 1, spacing, random);
                TreeTrunkBlockEntity.updating = true;
                int tickAdjustedSpacing = spacing + (int)(1.0 / randomTickChance);
                long startSeasonTime = seasonTime - elapsedTime;
                long finalTickSeasonTime = seasonTime - elapsedTime + (long)(stages * tickAdjustedSpacing);
                if (stages >= 1) {
                    this.treeBlock.treeGenerator.grow((WorldGenLevel)level, trunk, 1, finalTickSeasonTime, true);
                }
                if (stages > 1) {
                    TreeGenerator.Data d = this.treeBlock.treeGenerator.grow((WorldGenLevel)level, trunk, stages - 1, finalTickSeasonTime, false);
                    if (trunk.isSpecial() && this.treeBlock.fruitBlock != null && trunk.maxHeight == d.maxHeight) {
                        boolean doFruit;
                        boolean bl = doFruit = !d.decaying;
                        if (doFruit) {
                            long summerTime = Season.getTimePassedWithin(startSeasonTime, stages * tickAdjustedSpacing, 336000L, 672000L);
                            if (MathUtil.getRandomSuccesses(randomTickChance, summerTime, 1, random) >= 1) {
                                if (Season.get(finalTickSeasonTime) != Season.SUMMER && MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(startSeasonTime, stages * tickAdjustedSpacing, 672000L, seasonTime), 1, random) >= 1) {
                                    doFruit = false;
                                }
                            } else {
                                doFruit = false;
                            }
                        }
                        if (doFruit) {
                            if (!trunk.hasFruited) {
                                this.treeBlock.treeGenerator.tryFruit((WorldGenLevel)level, d, trunk);
                            }
                        } else {
                            trunk.hasFruited = false;
                            trunk.m_6596_();
                        }
                    }
                }
                TreeTrunkBlockEntity.updating = false;
                trunk.lastTick = gameTime / (long)tickAdjustedSpacing * (long)tickAdjustedSpacing;
            }
        }
    }
}

