/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.tree;

import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.block.tree.TreeTrunkBlockEntity;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeStemBlock
extends RotatedPillarBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"stem_type", Type.class);
    public final ITree type;

    public TreeStemBlock(ITree type, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)Type.TOP)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{TYPE});
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        if (!TreeTrunkBlockEntity.updating && !pNewState.m_60713_((Block)this)) {
            TreeGenerator gen = this.type.getGenerator();
            int minX = pos.m_123341_() - gen.maxDistXZ;
            int maxX = pos.m_123341_() + gen.maxDistXZ;
            int minZ = pos.m_123343_() - gen.maxDistXZ;
            int maxZ = pos.m_123343_() + gen.maxDistXZ;
            List<TreeTrunkBlockEntity> nearbyTrunks = TreeTrunkBlockEntity.getNearbyTrunks(level, this.type, pos, minX, maxX, minZ, maxZ);
            for (TreeTrunkBlockEntity nearbyTrunk : nearbyTrunks) {
                TreeGenerator.Data simulatedData = gen.getTree((WorldGenLevel)level, nearbyTrunk, true);
                if (!simulatedData.hasTrunkWood(pos) && !simulatedData.otherWood.contains((Object)pos)) continue;
                nearbyTrunk.updateBlocks(pos, simulatedData, false);
            }
        }
    }

    public static enum Type implements StringRepresentable
    {
        END,
        TOP,
        BOTTOM,
        ROTATED_TOP,
        ROTATED_BOTTOM,
        FAKE_END;

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.name;
        }
    }
}

